/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.items.IDamagableItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GTUtility {
    public static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);

    public static <T> String[] mapToString(T[] array, Function<T, String> mapper) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    public static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, Class<R> declaringClass, int index) {
        Type type = thisClass.getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != declaringClass) {
            if (type instanceof ParameterizedType) {
                type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                continue;
            }
            type = ((Class)type).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)type).getActualTypeArguments()[index];
    }

    public static PotionEffect copyPotionEffect(PotionEffect sample) {
        PotionEffect potionEffect = new PotionEffect(sample.func_188419_a(), sample.func_76459_b(), sample.func_76458_c(), sample.func_82720_e(), sample.func_188418_e());
        potionEffect.setCurativeItems(sample.getCurativeItems());
        return potionEffect;
    }

    public static EnumDyeColor determineDyeColor(int rgbColor) {
        Color c = new Color(rgbColor);
        HashMap<Double, EnumDyeColor> distances = new HashMap<Double, EnumDyeColor>();
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            Color c2 = new Color(dyeColor.field_193351_w);
            double distance = (c.getRed() - c2.getRed()) * (c.getRed() - c2.getRed()) + (c.getGreen() - c2.getGreen()) * (c.getGreen() - c2.getGreen()) + (c.getBlue() - c2.getBlue()) * (c.getBlue() - c2.getBlue());
            distances.put(distance, dyeColor);
        }
        double min = (Double)Collections.min(distances.keySet());
        return (EnumDyeColor)distances.get(min);
    }

    public static int convertRGBtoOpaqueRGBA_CL(int colorValue) {
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | 0xFF;
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue) {
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static void setItem(ItemStack itemStack, ItemStack newStack) {
        try {
            Field itemField = Arrays.stream(ItemStack.class.getDeclaredFields()).filter(field -> field.getType() == Item.class).findFirst().orElseThrow(ReflectiveOperationException::new);
            itemField.setAccessible(true);
            itemField.set(itemStack, newStack.func_77973_b());
            itemStack.func_77964_b(newStack.func_77952_i());
            Method forgeInit = ItemStack.class.getDeclaredMethod("forgeInit", new Class[0]);
            forgeInit.setAccessible(true);
            forgeInit.invoke((Object)itemStack, new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.func_75214_a(itemStack) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.func_77976_d(), slot.func_178170_b(stackInSlot));
            int amountToInsert = Math.min(itemStack.func_190916_E(), slotMaxStackSize - stackInSlot.func_190916_E());
            if (amountToInsert == 0) continue;
            stackInSlot.func_190917_f(amountToInsert);
            itemStack.func_190918_g(amountToInsert);
            slot.func_75218_e();
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.func_75214_a(itemStack) || slot.func_75216_d() || (amountToInsert = Math.min(itemStack.func_190916_E(), slot.func_178170_b(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.func_77979_a(amountToInsert);
            slot.func_75215_d(stackInSlot);
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return merged;
    }

    public static boolean isBlockOrePrefixed(IBlockAccess world, BlockPos pos, IBlockState blockState, OrePrefix targetPrefix, List<ItemStack> drops) {
        for (ItemStack itemStack : drops) {
            OrePrefix orePrefix = OreDictUnifier.getPrefix(itemStack);
            if (orePrefix != targetPrefix) continue;
            return true;
        }
        return false;
    }

    public static long getBlockMaterialAmount(IBlockAccess world, BlockPos pos, IBlockState blockState, Material targetMaterial, List<ItemStack> drops) {
        for (ItemStack itemStack : drops) {
            MaterialStack materialStack = OreDictUnifier.getMaterial(itemStack);
            if (materialStack == null || materialStack.material != targetMaterial) continue;
            return materialStack.amount;
        }
        return 0L;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(Iterable<PotionEffect> potions, List<String> lines) {
        ArrayList<Tuple> attributeLines = new ArrayList<Tuple>();
        for (PotionEffect potionEffect : potions) {
            String line = I18n.func_135052_a((String)potionEffect.func_76453_d(), (Object[])new Object[0]);
            Potion potion = potionEffect.func_188419_a();
            Map attributes = potionEffect.func_188419_a().func_111186_k();
            if (!attributes.isEmpty()) {
                for (Map.Entry entry : attributes.entrySet()) {
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    attributeLines.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(potionEffect.func_76458_c(), modifier), modifier.func_111169_c())));
                }
            }
            if (potionEffect.func_76458_c() > 0) {
                line = line + " " + I18n.func_135052_a((String)("potion.potency." + potionEffect.func_76458_c()), (Object[])new Object[0]);
            }
            if (potionEffect.func_76459_b() > 20) {
                line = line + " (" + Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f) + ")";
            }
            if (potion.func_76398_f()) {
                lines.add(TextFormatting.RED + line);
                continue;
            }
            lines.add(TextFormatting.BLUE + line);
        }
        if (!attributeLines.isEmpty()) {
            lines.add("");
            lines.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]));
            for (Tuple tuple : attributeLines) {
                AttributeModifier modifier = (AttributeModifier)tuple.func_76340_b();
                double d0 = modifier.func_111164_d();
                double d1 = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lines.add(TextFormatting.BLUE + I18n.func_135052_a((String)("attribute.modifier.plus." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lines.add(TextFormatting.RED + I18n.func_135052_a((String)("attribute.modifier.take." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCenteredSizedText(int x, int y, String string, int color, double sizeMultiplier) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = fontRenderer.func_78256_a(string);
        int textHeight = fontRenderer.field_78288_b;
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)sizeMultiplier, (double)sizeMultiplier, (double)0.0);
        GlStateManager.func_179137_b((double)((double)(-textWidth) * sizeMultiplier / 2.0), (double)((double)(-textHeight) * sizeMultiplier / 2.0), (double)0.0);
        fontRenderer.func_78276_b(string, x, y, color);
        GlStateManager.func_179121_F();
    }

    public static boolean doDamageItem(ItemStack itemStack, int vanillaDamage, boolean simulate) {
        Item item = itemStack.func_77973_b();
        if (item instanceof IDamagableItem) {
            IDamagableItem damagableItem = (IDamagableItem)item;
            return damagableItem.doDamageToItem(itemStack, vanillaDamage, simulate);
        }
        if (itemStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            int energyNeeded;
            IElectricItem capability = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            return capability.discharge(energyNeeded = vanillaDamage * ConfigHolder.energyUsageMultiplier, Integer.MAX_VALUE, true, false, simulate) == (long)energyNeeded;
        }
        if (itemStack.func_77984_f()) {
            if (!simulate && itemStack.func_96631_a(vanillaDamage, new Random(), null)) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public static void writeItems(IItemHandler handler, String tagName, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a("Slot", i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, String tagName, NBTTagCompound tag) {
        if (tag.func_74764_b(tagName)) {
            NBTTagList tagList = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e("Slot");
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, new ItemStack(tagList.func_150305_b(i)));
            }
        }
    }

    public static boolean isStringValid(String aString) {
        return aString != null && !aString.isEmpty();
    }

    public static boolean isBetweenExclusive(long start, long end, long value) {
        return start < value && value < end;
    }

    public static boolean isBetweenInclusive(long start, long end, long value) {
        return start <= value && value <= end;
    }

    public static String capitalizeString(String string) {
        if (string != null && string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return "";
    }

    public static byte getTierByVoltage(long voltage) {
        byte tier = 0;
        while ((tier = (byte)((byte)(tier + 1))) < GTValues.V.length) {
            if (voltage == GTValues.V[tier]) {
                return tier;
            }
            if (voltage >= GTValues.V[tier]) continue;
            return (byte)Math.max(0, tier - 1);
        }
        return tier;
    }

    public static BiomeDictionary.Type getBiomeTypeTagByName(String name) {
        Map byName = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String[])new String[]{"byName"});
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static List<Tuple<ItemStack, Integer>> getGrassSeedEntries() {
        ArrayList<Tuple<ItemStack, Integer>> result = new ArrayList<Tuple<ItemStack, Integer>>();
        try {
            Field seedListField = ForgeHooks.class.getDeclaredField("seedList");
            seedListField.setAccessible(true);
            Class<?> seedEntryClass = Class.forName("net.minecraftforge.common.ForgeHooks$SeedEntry");
            Field seedField = seedEntryClass.getDeclaredField("seed");
            seedField.setAccessible(true);
            List seedList = (List)seedListField.get(null);
            for (WeightedRandom.Item seedEntryObject : seedList) {
                ItemStack seedStack = (ItemStack)seedField.get(seedEntryObject);
                int chanceValue = seedEntryObject.field_76292_a;
                if (seedStack.func_190926_b()) continue;
                result.add((Tuple<ItemStack, Integer>)new Tuple((Object)seedStack, (Object)chanceValue));
            }
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to get forge grass seed list", (Throwable)exception);
        }
        return result;
    }

    public static <T> int getRandomItem(Random random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.nextInt(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    @Nullable
    public static EnumFacing determineWrenchingSide(EnumFacing facing, float x, float y, float z) {
        EnumFacing opposite = facing.func_176734_d();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)z < 0.25) {
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    return EnumFacing.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.SOUTH;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
        }
        return null;
    }

    public static List<ItemStack> itemHandlerToList(final IItemHandlerModifiable inputs) {
        return new AbstractList<ItemStack>(){

            @Override
            public ItemStack set(int index, ItemStack element) {
                ItemStack oldStack = inputs.getStackInSlot(index);
                inputs.setStackInSlot(index, element == null ? ItemStack.field_190927_a : element);
                return oldStack;
            }

            @Override
            public ItemStack get(int index) {
                return inputs.getStackInSlot(index);
            }

            @Override
            public int size() {
                return inputs.getSlots();
            }
        };
    }

    public static List<FluidStack> fluidHandlerToList(IMultipleTankHandler fluidInputs) {
        final List<IFluidTank> backedList = fluidInputs.getFluidTanks();
        return new AbstractList<FluidStack>(){

            @Override
            public FluidStack set(int index, FluidStack element) {
                IFluidTank fluidTank = (IFluidTank)backedList.get(index);
                FluidStack oldStack = fluidTank.getFluid();
                if (!(fluidTank instanceof FluidTank)) {
                    return oldStack;
                }
                ((FluidTank)backedList.get(index)).setFluid(element);
                return oldStack;
            }

            @Override
            public FluidStack get(int index) {
                return ((IFluidTank)backedList.get(index)).getFluid();
            }

            @Override
            public int size() {
                return backedList.size();
            }
        };
    }

    public static boolean isWearingFullSuit(EntityLivingBase entity, Set<SimpleItemStack> suitParts) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack equipment;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !(equipment = entity.func_184582_a(slot)).func_190926_b() && suitParts.contains(new SimpleItemStack(equipment))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullFrostHazmat(EntityLivingBase entity) {
        return GTUtility.isWearingFullSuit(entity, GregTechAPI.frostHazmatList);
    }

    public static boolean isWearingFullHeatHazmat(EntityLivingBase entity) {
        return GTUtility.isWearingFullSuit(entity, GregTechAPI.heatHazmatList);
    }

    public static boolean isWearingFullBioHazmat(EntityLivingBase entity) {
        return GTUtility.isWearingFullSuit(entity, GregTechAPI.bioHazmatList);
    }

    public static boolean isWearingFullRadioHazmat(EntityLivingBase entity) {
        return GTUtility.isWearingFullSuit(entity, GregTechAPI.radioHazmatList);
    }

    public static boolean isWearingFullElectroHazmat(EntityLivingBase entity) {
        return GTUtility.isWearingFullSuit(entity, GregTechAPI.electroHazmatList);
    }

    public static boolean applyRadioactivity(EntityLivingBase entity, int level, int amountOfItems) {
        if (level > 0 && entity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && entity.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !GTUtility.isWearingFullRadioHazmat(entity)) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, level * 140 * amountOfItems));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, level * 130 * amountOfItems));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, level * 150 * amountOfItems));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, level * 130 * amountOfItems));
            entity.func_70097_a(DamageSources.getRadioactiveDamage(), (float)(level * 6 * amountOfItems));
            return true;
        }
        return false;
    }

    public static <T> boolean iterableContains(Iterable<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static int amountOfNonNullElements(List<?> collection) {
        int amount = 0;
        for (Object object : collection) {
            if (object == null) continue;
            ++amount;
        }
        return amount;
    }

    public static int amountOfNonEmptyStacks(List<ItemStack> collection) {
        int amount = 0;
        for (ItemStack object : collection) {
            if (object == null || object.func_190926_b()) continue;
            ++amount;
        }
        return amount;
    }

    public static NBTTagCompound getOrCreateNbtCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        return compound == null ? new NBTTagCompound() : compound;
    }

    public static NonNullList<ItemStack> copyStackList(List<ItemStack> itemStacks) {
        Object[] stacks = new ItemStack[itemStacks.size()];
        for (int i = 0; i < itemStacks.size(); ++i) {
            stacks[i] = GTUtility.copy(itemStacks.get(i));
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public static List<FluidStack> copyFluidList(List<FluidStack> fluidStacks) {
        Object[] stacks = new FluidStack[fluidStacks.size()];
        for (int i = 0; i < fluidStacks.size(); ++i) {
            stacks[i] = fluidStacks.get(i).copy();
        }
        return Lists.newArrayList((Object[])stacks);
    }

    public static ItemStack copy(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack copyAmount(int amount, ItemStack ... stacks) {
        ItemStack stack = GTUtility.copy(stacks);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount > 64) {
            amount = 64;
        } else if (amount == -1) {
            amount = 111;
        } else if (amount < 0) {
            amount = 0;
        }
        stack.func_190920_e(amount);
        return stack;
    }

    public static FluidStack copyAmount(int amount, FluidStack fluidStack) {
        FluidStack stack = fluidStack.copy();
        stack.amount = amount;
        return stack;
    }

    public static <T extends Comparable<T>> IBlockState[] getAllPropertyValues(IBlockState blockState, IProperty<T> property) {
        Collection allowedValues = property.func_177700_c();
        IBlockState[] resultArray = new IBlockState[allowedValues.size()];
        int index = 0;
        for (Comparable propertyValue : allowedValues) {
            resultArray[index++] = blockState.func_177226_a(property, propertyValue);
        }
        return resultArray;
    }

    public static <M, E extends M> E selectItemInList(int index, E replacement, List<? extends M> list, Class<E> minClass) {
        if (list.isEmpty()) {
            return replacement;
        }
        M maybeResult = list.size() <= index ? list.get(list.size() - 1) : (index < 0 ? list.get(0) : list.get(index));
        if (minClass.isAssignableFrom(maybeResult.getClass())) {
            return minClass.cast(maybeResult);
        }
        return replacement;
    }

    public static <M> M getItem(List<? extends M> list, int index, M replacement) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return replacement;
    }

    public static boolean isRealDimension(int dimensionID) {
        String clazzName = DimensionManager.getProvider((int)dimensionID).getClass().getName().toLowerCase();
        if (clazzName.contains("mystcraft") || clazzName.contains("twilightforest") || clazzName.contains("rftools")) {
            return true;
        }
        return GregTechAPI.dimensionalList.contains(dimensionID);
    }

    public static long createFlag(int id) {
        return 1L << id;
    }
}

