/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material;

import com.google.common.collect.ImmutableList;
import gregtech.api.GTValues;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.MarkerMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.RoughSolidMaterial;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import net.minecraft.init.Enchantments;

public class Materials {
    private static final long STD_SOLID = DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD | IngotMaterial.MatFlags.GENERATE_BOLT_SCREW;
    private static final long STD_GEM = DustMaterial.MatFlags.GENERATE_ORE | STD_SOLID | GemMaterial.MatFlags.GENERATE_LENSE;
    private static final long STD_METAL = DustMaterial.MatFlags.GENERATE_PLATE;
    private static final long EXT_METAL = STD_METAL | SolidMaterial.MatFlags.GENERATE_ROD | IngotMaterial.MatFlags.GENERATE_BOLT_SCREW;
    private static final long EXT2_METAL = EXT_METAL | SolidMaterial.MatFlags.GENERATE_GEAR | IngotMaterial.MatFlags.GENERATE_FOIL | IngotMaterial.MatFlags.GENERATE_FINE_WIRE;
    public static MarkerMaterial _NULL = new MarkerMaterial("_null");
    public static IngotMaterial Aluminium = new IngotMaterial(1, "aluminium", 8440048, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | DustMaterial.MatFlags.GENERATE_ORE | IngotMaterial.MatFlags.GENERATE_RING | SolidMaterial.MatFlags.GENERATE_FRAME, Element.Al, 10.0f, 2.0f, 128, 1700);
    public static IngotMaterial Americium = new IngotMaterial(2, "americium", 0xC8C8C8, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | SolidMaterial.MatFlags.GENERATE_ROD | SolidMaterial.MatFlags.GENERATE_LONG_ROD, Element.Am);
    public static IngotMaterial Antimony = new IngotMaterial(3, "antimony", 0xDCDCC8, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE, Element.Sb);
    public static FluidMaterial Argon = new FluidMaterial(4, "argon", 0xBBBB00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.Ar);
    public static DustMaterial Arsenic = new DustMaterial(5, "arsenic", 0xDDDDDD, MaterialIconSet.SAND, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.As);
    public static IngotMaterial Barium = new IngotMaterial(6, "barium", 0xFFFFFF, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Ba);
    public static IngotMaterial Beryllium = new IngotMaterial(7, "beryllium", 0x64B464, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Be);
    public static IngotMaterial Bismuth = new IngotMaterial(8, "bismuth", 6594720, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_ORE, Element.Bi);
    public static DustMaterial Boron = new DustMaterial(9, "boron", 13824210, MaterialIconSet.SAND, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.B);
    public static IngotMaterial Caesium = new IngotMaterial(10, "caesium", 0xFFFFFC, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Cs);
    public static IngotMaterial Calcium = new IngotMaterial(11, "calcium", 0xDDDDAA, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Ca);
    public static IngotMaterial Carbon = new IngotMaterial(12, "carbon", 0x333333, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.C);
    public static IngotMaterial Cadmium = new IngotMaterial(13, "cadmium", 0x505060, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Cd);
    public static IngotMaterial Cerium = new IngotMaterial(14, "cerium", 0xEEEEEE, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Ce, 1068);
    public static FluidMaterial Chlorine = new FluidMaterial(15, "chlorine", 0xEEEECC, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.Cl);
    public static IngotMaterial Chrome = new IngotMaterial(16, "chrome", 0xFFAAAB, MaterialIconSet.SHINY, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR, Element.Cr, 12.0f, 3.0f, 512, 1700);
    public static IngotMaterial Cobalt = new IngotMaterial(17, "cobalt", 2697660, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_ORE | STD_SOLID, Element.Co, 10.0f, 3.0f, 256);
    public static IngotMaterial Copper = new IngotMaterial(18, "copper", 0xFF8000, MaterialIconSet.SHINY, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_DENSE, Element.Cu);
    public static FluidMaterial Deuterium = new FluidMaterial(19, "deuterium", 0xEEEE00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.D);
    public static IngotMaterial Dysprosium = new IngotMaterial(20, "dysprosium", 0xFFFFEE, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Dy, 1680);
    public static IngotMaterial Erbium = new IngotMaterial(21, "erbium", 0xEEEEEE, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Er, 1802);
    public static IngotMaterial Europium = new IngotMaterial(22, "europium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | SolidMaterial.MatFlags.GENERATE_ROD, Element.Eu, 1099);
    public static FluidMaterial Fluorine = new FluidMaterial(23, "fluorine", 0xFFFFAA, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.F).setFluidTemperature(253);
    public static IngotMaterial Gadolinium = new IngotMaterial(24, "gadolinium", 0xDDDDFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Gd, 1585);
    public static IngotMaterial Gallium = new IngotMaterial(25, "gallium", 0xEEEEFF, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_PLATE, Element.Ga);
    public static IngotMaterial Gold = new IngotMaterial(26, "gold", 0xFFFF00, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE, Element.Au);
    public static IngotMaterial Holmium = new IngotMaterial(27, "holmium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Ho, 1734);
    public static FluidMaterial Hydrogen = new FluidMaterial(28, "hydrogen", 65450, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.H);
    public static FluidMaterial Helium = new FluidMaterial(29, "helium", 0xDDDD00, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.He);
    public static FluidMaterial Helium3 = new FluidMaterial(30, "helium3", 0xDDDD00, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.He_3);
    public static IngotMaterial Indium = new IngotMaterial(31, "indium", 0x6600BB, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.In);
    public static IngotMaterial Iridium = new IngotMaterial(32, "iridium", 0xFFFFFF, MaterialIconSet.DULL, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_ORE | EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR, Element.Ir, 7.0f, 3.0f, 2560, 2719);
    public static IngotMaterial Iron = new IngotMaterial(33, "iron", 0xAAAAAA, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_DENSE | SolidMaterial.MatFlags.GENERATE_FRAME | SolidMaterial.MatFlags.GENERATE_LONG_ROD | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.Fe, 7.0f, 2.5f, 256);
    public static IngotMaterial Lanthanum = new IngotMaterial(34, "lanthanum", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.La, 1193);
    public static IngotMaterial Lead = new IngotMaterial(35, "lead", 9200780, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_DENSE, Element.Pb);
    public static IngotMaterial Lithium = new IngotMaterial(36, "lithium", 0xCBCBCB, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Li);
    public static IngotMaterial Lutetium = new IngotMaterial(37, "lutetium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Lu, 1925);
    public static IngotMaterial Magnesium = new IngotMaterial(38, "magnesium", 0xFFBBBB, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.Mg);
    public static IngotMaterial Manganese = new IngotMaterial(39, "manganese", 0xEEEEEE, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), IngotMaterial.MatFlags.GENERATE_FOIL, Element.Mn, 7.0f, 2.0f, 512);
    public static FluidMaterial Mercury = new FluidMaterial(40, "mercury", 0xFFDDDD, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.SMELT_INTO_FLUID, Element.Hg);
    public static IngotMaterial Molybdenum = new IngotMaterial(41, "molybdenum", 0xAAAADD, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_ORE, Element.Mo, 7.0f, 2.0f, 512);
    public static IngotMaterial Neodymium = new IngotMaterial(42, "neodymium", 0x777777, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | SolidMaterial.MatFlags.GENERATE_ROD | DustMaterial.MatFlags.GENERATE_ORE, Element.Nd, 7.0f, 2.0f, 512, 1297);
    public static IngotMaterial Darmstadtium = new IngotMaterial(43, "darmstadtium", 0xAAAAAA, MaterialIconSet.METALLIC, 6, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | SolidMaterial.MatFlags.GENERATE_FRAME, Element.Ds, 24.0f, 6.0f, 155360);
    public static IngotMaterial Nickel = new IngotMaterial(44, "nickel", 0xAAAAFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.Ni);
    public static IngotMaterial Niobium = new IngotMaterial(45, "niobium", 9733802, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Nb, 2750);
    public static FluidMaterial Nitrogen = new FluidMaterial(46, "nitrogen", 7377071, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.N);
    public static IngotMaterial Osmium = new IngotMaterial(47, "osmium", 0x5050FF, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_ORE | EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR, Element.Os, 16.0f, 4.0f, 1280, 3306);
    public static FluidMaterial Oxygen = new FluidMaterial(48, "oxygen", 9480942, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | FluidMaterial.MatFlags.GENERATE_PLASMA, Element.O);
    public static IngotMaterial Palladium = new IngotMaterial(49, "palladium", 13553885, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Pd, 8.0f, 2.0f, 512, 1228);
    public static DustMaterial Phosphorus = new DustMaterial(50, "phosphorus", 0xC8C800, MaterialIconSet.SAND, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L, Element.P);
    public static IngotMaterial Platinum = new IngotMaterial(51, "platinum", 0xFFFF99, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Pt);
    public static IngotMaterial Plutonium = new IngotMaterial(52, "plutonium", 15741490, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Pu);
    public static IngotMaterial Plutonium241 = new IngotMaterial(53, "plutonium241", 16401990, MaterialIconSet.SHINY, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Pu_241);
    public static IngotMaterial Potassium = new IngotMaterial(54, "potassium", 0xCECECE, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.K);
    public static IngotMaterial Praseodymium = new IngotMaterial(55, "praseodymium", 0xCECECE, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Pr, 1208);
    public static IngotMaterial Promethium = new IngotMaterial(56, "promethium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Pm, 1315);
    public static FluidMaterial Radon = new FluidMaterial(57, "radon", 0xFF00FF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.Rn);
    public static IngotMaterial Rubidium = new IngotMaterial(58, "rubidium", 15736350, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Rb);
    public static IngotMaterial Samarium = new IngotMaterial(59, "samarium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Sm, 1345);
    public static IngotMaterial Scandium = new IngotMaterial(60, "scandium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Sc, 1814);
    public static IngotMaterial Silicon = new IngotMaterial(61, "silicon", 3947600, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | IngotMaterial.MatFlags.GENERATE_FOIL, Element.Si, 1687);
    public static IngotMaterial Silver = new IngotMaterial(62, "silver", 0xDCDCFF, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE, Element.Ag);
    public static IngotMaterial Sodium = new IngotMaterial(63, "sodium", 150, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Na);
    public static IngotMaterial Strontium = new IngotMaterial(64, "strontium", 13158550, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Sr);
    public static DustMaterial Sulfur = new DustMaterial(65, "sulfur", 0xC8C800, MaterialIconSet.SAND, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.GENERATE_ORE, Element.S);
    public static IngotMaterial Tantalum = new IngotMaterial(66, "tantalum", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Ta);
    public static IngotMaterial Tellurium = new IngotMaterial(67, "tellurium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Te);
    public static IngotMaterial Terbium = new IngotMaterial(68, "terbium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Tb, 1629);
    public static IngotMaterial Thorium = new IngotMaterial(69, "thorium", 7680, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Th, 6.0f, 2.0f, 512);
    public static IngotMaterial Thulium = new IngotMaterial(70, "thulium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Tm, 1818);
    public static IngotMaterial Tin = new IngotMaterial(71, "tin", 0xDCDCDC, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | DustMaterial.MatFlags.GENERATE_ORE, Element.Sn);
    public static IngotMaterial Titanium = new IngotMaterial(72, "titanium", 14459120, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | IngotMaterial.MatFlags.GENERATE_SPRING | SolidMaterial.MatFlags.GENERATE_FRAME, Element.Ti, 7.0f, 3.0f, 1600, 1941);
    public static FluidMaterial Tritium = new FluidMaterial(73, "tritium", 0xFF0000, MaterialIconSet.METALLIC, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS, Element.T);
    public static IngotMaterial Tungsten = new IngotMaterial(74, "tungsten", 0x323232, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT2_METAL, Element.W, 7.0f, 3.0f, 2560, 3000);
    public static IngotMaterial Uranium = new IngotMaterial(75, "uranium", 3338290, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.U, 6.0f, 3.0f, 512);
    public static IngotMaterial Uranium235 = new IngotMaterial(76, "uranium235", 4651590, MaterialIconSet.SHINY, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.GENERATE_ROD, Element.U_235, 6.0f, 3.0f, 512);
    public static IngotMaterial Vanadium = new IngotMaterial(77, "vanadium", 0x323232, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.V, 2183);
    public static IngotMaterial Ytterbium = new IngotMaterial(353, "ytterbium", 0xFFFFFF, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Yb, 1097);
    public static IngotMaterial Yttrium = new IngotMaterial(78, "yttrium", 14482140, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL, Element.Y, 1799);
    public static IngotMaterial Zinc = new IngotMaterial(79, "zinc", 0xFAF0F0, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_METAL | DustMaterial.MatFlags.GENERATE_ORE | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_FOIL, Element.Zn);
    public static FluidMaterial Methane = new FluidMaterial(80, "methane", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 4L)), 0L);
    public static FluidMaterial CarbonDioxide = new FluidMaterial(81, "carbon_dioxide", 11129077, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static FluidMaterial NobleGases = new FluidMaterial(82, "noble_gases", 11129077, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(CarbonDioxide, 25L), (Object)new MaterialStack(Helium, 11L), (Object)new MaterialStack(Methane, 4L), (Object)new MaterialStack(Deuterium, 2L), (Object)new MaterialStack(Radon, 1L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static FluidMaterial Air = new FluidMaterial(83, "air", 11129077, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 40L), (Object)new MaterialStack(Oxygen, 11L), (Object)new MaterialStack(Argon, 1L), (Object)new MaterialStack(NobleGases, 1L)), FluidMaterial.MatFlags.STATE_GAS | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial LiquidAir = new FluidMaterial(84, "liquid_air", 11129077, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 40L), (Object)new MaterialStack(Oxygen, 11L), (Object)new MaterialStack(Argon, 1L), (Object)new MaterialStack(NobleGases, 1L)), FluidMaterial.MatFlags.STATE_GAS | Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static GemMaterial Almandine = new GemMaterial(85, "almandine", 0xFF0000, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Iron, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), STD_GEM);
    public static DustMaterial Andradite = new DustMaterial(86, "andradite", 9861120, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 3L), (Object)new MaterialStack(Iron, 2L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), 0L);
    public static IngotMaterial AnnealedCopper = new IngotMaterial(87, "annealed_copper", 16742420, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static DustMaterial Asbestos = new DustMaterial(88, "asbestos", 0xE6E6E6, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 3L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 9L)), 0L);
    public static DustMaterial Ash = new DustMaterial(89, "ash", 0x969696, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), 0L);
    public static DustMaterial BandedIron = new DustMaterial(90, "banded_iron", 9525850, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 2L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static IngotMaterial BatteryAlloy = new IngotMaterial(91, "battery_alloy", 10255520, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lead, 4L), (Object)new MaterialStack(Antimony, 1L)), EXT_METAL);
    public static GemMaterial BlueTopaz = new GemMaterial(92, "blue_topaz", 255, MaterialIconSet.GEM_HORIZONTAL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Fluorine, 2L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 6L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 7.0f, 3.0f, 256);
    public static DustMaterial Bone = new DustMaterial(93, "bone", 0xFFFFFF, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L)), 0L);
    public static IngotMaterial Brass = new IngotMaterial(94, "brass", 16757760, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Copper, 3L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING, 8.0f, 3.0f, 152);
    public static IngotMaterial Bronze = new IngotMaterial(95, "bronze", 0xFF8000, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tin, 1L), (Object)new MaterialStack(Copper, 3L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | SolidMaterial.MatFlags.GENERATE_FRAME | SolidMaterial.MatFlags.GENERATE_LONG_ROD, 6.0f, 2.5f, 192);
    public static DustMaterial BrownLimonite = new DustMaterial(96, "brown_limonite", 13132800, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Calcite = new DustMaterial(97, "calcite", 16443100, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Cassiterite = new DustMaterial(98, "cassiterite", 0xDCDCDC, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tin, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial CassiteriteSand = new DustMaterial(99, "cassiterite_sand", 0xDCDCDC, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tin, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Chalcopyrite = new DustMaterial(100, "chalcopyrite", 10516520, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Sulfur, 2L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static GemMaterial Charcoal = new GemMaterial(101, "charcoal", 0x644646, MaterialIconSet.LIGNITE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static DustMaterial Chromite = new DustMaterial(102, "chromite", 2298895, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Chrome, 2L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE, null);
    public static GemMaterial Cinnabar = new GemMaterial(103, "cinnabar", 0x960000, MaterialIconSet.EMERALD, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Mercury, 1L), (Object)new MaterialStack(Sulfur, 1L)), DustMaterial.MatFlags.GENERATE_ORE | GemMaterial.MatFlags.CRYSTALLISABLE);
    public static FluidMaterial Water = new FluidMaterial(104, "water", 255, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 1L)), Material.MatFlags.NO_RECYCLING);
    public static DustMaterial Clay = new DustMaterial(105, "clay", 0xC8C8DC, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 2L), (Object)new MaterialStack(Lithium, 1L), (Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Water, 6L)), SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static GemMaterial Coal = new GemMaterial(106, "coal", 0x464646, MaterialIconSet.LIGNITE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static DustMaterial Cobaltite = new DustMaterial(107, "cobaltite", 5263610, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Cobalt, 1L), (Object)new MaterialStack(Arsenic, 1L), (Object)new MaterialStack(Sulfur, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Cooperite = new DustMaterial(108, "cooperite", 0xFFFFC8, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Platinum, 3L), (Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Palladium, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static IngotMaterial Cupronickel = new IngotMaterial(109, "cupronickel", 14915200, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Nickel, 1L)), EXT_METAL);
    public static DustMaterial DarkAsh = new DustMaterial(110, "dark_ash", 0x323232, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static GemMaterial Diamond = new GemMaterial(111, "diamond", 0xC8FFFF, MaterialIconSet.DIAMOND, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), SolidMaterial.MatFlags.GENERATE_ROD | IngotMaterial.MatFlags.GENERATE_BOLT_SCREW | GemMaterial.MatFlags.GENERATE_LENSE | SolidMaterial.MatFlags.GENERATE_GEAR | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT | DustMaterial.MatFlags.GENERATE_ORE, 8.0f, 3.0f, 1280);
    public static IngotMaterial Electrum = new IngotMaterial(112, "electrum", 0xFFFF64, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Silver, 1L), (Object)new MaterialStack(Gold, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static GemMaterial Emerald = new GemMaterial(113, "emerald", 0x50FF50, MaterialIconSet.EMERALD, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Beryllium, 3L), (Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 6L), (Object)new MaterialStack(Oxygen, 18L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 10.0f, 2.0f, 368);
    public static DustMaterial Galena = new DustMaterial(114, "galena", 6569060, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lead, 3L), (Object)new MaterialStack(Silver, 3L), (Object)new MaterialStack(Sulfur, 2L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMELTING);
    public static DustMaterial Garnierite = new DustMaterial(115, "garnierite", 3328070, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static FluidMaterial Glyceryl = new FluidMaterial(116, "glyceryl", 38550, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 5L), (Object)new MaterialStack(Nitrogen, 3L), (Object)new MaterialStack(Oxygen, 9L)), Material.MatFlags.FLAMMABLE | Material.MatFlags.EXPLOSIVE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING);
    public static GemMaterial GreenSapphire = new GemMaterial(117, "green_sapphire", 6604930, MaterialIconSet.GEM_HORIZONTAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT | GemMaterial.MatFlags.GENERATE_LENSE, 8.0f, 3.0f, 368);
    public static DustMaterial Grossular = new DustMaterial(118, "grossular", 13132800, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 3L), (Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static FluidMaterial DistilledWater = new FluidMaterial(119, "distilled_water", 255, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 1L)), Material.MatFlags.NO_RECYCLING);
    public static DustMaterial Ice = new DustMaterial(120, "ice", 0xC8C8FF, MaterialIconSet.ROUGH, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.NO_SMASHING | Material.MatFlags.NO_RECYCLING | DustMaterial.MatFlags.SMELT_INTO_FLUID | DustMaterial.MatFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static DustMaterial Ilmenite = new DustMaterial(121, "ilmenite", 4601650, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Titanium, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static GemMaterial Rutile = new GemMaterial(122, "rutile", 13897052, MaterialIconSet.GEM_HORIZONTAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Titanium, 1L), (Object)new MaterialStack(Oxygen, 2L)), STD_GEM | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static DustMaterial Bauxite = new DustMaterial(123, "bauxite", 13132800, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Rutile, 2L), (Object)new MaterialStack(Aluminium, 16L), (Object)new MaterialStack(Hydrogen, 10L), (Object)new MaterialStack(Oxygen, 11L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static FluidMaterial TitaniumTetrachloride = new FluidMaterial(124, "titanium_tetrachloride", 13897052, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Titanium, 1L), (Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Chlorine, 2L)), Material.MatFlags.DISABLE_DECOMPOSITION).setFluidTemperature(2200);
    public static DustMaterial MagnesiumChloride = new DustMaterial(125, "magnesium_chloride", 13897052, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Chlorine, 2L)), 0L);
    public static IngotMaterial Invar = new IngotMaterial(126, "invar", 11842680, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 2L), (Object)new MaterialStack(Nickel, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | SolidMaterial.MatFlags.GENERATE_FRAME, 7.0f, 3.0f, 512);
    public static IngotMaterial Kanthal = new IngotMaterial(127, "kanthal", 12767967, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Aluminium, 1L), (Object)new MaterialStack(Chrome, 1L)), EXT_METAL, null, 1800);
    public static GemMaterial Lazurite = new GemMaterial(128, "lazurite", 6584575, MaterialIconSet.LAPIS, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 6L), (Object)new MaterialStack(Silicon, 6L), (Object)new MaterialStack(Calcium, 8L), (Object)new MaterialStack(Sodium, 8L)), DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | SolidMaterial.MatFlags.GENERATE_ROD | Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING);
    public static IngotMaterial Magnalium = new IngotMaterial(129, "magnalium", 13156095, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Aluminium, 2L)), EXT2_METAL | SolidMaterial.MatFlags.GENERATE_LONG_ROD, 6.0f, 2.0f, 256);
    public static DustMaterial Magnesite = new DustMaterial(130, "magnesite", 16448180, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Magnetite = new DustMaterial(131, "magnetite", 0x1E1E1E, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 3L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Molybdenite = new DustMaterial(132, "molybdenite", 0x191919, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Molybdenum, 1L), (Object)new MaterialStack(Sulfur, 2L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static IngotMaterial Nichrome = new IngotMaterial(133, "nichrome", 13487862, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 4L), (Object)new MaterialStack(Chrome, 1L)), EXT_METAL, null, 2700);
    public static IngotMaterial NiobiumNitride = new IngotMaterial(134, "niobium_nitride", 1911069, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Niobium, 1L), (Object)new MaterialStack(Nitrogen, 1L)), EXT_METAL, null, 2573);
    public static IngotMaterial NiobiumTitanium = new IngotMaterial(135, "niobium_titanium", 1908009, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Niobium, 1L), (Object)new MaterialStack(Titanium, 1L)), EXT2_METAL, null, 4500);
    public static FluidMaterial NitroCarbon = new FluidMaterial(136, "nitro_carbon", 19300, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Carbon, 1L)), 0L);
    public static FluidMaterial NitrogenDioxide = new FluidMaterial(137, "nitrogen_dioxide", 6598655, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static DustMaterial Obsidian = new DustMaterial(138, "obsidian", 5255780, MaterialIconSet.DULL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Oxygen, 8L)), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES);
    public static DustMaterial Phosphate = new DustMaterial(139, "phosphate", 0xFFFF00, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Phosphorus, 1L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE | Material.MatFlags.EXPLOSIVE);
    public static IngotMaterial PigIron = new IngotMaterial(140, "pig_iron", 13153460, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L)), EXT_METAL | IngotMaterial.MatFlags.GENERATE_RING, 6.0f, 4.0f, 384);
    public static IngotMaterial Plastic = new IngotMaterial(141, "plastic", 0xC8C8C8, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 2L)), DustMaterial.MatFlags.GENERATE_PLATE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.SMELT_INTO_FLUID);
    public static IngotMaterial Epoxid = new IngotMaterial(142, "epoxid", 13143060, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 1L)), EXT2_METAL);
    public static DustMaterial Silicone = new DustMaterial(143, "silicone", 0xDCDCDC, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_PLATE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.SMELT_INTO_FLUID);
    public static IngotMaterial Polycaprolactam = new IngotMaterial(144, "polycaprolactam", 0x323232, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 11L), (Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_PLATE);
    public static IngotMaterial Polytetrafluoroethylene = new IngotMaterial(145, "polytetrafluoroethylene", 0x646464, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Fluorine, 4L)), DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.SMELT_INTO_FLUID | DustMaterial.MatFlags.NO_WORKING);
    public static DustMaterial Powellite = new DustMaterial(146, "powellite", 0xFFFF00, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Molybdenum, 1L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Pyrite = new DustMaterial(148, "pyrite", 9861160, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Sulfur, 2L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static DustMaterial Pyrolusite = new DustMaterial(149, "pyrolusite", 0x9696AA, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Manganese, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Pyrope = new DustMaterial(150, "pyrope", 7877220, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Magnesium, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial RockSalt = new DustMaterial(151, "rock_salt", 15780040, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Chlorine, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING);
    public static IngotMaterial Rubber = new IngotMaterial(152, "rubber", 0x151515, MaterialIconSet.ROUGH, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 5L), (Object)new MaterialStack(Hydrogen, 8L)), DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_GEAR | IngotMaterial.MatFlags.GENERATE_RING | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMASHING | IngotMaterial.MatFlags.GENERATE_RING | DustMaterial.MatFlags.NO_WORKING);
    public static DustMaterial RawRubber = new DustMaterial(153, "raw_rubber", 13420425, MaterialIconSet.SAND, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 5L), (Object)new MaterialStack(Hydrogen, 8L)), 0L);
    public static GemMaterial Ruby = new GemMaterial(154, "ruby", 12405065, MaterialIconSet.RUBY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Chrome, 1L), (Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Oxygen, 3L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 8.5f, 3.0f, 256);
    public static DustMaterial Salt = new DustMaterial(155, "salt", 0xFFFFFF, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Chlorine, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Saltpeter = new DustMaterial(156, "saltpeter", 0xE6E6E6, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE);
    public static GemMaterial Sapphire = new GemMaterial(157, "sapphire", 6579400, MaterialIconSet.GEM_VERTICAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Oxygen, 3L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, null, 7.5f, 4.0f, 256);
    public static DustMaterial Scheelite = new DustMaterial(158, "scheelite", 13143060, MaterialIconSet.DULL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tungsten, 1L), (Object)new MaterialStack(Calcium, 2L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.DECOMPOSITION_REQUIRES_HYDROGEN);
    public static DustMaterial SiliconDioxide = new DustMaterial(159, "silicon_dioxide", 0xC8C8C8, MaterialIconSet.QUARTZ, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE);
    public static GemMaterial Sodalite = new GemMaterial(161, "sodalite", 0x1414FF, MaterialIconSet.LAPIS, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Sodium, 4L), (Object)new MaterialStack(Chlorine, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | SolidMaterial.MatFlags.GENERATE_ROD | Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING);
    public static FluidMaterial SodiumPersulfate = new FluidMaterial(162, "sodium_persulfate", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L)), 0L);
    public static DustMaterial SodiumSulfide = new DustMaterial(163, "sodium_sulfide", 0xAAAA00, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 2L), (Object)new MaterialStack(Sulfur, 1L)), 0L);
    public static FluidMaterial HydrogenSulfide = new FluidMaterial(164, "hydrogen_sulfide", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Sulfur, 1L)), 0L);
    public static FluidMaterial Steam = new FluidMaterial(346, "steam", 0xFFFFFF, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 1L)), Material.MatFlags.NO_RECYCLING | FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK).setFluidTemperature(380);
    public static FluidMaterial Epichlorhydrin = new FluidMaterial(349, "epichlorhydrin", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 5L), (Object)new MaterialStack(Chlorine, 1L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial NitricAcid = new FluidMaterial(351, "nitric_acid", 0xCCCC00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Oxygen, 3L)), 0L);
    public static DustMaterial Brick = new DustMaterial(355, "brick", 12016192, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Clay, 1L)), DustMaterial.MatFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES | Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static DustMaterial Fireclay = new DustMaterial(356, "fireclay", 9601139, MaterialIconSet.FINE, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Clay, 1L), (Object)new MaterialStack(Brick, 1L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static GemMaterial Coke = new GemMaterial(357, "coke", 0x666666, MaterialIconSet.LIGNITE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L)), Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static IngotMaterial SolderingAlloy = new IngotMaterial(180, "soldering_alloy", 14474470, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tin, 9L), (Object)new MaterialStack(Antimony, 1L)), EXT_METAL | IngotMaterial.MatFlags.GENERATE_FINE_WIRE, null);
    public static DustMaterial Spessartine = new DustMaterial(181, "spessartine", 0xFF6464, MaterialIconSet.GEM_VERTICAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Manganese, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Sphalerite = new DustMaterial(182, "sphalerite", 0xFFFFFF, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Sulfur, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static IngotMaterial StainlessSteel = new IngotMaterial(183, "stainless_steel", 0xC8C8DC, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 6L), (Object)new MaterialStack(Chrome, 1L), (Object)new MaterialStack(Manganese, 1L), (Object)new MaterialStack(Nickel, 1L)), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_FRAME | SolidMaterial.MatFlags.GENERATE_LONG_ROD, null, 7.0f, 4.0f, 480, 1700);
    public static IngotMaterial Steel = new IngotMaterial(184, "steel", 0x505050, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | IngotMaterial.MatFlags.GENERATE_DENSE | Material.MatFlags.DISABLE_DECOMPOSITION | SolidMaterial.MatFlags.GENERATE_FRAME | SolidMaterial.MatFlags.GENERATE_LONG_ROD, null, 6.0f, 3.0f, 512, 1000);
    public static DustMaterial Stibnite = new DustMaterial(185, "stibnite", 0x464646, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Antimony, 2L), (Object)new MaterialStack(Sulfur, 3L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static FluidMaterial SulfuricAcid = new FluidMaterial(186, "sulfuric_acid", 0xFF8000, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L)), 0L);
    public static GemMaterial Tanzanite = new GemMaterial(187, "tanzanite", 4194504, MaterialIconSet.GEM_VERTICAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 2L), (Object)new MaterialStack(Aluminium, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Oxygen, 13L)), EXT_METAL | DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, null, 7.0f, 2.0f, 256);
    public static DustMaterial Tetrahedrite = new DustMaterial(188, "tetrahedrite", 13115392, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 3L), (Object)new MaterialStack(Antimony, 1L), (Object)new MaterialStack(Sulfur, 3L), (Object)new MaterialStack(Iron, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static IngotMaterial TinAlloy = new IngotMaterial(189, "tin_alloy", 0xC8C8C8, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tin, 1L), (Object)new MaterialStack(Iron, 1L)), EXT2_METAL, null);
    public static GemMaterial Topaz = new GemMaterial(190, "topaz", 0xFF8000, MaterialIconSet.GEM_HORIZONTAL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Fluorine, 2L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 6L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, null, 7.0f, 2.0f, 256);
    public static DustMaterial Tungstate = new DustMaterial(191, "tungstate", 0x373223, MaterialIconSet.DULL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tungsten, 1L), (Object)new MaterialStack(Lithium, 2L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.DECOMPOSITION_REQUIRES_HYDROGEN, null);
    public static IngotMaterial Ultimet = new IngotMaterial(192, "ultimet", 11842790, MaterialIconSet.SHINY, 4, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Cobalt, 5L), (Object)new MaterialStack(Chrome, 2L), (Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Molybdenum, 1L)), EXT2_METAL, null, 9.0f, 4.0f, 2048, 2700);
    public static DustMaterial Uraninite = new DustMaterial(193, "uraninite", 0x232323, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Uranium, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static DustMaterial Uvarovite = new DustMaterial(194, "uvarovite", 0xB4FFB4, MaterialIconSet.GEM_VERTICAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 3L), (Object)new MaterialStack(Chrome, 2L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 12L)), 0L);
    public static IngotMaterial VanadiumGallium = new IngotMaterial(195, "vanadium_gallium", 0x80808C, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Vanadium, 3L), (Object)new MaterialStack(Gallium, 1L)), STD_METAL | IngotMaterial.MatFlags.GENERATE_FOIL | SolidMaterial.MatFlags.GENERATE_ROD, null, 4500);
    public static IngotMaterial WroughtIron = new IngotMaterial(197, "wrought_iron", 13153460, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | SolidMaterial.MatFlags.GENERATE_LONG_ROD | Material.MatFlags.DISABLE_DECOMPOSITION, null, 6.0f, 3.5f, 384);
    public static DustMaterial Wulfenite = new DustMaterial(198, "wulfenite", 0xFF8000, MaterialIconSet.DULL, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lead, 1L), (Object)new MaterialStack(Molybdenum, 1L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial YellowLimonite = new DustMaterial(199, "yellow_limonite", 0xC8C800, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Oxygen, 2L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static IngotMaterial YttriumBariumCuprate = new IngotMaterial(200, "yttrium_barium_cuprate", 5259334, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Yttrium, 1L), (Object)new MaterialStack(Barium, 2L), (Object)new MaterialStack(Copper, 3L), (Object)new MaterialStack(Oxygen, 7L)), EXT_METAL | IngotMaterial.MatFlags.GENERATE_FOIL | IngotMaterial.MatFlags.GENERATE_FINE_WIRE, null, 4500);
    public static GemMaterial NetherQuartz = new GemMaterial(201, "nether_quartz", 15127250, MaterialIconSet.QUARTZ, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_SOLID | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | DustMaterial.MatFlags.GENERATE_ORE);
    public static GemMaterial CertusQuartz = new GemMaterial(202, "certus_quartz", 13816550, MaterialIconSet.QUARTZ, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_SOLID | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | DustMaterial.MatFlags.GENERATE_ORE);
    public static GemMaterial Quartzite = new GemMaterial(203, "quartzite", 13821650, MaterialIconSet.QUARTZ, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | DustMaterial.MatFlags.GENERATE_ORE);
    public static IngotMaterial Graphite = new IngotMaterial(204, "graphite", 0x808080, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE);
    public static IngotMaterial Graphene = new IngotMaterial(205, "graphene", 0x808080, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_PLATE);
    public static GemMaterial Jasper = new GemMaterial(206, "jasper", 13127760, MaterialIconSet.EMERALD, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_GEM | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT);
    public static IngotMaterial Osmiridium = new IngotMaterial(207, "osmiridium", 0x6464FF, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iridium, 3L), (Object)new MaterialStack(Osmium, 1L)), EXT2_METAL, null, 9.0f, 3.0f, 3152, 2500);
    public static FluidMaterial NitrationMixture = new FluidMaterial(352, "nitration_mixture", 0xEEEEAA, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(NitricAcid, 1L), (Object)new MaterialStack(SulfuricAcid, 1L)), 0L);
    public static DustMaterial Tenorite = new DustMaterial(358, "tenorite", 0x606060, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Cuprite = new DustMaterial(359, "cuprite", 0x770000, MaterialIconSet.RUBY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 2L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Bornite = new DustMaterial(360, "bornite", 12654592, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 5L), (Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(Sulfur, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Chalcocite = new DustMaterial(361, "chalcocite", 0x353535, MaterialIconSet.GEM_VERTICAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 2L), (Object)new MaterialStack(Sulfur, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Enargite = new DustMaterial(362, "enargite", 0xBBBBBB, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 3L), (Object)new MaterialStack(Arsenic, 1L), (Object)new MaterialStack(Sulfur, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Tennantite = new DustMaterial(363, "tennantite", 0x909090, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 12L), (Object)new MaterialStack(Arsenic, 4L), (Object)new MaterialStack(Sulfur, 13L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial PhosphorousPentoxide = new DustMaterial(466, "phosphorous_pentoxide", 8158464, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Phosphorus, 4L), (Object)new MaterialStack(Oxygen, 10L)), 0L);
    public static FluidMaterial PhosphoricAcid = new FluidMaterial(467, "phosphoric_acid", 11447824, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 3L), (Object)new MaterialStack(Phosphorus, 4L)), 0L);
    public static DustMaterial SodiumHydroxide = new DustMaterial(373, "sodium_hydroxide", 6466, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Oxygen, 1L), (Object)new MaterialStack(Hydrogen, 1L)), 0L);
    public static DustMaterial Quicklime = new DustMaterial(374, "quicklime", 0x808080, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial SulfurTrioxide = new FluidMaterial(376, "sulfur_trioxide", 8618781, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 3L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial SulfurDioxide = new FluidMaterial(377, "sulfur_dioxide", 10263584, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 2L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial CarbonMonoxde = new FluidMaterial(380, "carbon_monoxide", 1655660, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Oxygen, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial DilutedSulfuricAcid = new FluidMaterial(381, "diluted_sulfuric_acid", 9987366, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static DustMaterial SodiumBisulfate = new DustMaterial(382, "sodium_bisulfate", 10291, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial Chloroform = new FluidMaterial(383, "chloroform", 7351936, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Chlorine, 3L)), 0L);
    public static FluidMaterial DilutedHydrochloricAcid = new FluidMaterial(384, "diluted_hydrochloric_acid", 8160900, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Chlorine, 1L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial HypochlorousAcid = new FluidMaterial(385, "hypochlorous_acid", 6123637, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Chlorine, 1L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial Ammonia = new FluidMaterial(386, "ammonia", 4011371, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Hydrogen, 3L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Chloramine = new FluidMaterial(387, "chloramine", 4031340, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Chlorine, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static IngotMaterial GalliumArsenide = new IngotMaterial(410, "gallium_arsenide", 0x727272, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Arsenic, 1L), (Object)new MaterialStack(Gallium, 1L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING | DustMaterial.MatFlags.GENERATE_PLATE, null, 1200);
    public static DustMaterial Potash = new DustMaterial(402, "potash", 5057059, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 2L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static DustMaterial SodaAsh = new DustMaterial(403, "soda_ash", 0x757588, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 2L), (Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Oxygen, 3L)), 0L);
    public static FluidMaterial NickelSulfateSolution = new FluidMaterial(412, "nickel_sulfate_water_solution", 4109888, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L), (Object)new MaterialStack(Water, 6L)), 0L);
    public static FluidMaterial CopperSulfateSolution = new FluidMaterial(413, "blue_vitriol_water_solution", 4761024, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L), (Object)new MaterialStack(Water, 5L)), 0L);
    public static FluidMaterial Cumene = new FluidMaterial(420, "cumene", 4924684, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 9L), (Object)new MaterialStack(Hydrogen, 12L)), 0L);
    public static IngotMaterial IndiumGalliumPhosphide = new IngotMaterial(421, "indium_gallium_phosphide", 8220052, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Indium, 1L), (Object)new MaterialStack(Gallium, 1L), (Object)new MaterialStack(Phosphorus, 1L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING | DustMaterial.MatFlags.GENERATE_PLATE);
    public static DustMaterial FerriteMixture = new DustMaterial(423, "ferrite_mixture", 0x959595, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Iron, 4L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static IngotMaterial NickelZincFerrite = new IngotMaterial(424, "nickel_zinc_ferrite", 0x2F2F2F, MaterialIconSet.METALLIC, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Iron, 4L), (Object)new MaterialStack(Oxygen, 8L)), EXT_METAL, null, 1500);
    public static FluidMaterial LeadZincSolution = new FluidMaterial(426, "lead_zinc_solution", 3213570, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lead, 1L), (Object)new MaterialStack(Silver, 1L), (Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Sulfur, 3L), (Object)new MaterialStack(Water, 1L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static FluidMaterial Tetrafluoroethylene = new FluidMaterial(427, "tetrafluoroethylene", 0x676767, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Fluorine, 4L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Chloromethane = new FluidMaterial(450, "chloromethane", 10301057, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 3L), (Object)new MaterialStack(Chlorine, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial AllylChloride = new FluidMaterial(451, "allyl_chloride", 7450250, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 5L), (Object)new MaterialStack(Chlorine, 1L)), 0L);
    public static FluidMaterial Isoprene = new FluidMaterial(452, "isoprene", 0x1D1D1D, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 5L), (Object)new MaterialStack(Hydrogen, 8L)), 0L);
    public static DustMaterial Magnesia = new DustMaterial(460, "magnesia", 0x887878, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial Propane = new FluidMaterial(414, "propane", 12890952, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 8L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Propene = new FluidMaterial(415, "propene", 12954956, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 6L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Ethane = new FluidMaterial(416, "ethane", 10329540, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 6L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Butene = new FluidMaterial(417, "butene", 10700561, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 4L), (Object)new MaterialStack(Hydrogen, 8L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Butane = new FluidMaterial(418, "butane", 9385508, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 4L), (Object)new MaterialStack(Hydrogen, 10L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial CalciumAcetate = new FluidMaterial(419, "calcium_acetate", 11444113, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Oxygen, 4L), (Object)new MaterialStack(Hydrogen, 6L)), 0L);
    public static FluidMaterial VinylAcetate = new FluidMaterial(409, "vinyl_acetate", 13144428, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 4L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static IngotMaterial PolyphenyleneSulfide = new IngotMaterial(411, "polyphenylene_sulfide", 8743424, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Sulfur, 1L)), Material.MatFlags.DISABLE_DECOMPOSITION | EXT_METAL | IngotMaterial.MatFlags.GENERATE_FOIL);
    public static FluidMaterial HydrofluoricAcid = new FluidMaterial(404, "hydrofluoric_acid", 946055, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Fluorine, 1L)), 0L);
    public static FluidMaterial NitricOxide = new FluidMaterial(405, "nitric_oxide", 6790328, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 1L), (Object)new MaterialStack(Oxygen, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial MethylAcetate = new FluidMaterial(406, "methyl_acetate", 12427150, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static FluidMaterial Ethenone = new FluidMaterial(407, "ethenone", 0x1B1B41, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial Tetranitromethane = new FluidMaterial(408, "tetranitromethane", 1715244, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Nitrogen, 4L), (Object)new MaterialStack(Oxygen, 8L)), 0L);
    public static FluidMaterial Dimethylamine = new FluidMaterial(388, "dimethylamine", 4931417, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 7L), (Object)new MaterialStack(Nitrogen, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Dimethylhydrazine = new FluidMaterial(389, "dimethylhidrazine", 1052748, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 8L), (Object)new MaterialStack(Nitrogen, 2L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial DinitrogenTetroxide = new FluidMaterial(390, "dinitrogen_tetroxide", 998766, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nitrogen, 2L), (Object)new MaterialStack(Oxygen, 4L)), FluidMaterial.MatFlags.STATE_GAS);
    public static IngotMaterial SiliconeRubber = new IngotMaterial(391, "silicon_rubber", 0xACACAC, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 1L), (Object)new MaterialStack(Silicon, 1L)), DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_GEAR | IngotMaterial.MatFlags.GENERATE_RING | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMASHING | IngotMaterial.MatFlags.GENERATE_FOIL);
    public static DustMaterial Polydimethylsiloxane = new DustMaterial(392, "polydimethylsiloxane", 0x8C8C8C, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 1L), (Object)new MaterialStack(Silicon, 1L)), 0L);
    public static FluidMaterial Dimethyldichlorosilane = new FluidMaterial(393, "dimethyldichlorosilane", 4070471, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Chlorine, 2L), (Object)new MaterialStack(Silicon, 1L)), 0L);
    public static FluidMaterial Styrene = new FluidMaterial(394, "styrene", 10722453, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 8L), (Object)new MaterialStack(Hydrogen, 8L)), 0L);
    public static IngotMaterial Polystyrene = new IngotMaterial(395, "polystyrene", 8945785, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 8L), (Object)new MaterialStack(Hydrogen, 8L)), Material.MatFlags.DISABLE_DECOMPOSITION | IngotMaterial.MatFlags.GENERATE_FOIL);
    public static FluidMaterial Butadiene = new FluidMaterial(396, "butadiene", 11885072, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 4L), (Object)new MaterialStack(Hydrogen, 6L)), 0L);
    public static DustMaterial RawStyreneButadieneRubber = new DustMaterial(397, "raw_styrene_butadiene_rubber", 5192762, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 8L), (Object)new MaterialStack(Hydrogen, 8L), (Object)new MaterialStack(Butadiene, 3L)), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static IngotMaterial StyreneButadieneRubber = new IngotMaterial(398, "styrene_butadiene_rubber", 1906453, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 8L), (Object)new MaterialStack(Hydrogen, 8L), (Object)new MaterialStack(Butadiene, 3L)), DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_GEAR | IngotMaterial.MatFlags.GENERATE_RING | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMASHING);
    public static FluidMaterial Dichlorobenzene = new FluidMaterial(399, "dichlorobenzene", 868171, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Chlorine, 2L)), 0L);
    public static FluidMaterial HydrochloricAcid = new FluidMaterial(400, "hydrochloric_acid", 0x909C99, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Chlorine, 1L)), 0L);
    public static FluidMaterial AceticAcid = new FluidMaterial(401, "acetic_acid", 10260096, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static FluidMaterial PolyvinylAcetate = new FluidMaterial(471, "polyvinyl_acetate", 13139532, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 4L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static FluidMaterial Phenol = new FluidMaterial(468, "phenol", 6635559, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial BisphenolA = new FluidMaterial(469, "bisphenol_a", 10848014, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 15L), (Object)new MaterialStack(Hydrogen, 16L), (Object)new MaterialStack(Oxygen, 2L)), 0L);
    public static IngotMaterial ReinforcedEpoxyResin = new IngotMaterial(470, "reinforced_epoxy_resin", 7491595, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 1L)), DustMaterial.MatFlags.GENERATE_PLATE);
    public static IngotMaterial BorosilicateGlass = new IngotMaterial(364, "borosilicate_glass", 0xCCD7CC, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Boron, 1L), (Object)new MaterialStack(SiliconDioxide, 7L)), Material.MatFlags.DECOMPOSITION_BY_CENTRIFUGING);
    public static IngotMaterial PolyvinylChloride = new IngotMaterial(965, "polyvinyl_chloride", 0x99A4A4, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 3L), (Object)new MaterialStack(Chlorine, 1L)), EXT_METAL | IngotMaterial.MatFlags.GENERATE_FOIL);
    public static FluidMaterial VinylChloride = new FluidMaterial(366, "vinyl_chloride", 0xB0BBBB, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 3L), (Object)new MaterialStack(Chlorine, 1L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Ethylene = new FluidMaterial(367, "ethylene", 0xADADAD, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 4L)), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Benzene = new FluidMaterial(368, "benzene", 0x1F1F1F, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 6L), (Object)new MaterialStack(Hydrogen, 6L)), 0L);
    public static FluidMaterial Acetone = new FluidMaterial(375, "acetone", 0x8E8E8E, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial Glycerol = new FluidMaterial(378, "glycerol", 7384944, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 3L), (Object)new MaterialStack(Hydrogen, 8L), (Object)new MaterialStack(Oxygen, 3L)), 0L);
    public static FluidMaterial Methanol = new FluidMaterial(379, "methanol", 8941584, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 1L)), 0L);
    public static FluidMaterial SaltWater = new FluidMaterial(428, "salt_water", 255, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static RoughSolidMaterial Wood = new RoughSolidMaterial(196, "wood", 9004839, MaterialIconSet.WOOD, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_SOLID | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | SolidMaterial.MatFlags.GENERATE_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | SolidMaterial.MatFlags.GENERATE_FRAME, () -> OrePrefix.plank);
    public static FluidMaterial WoodGas = new FluidMaterial(370, "wood_gas", 11642225, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial WoodVinegar = new FluidMaterial(371, "wood_vinegar", 10832655, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial WoodTar = new FluidMaterial(372, "wood_tar", 2957592, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial CharcoalByproducts = new FluidMaterial(461, "charcoal_byproducts", 6701095, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Biomass = new FluidMaterial(315, "biomass", 65280, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial BioDiesel = new FluidMaterial(314, "bio_diesel", 12806415, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial FermentedBiomass = new FluidMaterial(472, "fermented_biomass", 4147981, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Creosote = new FluidMaterial(316, "creosote", 0x804000, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Ethanol = new FluidMaterial(317, "ethanol", 0xFF8000, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Fuel = new FluidMaterial(318, "fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial RocketFuel = new FluidMaterial(474, "rocket_fuel", 12433292, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Glue = new FluidMaterial(319, "glue", 13157376, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Gunpowder = new DustMaterial(320, "gunpowder", 0x808080, MaterialIconSet.SAND, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), Material.MatFlags.FLAMMABLE | Material.MatFlags.EXPLOSIVE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING);
    public static FluidMaterial Lubricant = new FluidMaterial(321, "lubricant", 16761856, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial McGuffium239 = new FluidMaterial(322, "mc_guffium239", 13120150, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Oil = new FluidMaterial(323, "oil", 0x666666, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Oilsands = new DustMaterial(324, "oilsands", 657930, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Oil, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static RoughSolidMaterial Paper = new RoughSolidMaterial(325, "paper", 0xFFFFFF, MaterialIconSet.PAPER, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.GENERATE_PLATE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE | IngotMaterial.MatFlags.GENERATE_RING | DustMaterial.MatFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE, () -> OrePrefix.plate);
    public static DustMaterial RareEarth = new DustMaterial(326, "rare_earth", 8421476, MaterialIconSet.ROUGH, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial PlatinumGroupSludge = new DustMaterial(422, "platinum_group_sludge", 4864, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static FluidMaterial IndiumConcentrate = new FluidMaterial(425, "indium_concentrate", 205130, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SeedOil = new FluidMaterial(327, "seed_oil", 12910336, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Stone = new DustMaterial(328, "stone", 0xCDCDCD, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), SolidMaterial.MatFlags.MORTAR_GRINDABLE | SolidMaterial.MatFlags.GENERATE_GEAR | DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.NO_SMASHING | Material.MatFlags.NO_RECYCLING);
    public static FluidMaterial Lava = new FluidMaterial(329, "lava", 0xFF4000, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Glowstone = new DustMaterial(330, "glowstone", 0xFFFF00, MaterialIconSet.SHINY, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.SMELT_INTO_FLUID | DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE);
    public static GemMaterial NetherStar = new GemMaterial(331, "nether_star", 0xFFFFFF, MaterialIconSet.NETHERSTAR, 4, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_SOLID | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING);
    public static DustMaterial Endstone = new DustMaterial(332, "endstone", 0xFFFFFF, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Netherrack = new DustMaterial(333, "netherrack", 0xC80000, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING | Material.MatFlags.FLAMMABLE);
    public static FluidMaterial DrillingFluid = new FluidMaterial(348, "drilling_fluid", 0xFFFFAA, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial ConstructionFoam = new FluidMaterial(347, "construction_foam", 0x333333, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedEthane = new FluidMaterial(429, "hydrocracked_ethane", 9868988, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedEthylene = new FluidMaterial(430, "hydrocracked_ethylene", 0xA3A3A0, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial HydroCrackedPropene = new FluidMaterial(431, "hydrocracked_propene", 12494144, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedPropane = new FluidMaterial(432, "hydrocracked_propane", 12494144, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedLightFuel = new FluidMaterial(433, "hydrocracked_light_fuel", 12037896, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedButane = new FluidMaterial(434, "hydrocracked_butane", 8727576, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedNaphtha = new FluidMaterial(435, "hydrocracked_naphtha", 12563976, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedHeavyFuel = new FluidMaterial(436, "hydrocracked_heavy_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedGas = new FluidMaterial(437, "hydrocracked_gas", 0xB4B4B4, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedButene = new FluidMaterial(438, "hydrocracked_butene", 10042885, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HydroCrackedButadiene = new FluidMaterial(439, "hydrocracked_butadiene", 11358723, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedEthane = new FluidMaterial(440, "steamcracked_ethane", 9868988, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedEthylene = new FluidMaterial(441, "steamcracked_ethylene", 0xA3A3A0, MaterialIconSet.GAS, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedPropene = new FluidMaterial(442, "steamcracked_propene", 12494144, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedPropane = new FluidMaterial(443, "steamcracked_propane", 12494144, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedButane = new FluidMaterial(444, "steamcracked_butane", 8727576, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedNaphtha = new FluidMaterial(445, "steamcracked_naphtha", 12563976, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedGas = new FluidMaterial(446, "steamcracked_gas", 0xB4B4B4, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedButene = new FluidMaterial(447, "steamcracked_butene", 10042885, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SteamCrackedButadiene = new FluidMaterial(448, "steamcracked_butadiene", 11358723, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial OilHeavy = new FluidMaterial(165, "oil_heavy", 0x666666, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK);
    public static FluidMaterial OilMedium = new FluidMaterial(166, "oil_medium", 0x666666, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK);
    public static FluidMaterial OilLight = new FluidMaterial(167, "oil_light", 0x666666, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK);
    public static FluidMaterial NaturalGas = new FluidMaterial(168, "natural_gas", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS | FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK);
    public static FluidMaterial SulfuricGas = new FluidMaterial(169, "sulfuric_gas", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial Gas = new FluidMaterial(170, "gas", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), FluidMaterial.MatFlags.STATE_GAS);
    public static FluidMaterial SulfuricNaphtha = new FluidMaterial(171, "sulfuric_naphtha", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SulfuricLightFuel = new FluidMaterial(172, "sulfuric_light_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial SulfuricHeavyFuel = new FluidMaterial(173, "sulfuric_heavy_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Naphtha = new FluidMaterial(174, "naphtha", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial LightFuel = new FluidMaterial(175, "light_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial HeavyFuel = new FluidMaterial(176, "heavy_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial LPG = new FluidMaterial(177, "lpg", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial CrackedLightFuel = new FluidMaterial(464, "cracked_light_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial CrackedHeavyFuel = new FluidMaterial(465, "cracked_heavy_fuel", 0xFFFF00, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Toluene = new FluidMaterial(350, "toluene", 0xFFFFFF, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static GemMaterial Glass = new GemMaterial(209, "glass", 0xFFFFFF, MaterialIconSet.GLASS, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SiliconDioxide, 1L)), DustMaterial.MatFlags.GENERATE_PLATE | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | Material.MatFlags.NO_RECYCLING | DustMaterial.MatFlags.SMELT_INTO_FLUID | DustMaterial.MatFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES);
    public static DustMaterial Perlite = new DustMaterial(210, "perlite", 0x1E141E, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Obsidian, 2L), (Object)new MaterialStack(Water, 1L)), 0L);
    public static DustMaterial Borax = new DustMaterial(313, "borax", 0xFFFFFF, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 2L), (Object)new MaterialStack(Boron, 4L), (Object)new MaterialStack(Water, 10L), (Object)new MaterialStack(Oxygen, 7L)), 0L);
    public static GemMaterial Lignite = new GemMaterial(211, "lignite", 0x644646, MaterialIconSet.LIGNITE, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Water, 4L), (Object)new MaterialStack(DarkAsh, 1L)), DustMaterial.MatFlags.GENERATE_ORE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static GemMaterial Olivine = new GemMaterial(212, "olivine", 0x66FF66, MaterialIconSet.RUBY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 2L), (Object)new MaterialStack(Iron, 1L), (Object)new MaterialStack(SiliconDioxide, 2L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 7.5f, 3.0f, 312);
    public static GemMaterial Opal = new GemMaterial(213, "opal", 255, MaterialIconSet.OPAL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SiliconDioxide, 1L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 7.5f, 3.0f, 312);
    public static GemMaterial Amethyst = new GemMaterial(214, "amethyst", 0xD232D2, MaterialIconSet.RUBY, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SiliconDioxide, 4L), (Object)new MaterialStack(Iron, 1L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT, 7.5f, 3.0f, 312);
    public static DustMaterial Redstone = new DustMaterial(215, "redstone", 0xC80000, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Pyrite, 5L), (Object)new MaterialStack(Ruby, 1L), (Object)new MaterialStack(Mercury, 3L)), DustMaterial.MatFlags.GENERATE_PLATE | DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.SMELT_INTO_FLUID);
    public static GemMaterial Lapis = new GemMaterial(216, "lapis", 4605660, MaterialIconSet.LAPIS, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lazurite, 12L), (Object)new MaterialStack(Sodalite, 2L), (Object)new MaterialStack(Pyrite, 1L), (Object)new MaterialStack(Calcite, 1L)), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE | DustMaterial.MatFlags.NO_WORKING | Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING);
    public static DustMaterial Blaze = new DustMaterial(217, "blaze", 16762880, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(DarkAsh, 1L), (Object)new MaterialStack(Sulfur, 1L)), DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.SMELT_INTO_FLUID | SolidMaterial.MatFlags.MORTAR_GRINDABLE | Material.MatFlags.BURNING);
    public static GemMaterial EnderPearl = new GemMaterial(218, "ender_pearl", 7134408, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Beryllium, 1L), (Object)new MaterialStack(Potassium, 4L), (Object)new MaterialStack(Nitrogen, 5L)), DustMaterial.MatFlags.GENERATE_PLATE | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING);
    public static GemMaterial EnderEye = new GemMaterial(219, "ender_eye", 0x66FF66, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(EnderPearl, 1L), (Object)new MaterialStack(Blaze, 1L)), DustMaterial.MatFlags.GENERATE_PLATE | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING);
    public static RoughSolidMaterial Flint = new RoughSolidMaterial(220, "flint", 8256, MaterialIconSet.FLINT, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SiliconDioxide, 1L)), DustMaterial.MatFlags.NO_SMASHING | SolidMaterial.MatFlags.MORTAR_GRINDABLE, () -> OrePrefix.gem);
    public static DustMaterial Diatomite = new DustMaterial(221, "diatomite", 0xE1E1E1, MaterialIconSet.DULL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Flint, 8L), (Object)new MaterialStack(BandedIron, 1L), (Object)new MaterialStack(Sapphire, 1L)), 0L);
    public static DustMaterial Niter = new DustMaterial(223, "niter", 0xFFC8C8, MaterialIconSet.FLINT, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Saltpeter, 1L)), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING);
    public static DustMaterial Tantalite = new DustMaterial(224, "tantalite", 9523240, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Manganese, 1L), (Object)new MaterialStack(Tantalum, 2L), (Object)new MaterialStack(Oxygen, 6L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial HydratedCoal = new DustMaterial(225, "hydrated_coal", 0x464664, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Coal, 8L), (Object)new MaterialStack(Water, 1L)), 0L);
    public static GemMaterial Apatite = new GemMaterial(226, "apatite", 0xC8C8FF, MaterialIconSet.EMERALD, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 5L), (Object)new MaterialStack(Phosphate, 3L), (Object)new MaterialStack(Chlorine, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE);
    public static IngotMaterial SterlingSilver = new IngotMaterial(227, "sterling_silver", 16440545, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Silver, 4L)), EXT2_METAL, null, 13.0f, 2.0f, 196, 1700);
    public static IngotMaterial RoseGold = new IngotMaterial(228, "rose_gold", 16770590, MaterialIconSet.SHINY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Gold, 4L)), EXT2_METAL, null, 14.0f, 2.0f, 152, 1600);
    public static IngotMaterial BlackBronze = new IngotMaterial(229, "black_bronze", 6566525, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Gold, 1L), (Object)new MaterialStack(Silver, 1L), (Object)new MaterialStack(Copper, 3L)), EXT2_METAL, null, 12.0f, 2.0f, 256, 2000);
    public static IngotMaterial BismuthBronze = new IngotMaterial(230, "bismuth_bronze", 6585725, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Bismuth, 1L), (Object)new MaterialStack(Zinc, 1L), (Object)new MaterialStack(Copper, 3L)), EXT2_METAL, null, 8.0f, 3.0f, 256, 1100);
    public static IngotMaterial BlackSteel = new IngotMaterial(231, "black_steel", 0x646464, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 1L), (Object)new MaterialStack(BlackBronze, 1L), (Object)new MaterialStack(Steel, 3L)), EXT_METAL, null, 6.5f, 6.5f, 768, 1200);
    public static IngotMaterial RedSteel = new IngotMaterial(232, "red_steel", 9200740, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SterlingSilver, 1L), (Object)new MaterialStack(BismuthBronze, 1L), (Object)new MaterialStack(Steel, 2L), (Object)new MaterialStack(BlackSteel, 4L)), EXT_METAL, null, 7.0f, 4.5f, 896, 1300);
    public static IngotMaterial BlueSteel = new IngotMaterial(233, "blue_steel", 6579340, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(RoseGold, 1L), (Object)new MaterialStack(Brass, 1L), (Object)new MaterialStack(Steel, 2L), (Object)new MaterialStack(BlackSteel, 4L)), EXT_METAL | SolidMaterial.MatFlags.GENERATE_FRAME, null, 7.5f, 5.0f, 1024, 1400);
    public static IngotMaterial DamascusSteel = new IngotMaterial(234, "damascus_steel", 0x6E6E6E, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Steel, 1L)), EXT_METAL, null, 8.0f, 5.0f, 1280, 1500);
    public static IngotMaterial TungstenSteel = new IngotMaterial(235, "tungsten_steel", 6579360, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Steel, 1L), (Object)new MaterialStack(Tungsten, 1L)), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | IngotMaterial.MatFlags.GENERATE_DENSE | SolidMaterial.MatFlags.GENERATE_FRAME, null, 8.0f, 4.0f, 2560, 3000);
    public static FluidMaterial NitroFuel = new FluidMaterial(236, "nitro_fuel", 13172480, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Glyceryl, 1L), (Object)new MaterialStack(Fuel, 4L)), Material.MatFlags.FLAMMABLE | Material.MatFlags.EXPLOSIVE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING);
    public static IngotMaterial RedAlloy = new IngotMaterial(237, "red_alloy", 0xC80000, MaterialIconSet.DULL, 0, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 1L), (Object)new MaterialStack(Redstone, 4L)), DustMaterial.MatFlags.GENERATE_PLATE | IngotMaterial.MatFlags.GENERATE_FINE_WIRE);
    public static IngotMaterial CobaltBrass = new IngotMaterial(238, "cobalt_brass", 11842720, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Brass, 7L), (Object)new MaterialStack(Aluminium, 1L), (Object)new MaterialStack(Cobalt, 1L)), EXT2_METAL, null, 8.0f, 2.0f, 256);
    public static DustMaterial Phosphor = new DustMaterial(239, "phosphor", 0xFFFF00, MaterialIconSet.FLINT, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 3L), (Object)new MaterialStack(Phosphate, 2L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | Material.MatFlags.FLAMMABLE | Material.MatFlags.EXPLOSIVE);
    public static DustMaterial Basalt = new DustMaterial(240, "basalt", 0x1E1414, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Olivine, 1L), (Object)new MaterialStack(Calcite, 3L), (Object)new MaterialStack(Flint, 8L), (Object)new MaterialStack(DarkAsh, 4L)), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Andesite = new DustMaterial(241, "andesite", 0xBEBEBE, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Diorite = new DustMaterial(242, "diorite", 0xFFFFFF, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of(), DustMaterial.MatFlags.NO_SMASHING);
    public static GemMaterial GarnetRed = new GemMaterial(243, "garnet_red", 13127760, MaterialIconSet.RUBY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Pyrope, 3L), (Object)new MaterialStack(Almandine, 5L), (Object)new MaterialStack(Spessartine, 8L)), STD_SOLID | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT | DustMaterial.MatFlags.GENERATE_ORE, null, 7.5f, 3.0f, 156);
    public static GemMaterial GarnetYellow = new GemMaterial(244, "garnet_yellow", 13158480, MaterialIconSet.RUBY, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Andradite, 5L), (Object)new MaterialStack(Grossular, 8L), (Object)new MaterialStack(Uvarovite, 3L)), STD_SOLID | GemMaterial.MatFlags.GENERATE_LENSE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.HIGH_SIFTER_OUTPUT | DustMaterial.MatFlags.GENERATE_ORE, null, 7.5f, 3.0f, 156);
    public static DustMaterial Marble = new DustMaterial(245, "marble", 0xC8C8C8, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Calcite, 7L)), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Sugar = new DustMaterial(246, "sugar", 0xFAFAFA, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Water, 5L), (Object)new MaterialStack(Oxygen, 25L)), 0L);
    public static GemMaterial Vinteum = new GemMaterial(247, "vinteum", 6605055, MaterialIconSet.EMERALD, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), STD_GEM | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING, 12.0f, 3.0f, 128);
    public static DustMaterial Redrock = new DustMaterial(248, "redrock", 16732210, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcite, 2L), (Object)new MaterialStack(Flint, 1L), (Object)new MaterialStack(Clay, 1L)), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial PotassiumFeldspar = new DustMaterial(249, "potassium_feldspar", 0x782828, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Aluminium, 1L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 8L)), 0L);
    public static DustMaterial Biotite = new DustMaterial(250, "biotite", 0x141E14, MaterialIconSet.METALLIC, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Magnesium, 3L), (Object)new MaterialStack(Aluminium, 3L), (Object)new MaterialStack(Fluorine, 2L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Oxygen, 10L)), 0L);
    public static DustMaterial GraniteBlack = new DustMaterial(251, "granite_black", 657930, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(SiliconDioxide, 4L), (Object)new MaterialStack(Biotite, 1L)), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial GraniteRed = new DustMaterial(252, "granite_red", 0xFF0080, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(PotassiumFeldspar, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.NO_SMASHING);
    public static DustMaterial Chrysotile = new DustMaterial(253, "chrysotile", 7244910, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Asbestos, 1L)), 0L);
    public static DustMaterial Realgar = new DustMaterial(254, "realgar", 9200740, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Arsenic, 4L), (Object)new MaterialStack(Sulfur, 4L)), 0L);
    public static DustMaterial VanadiumMagnetite = new DustMaterial(255, "vanadium_magnetite", 0x23233C, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnetite, 1L), (Object)new MaterialStack(Vanadium, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial BasalticMineralSand = new DustMaterial(266, "basaltic_mineral_sand", 0x283228, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnetite, 1L), (Object)new MaterialStack(Basalt, 1L)), DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static DustMaterial GraniticMineralSand = new DustMaterial(267, "granitic_mineral_sand", 2636860, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnetite, 1L), (Object)new MaterialStack(GraniteBlack, 1L)), DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static DustMaterial GarnetSand = new DustMaterial(268, "garnet_sand", 13132800, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(GarnetRed, 1L), (Object)new MaterialStack(GarnetYellow, 1L)), 0L);
    public static DustMaterial QuartzSand = new DustMaterial(269, "quartz_sand", 0xC8C8C8, MaterialIconSet.SAND, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(CertusQuartz, 1L), (Object)new MaterialStack(Quartzite, 1L)), 0L);
    public static DustMaterial Bastnasite = new DustMaterial(270, "bastnasite", 13135405, MaterialIconSet.FINE, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Cerium, 1L), (Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Fluorine, 1L), (Object)new MaterialStack(Oxygen, 3L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Pentlandite = new DustMaterial(271, "pentlandite", 10851845, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Nickel, 9L), (Object)new MaterialStack(Sulfur, 8L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static DustMaterial Spodumene = new DustMaterial(272, "spodumene", 0xBEAAAA, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Lithium, 1L), (Object)new MaterialStack(Aluminium, 1L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Oxygen, 6L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Pollucite = new DustMaterial(273, "pollucite", 15782610, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Caesium, 2L), (Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 4L), (Object)new MaterialStack(Water, 2L), (Object)new MaterialStack(Oxygen, 12L)), 0L);
    public static DustMaterial Lepidolite = new DustMaterial(274, "lepidolite", 15741580, MaterialIconSet.FINE, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Lithium, 3L), (Object)new MaterialStack(Aluminium, 4L), (Object)new MaterialStack(Fluorine, 2L), (Object)new MaterialStack(Oxygen, 10L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Glauconite = new DustMaterial(275, "glauconite", 8565820, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Magnesium, 2L), (Object)new MaterialStack(Aluminium, 4L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial GlauconiteSand = new DustMaterial(276, "glauconite_sand", 8565820, MaterialIconSet.SAND, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Magnesium, 2L), (Object)new MaterialStack(Aluminium, 4L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 12L)), 0L);
    public static DustMaterial Vermiculite = new DustMaterial(277, "vermiculite", 13153295, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 3L), (Object)new MaterialStack(Aluminium, 4L), (Object)new MaterialStack(Silicon, 4L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Water, 4L), (Object)new MaterialStack(Oxygen, 12L)), 0L);
    public static DustMaterial Bentonite = new DustMaterial(278, "bentonite", 16111570, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Magnesium, 6L), (Object)new MaterialStack(Silicon, 12L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Water, 5L), (Object)new MaterialStack(Oxygen, 36L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial FullersEarth = new DustMaterial(279, "fullers_earth", 10526840, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Silicon, 4L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Water, 4L), (Object)new MaterialStack(Oxygen, 11L)), 0L);
    public static DustMaterial Pitchblende = new DustMaterial(280, "pitchblende", 13160960, MaterialIconSet.ROUGH, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Uraninite, 3L), (Object)new MaterialStack(Thorium, 1L), (Object)new MaterialStack(Lead, 1L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static GemMaterial Monazite = new GemMaterial(281, "monazite", 3294770, MaterialIconSet.GEM_VERTICAL, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(RareEarth, 1L), (Object)new MaterialStack(Phosphate, 1L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.NO_SMELTING | GemMaterial.MatFlags.CRYSTALLISABLE);
    public static DustMaterial Malachite = new DustMaterial(282, "malachite", 352005, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Copper, 2L), (Object)new MaterialStack(Carbon, 1L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 5L)), DustMaterial.MatFlags.GENERATE_ORE | DustMaterial.MatFlags.INDUCTION_SMELTING_LOW_OUTPUT);
    public static DustMaterial Mirabilite = new DustMaterial(283, "mirabilite", 15792850, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 2L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Water, 10L), (Object)new MaterialStack(Oxygen, 4L)), 0L);
    public static DustMaterial Mica = new DustMaterial(284, "mica", 0xC3C3CD, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Aluminium, 3L), (Object)new MaterialStack(Silicon, 3L), (Object)new MaterialStack(Fluorine, 2L), (Object)new MaterialStack(Oxygen, 10L)), 0L);
    public static DustMaterial Trona = new DustMaterial(285, "trona", 8882015, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 3L), (Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Hydrogen, 1L), (Object)new MaterialStack(Water, 2L), (Object)new MaterialStack(Oxygen, 6L)), 0L);
    public static DustMaterial Barite = new DustMaterial(286, "barite", 15133695, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Barium, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Oxygen, 4L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Gypsum = new DustMaterial(287, "gypsum", 15132410, MaterialIconSet.FINE, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Sulfur, 1L), (Object)new MaterialStack(Water, 2L), (Object)new MaterialStack(Oxygen, 4L)), 0L);
    public static DustMaterial Alunite = new DustMaterial(288, "alunite", 14791745, MaterialIconSet.METALLIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Potassium, 1L), (Object)new MaterialStack(Aluminium, 3L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Hydrogen, 6L), (Object)new MaterialStack(Oxygen, 14L)), 0L);
    public static DustMaterial Dolomite = new DustMaterial(289, "dolomite", 14798285, MaterialIconSet.FLINT, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Magnesium, 1L), (Object)new MaterialStack(Carbon, 2L), (Object)new MaterialStack(Oxygen, 6L)), 0L);
    public static DustMaterial Wollastonite = new DustMaterial(290, "wollastonite", 0xF0F0F0, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Calcium, 1L), (Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Oxygen, 3L)), 0L);
    public static DustMaterial Zeolite = new DustMaterial(291, "zeolite", 15787750, MaterialIconSet.ROUGH, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Sodium, 1L), (Object)new MaterialStack(Calcium, 4L), (Object)new MaterialStack(Silicon, 27L), (Object)new MaterialStack(Aluminium, 9L), (Object)new MaterialStack(Water, 28L), (Object)new MaterialStack(Oxygen, 72L)), 0L);
    public static DustMaterial Kyanite = new DustMaterial(292, "kyanite", 7237370, MaterialIconSet.FLINT, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 1L), (Object)new MaterialStack(Oxygen, 5L)), 0L);
    public static DustMaterial Kaolinite = new DustMaterial(293, "kaolinite", 16116715, MaterialIconSet.DULL, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Aluminium, 2L), (Object)new MaterialStack(Silicon, 2L), (Object)new MaterialStack(Hydrogen, 4L), (Object)new MaterialStack(Oxygen, 9L)), 0L);
    public static DustMaterial Talc = new DustMaterial(294, "talc", 5944410, MaterialIconSet.FINE, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 3L), (Object)new MaterialStack(Silicon, 4L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Soapstone = new DustMaterial(295, "soapstone", 6263135, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Magnesium, 3L), (Object)new MaterialStack(Silicon, 4L), (Object)new MaterialStack(Hydrogen, 2L), (Object)new MaterialStack(Oxygen, 12L)), DustMaterial.MatFlags.GENERATE_ORE);
    public static DustMaterial Concrete = new DustMaterial(296, "concrete", 0x646464, MaterialIconSet.ROUGH, 1, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Stone, 1L)), DustMaterial.MatFlags.NO_SMASHING | DustMaterial.MatFlags.SMELT_INTO_FLUID);
    public static IngotMaterial IronMagnetic = new IngotMaterial(297, "iron_magnetic", 0xC8C8C8, MaterialIconSet.MAGNETIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Iron, 1L)), EXT2_METAL | SolidMaterial.MatFlags.MORTAR_GRINDABLE);
    public static IngotMaterial SteelMagnetic = new IngotMaterial(298, "steel_magnetic", 0x808080, MaterialIconSet.MAGNETIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Steel, 1L)), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.MORTAR_GRINDABLE, null, 1000);
    public static IngotMaterial NeodymiumMagnetic = new IngotMaterial(299, "neodymium_magnetic", 0x646464, MaterialIconSet.MAGNETIC, 2, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Neodymium, 1L)), EXT2_METAL | SolidMaterial.MatFlags.GENERATE_LONG_ROD, null, 1297);
    public static IngotMaterial TungstenCarbide = new IngotMaterial(300, "tungsten_carbide", 0x330066, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Tungsten, 1L), (Object)new MaterialStack(Carbon, 1L)), EXT2_METAL, null, 12.0f, 4.0f, 1280, 2460);
    public static IngotMaterial VanadiumSteel = new IngotMaterial(301, "vanadium_steel", 0xC0C0C0, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Vanadium, 1L), (Object)new MaterialStack(Chrome, 1L), (Object)new MaterialStack(Steel, 7L)), EXT2_METAL, null, 7.0f, 3.0f, 1920, 1453);
    public static IngotMaterial HSSG = new IngotMaterial(302, "hssg", 0x999900, MaterialIconSet.METALLIC, 3, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(TungstenSteel, 5L), (Object)new MaterialStack(Chrome, 1L), (Object)new MaterialStack(Molybdenum, 2L), (Object)new MaterialStack(Vanadium, 1L)), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | SolidMaterial.MatFlags.GENERATE_FRAME, null, 10.0f, 5.5f, 4000, 4500);
    public static IngotMaterial HSSE = new IngotMaterial(303, "hsse", 0x336600, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(HSSG, 6L), (Object)new MaterialStack(Cobalt, 1L), (Object)new MaterialStack(Manganese, 1L), (Object)new MaterialStack(Silicon, 1L)), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | SolidMaterial.MatFlags.GENERATE_FRAME, null, 10.0f, 8.0f, 5120, 5400);
    public static IngotMaterial HSSS = new IngotMaterial(304, "hsss", 0x660033, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(HSSG, 6L), (Object)new MaterialStack(Iridium, 2L), (Object)new MaterialStack(Osmium, 1L)), EXT2_METAL | SolidMaterial.MatFlags.GENERATE_GEAR, null, 15.0f, 7.0f, 3000, 5400);
    public static FluidMaterial UUAmplifier = new FluidMaterial(305, "uuamplifier", 0xAA00AA, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial UUMatter = new FluidMaterial(306, "uumatter", 0x770077, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static IngotMaterial Naquadah = new IngotMaterial(307, "naquadah", 0x323232, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL | DustMaterial.MatFlags.GENERATE_ORE, Element.Nq, 6.0f, 4.0f, 1280, 5400);
    public static IngotMaterial NaquadahAlloy = new IngotMaterial(308, "naquadah_alloy", 0x282828, MaterialIconSet.METALLIC, 5, (ImmutableList<MaterialStack>)ImmutableList.of((Object)new MaterialStack(Naquadah, 1L), (Object)new MaterialStack(Osmiridium, 1L)), EXT2_METAL, null, 8.0f, 5.0f, 5120, 7200);
    public static IngotMaterial NaquadahEnriched = new IngotMaterial(309, "naquadah_enriched", 0x282828, MaterialIconSet.METALLIC, 4, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL | DustMaterial.MatFlags.GENERATE_ORE, null, 6.0f, 4.0f, 1280, 4500);
    public static IngotMaterial Naquadria = new IngotMaterial(310, "naquadria", 0x1E1E1E, MaterialIconSet.SHINY, 3, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Nq, 9000);
    public static IngotMaterial Tritanium = new IngotMaterial(311, "tritanium", 0xFFFFFF, MaterialIconSet.METALLIC, 6, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Tr, 20.0f, 6.0f, 10240);
    public static IngotMaterial Duranium = new IngotMaterial(312, "duranium", 0xFFFFFF, MaterialIconSet.METALLIC, 5, (ImmutableList<MaterialStack>)ImmutableList.of(), EXT_METAL, Element.Dr, 16.0f, 5.0f, 5120);
    public static FluidMaterial Milk = new FluidMaterial(339, "milk", 0xFEFEFE, MaterialIconSet.FINE, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Honey = new FluidMaterial(341, "honey", 13813760, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static FluidMaterial Juice = new FluidMaterial(473, "juice", 11061618, MaterialIconSet.FLUID, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Cocoa = new DustMaterial(343, "cocoa", 12476160, MaterialIconSet.ROUGH, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);
    public static DustMaterial Wheat = new DustMaterial(345, "wheat", 0xFFFFC4, MaterialIconSet.FINE, 0, (ImmutableList<MaterialStack>)ImmutableList.of(), 0L);

    public static void register() {
        MarkerMaterials.register();
    }

    static {
        for (DustMaterial dustMaterial : new DustMaterial[]{Bastnasite, Monazite}) {
            dustMaterial.separatedOnto = Neodymium;
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{Magnetite, VanadiumMagnetite, BasalticMineralSand, GraniticMineralSand}) {
            dustMaterial.separatedOnto = Gold;
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{YellowLimonite, BrownLimonite, Pyrite, BandedIron, Nickel, Vermiculite, Glauconite, GlauconiteSand, Pentlandite, Tin, Antimony, Ilmenite, Manganese, Chrome, Chromite, Andradite}) {
            dustMaterial.separatedOnto = Iron;
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{Pyrite, YellowLimonite, BasalticMineralSand, GraniticMineralSand}) {
            dustMaterial.addFlag(IngotMaterial.MatFlags.BLAST_FURNACE_CALCITE_DOUBLE);
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{Iron, PigIron, WroughtIron, BrownLimonite}) {
            dustMaterial.addFlag(IngotMaterial.MatFlags.BLAST_FURNACE_CALCITE_TRIPLE);
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{Gold, Silver, Osmium, Platinum, Cooperite, Chalcopyrite, Bornite}) {
            dustMaterial.washedIn = Mercury;
        }
        for (DustMaterial dustMaterial : new DustMaterial[]{Zinc, Nickel, Copper, Cobalt, Cobaltite, Tetrahedrite, Sphalerite}) {
            dustMaterial.washedIn = SodiumPersulfate;
        }
        Materials.Neodymium.magneticMaterial = NeodymiumMagnetic;
        Materials.Steel.magneticMaterial = SteelMagnetic;
        Materials.Iron.magneticMaterial = IronMagnetic;
        NeodymiumMagnetic.setSmeltingInto(Neodymium);
        NeodymiumMagnetic.setArcSmeltingInto(Neodymium);
        NeodymiumMagnetic.setMaceratingInto(Neodymium);
        SteelMagnetic.setSmeltingInto(Steel);
        IronMagnetic.setArcSmeltingInto(Steel);
        IronMagnetic.setMaceratingInto(Steel);
        IronMagnetic.setSmeltingInto(Iron);
        IronMagnetic.setArcSmeltingInto(WroughtIron);
        IronMagnetic.setMaceratingInto(Iron);
        Iron.setArcSmeltingInto(WroughtIron);
        Copper.setArcSmeltingInto(AnnealedCopper);
        Tetrahedrite.setDirectSmelting(Copper);
        Malachite.setDirectSmelting(Copper);
        Chalcopyrite.setDirectSmelting(Copper);
        Tenorite.setDirectSmelting(Copper);
        Bornite.setDirectSmelting(Copper);
        Chalcocite.setDirectSmelting(Copper);
        Cuprite.setDirectSmelting(Copper);
        Pentlandite.setDirectSmelting(Nickel);
        Sphalerite.setDirectSmelting(Zinc);
        Pyrite.setDirectSmelting(Iron);
        Magnetite.setDirectSmelting(Iron);
        YellowLimonite.setDirectSmelting(Iron);
        BrownLimonite.setDirectSmelting(Iron);
        BandedIron.setDirectSmelting(Iron);
        Cassiterite.setDirectSmelting(Tin);
        CassiteriteSand.setDirectSmelting(Tin);
        Garnierite.setDirectSmelting(Nickel);
        Cobaltite.setDirectSmelting(Cobalt);
        Stibnite.setDirectSmelting(Antimony);
        Cooperite.setDirectSmelting(Platinum);
        Pyrolusite.setDirectSmelting(Manganese);
        Magnesite.setDirectSmelting(Magnesium);
        Molybdenite.setDirectSmelting(Molybdenum);
        Salt.setOreMultiplier(2);
        Salt.setSmeltingMultiplier(2);
        RockSalt.setOreMultiplier(2);
        RockSalt.setSmeltingMultiplier(2);
        Scheelite.setOreMultiplier(2);
        Tungstate.setOreMultiplier(2);
        Ilmenite.setOreMultiplier(3);
        Cassiterite.setOreMultiplier(2);
        Cassiterite.setSmeltingMultiplier(2);
        CassiteriteSand.setOreMultiplier(2);
        CassiteriteSand.setSmeltingMultiplier(2);
        NetherQuartz.setOreMultiplier(2);
        NetherQuartz.setSmeltingMultiplier(2);
        CertusQuartz.setOreMultiplier(2);
        CertusQuartz.setSmeltingMultiplier(2);
        Phosphor.setOreMultiplier(3);
        Phosphor.setSmeltingMultiplier(3);
        Saltpeter.setOreMultiplier(4);
        Saltpeter.setSmeltingMultiplier(4);
        Apatite.setOreMultiplier(4);
        Apatite.setSmeltingMultiplier(4);
        Apatite.setByProductMultiplier(2);
        Redstone.setOreMultiplier(5);
        Redstone.setSmeltingMultiplier(5);
        Glowstone.setOreMultiplier(5);
        Glowstone.setSmeltingMultiplier(5);
        Lapis.setOreMultiplier(6);
        Lapis.setSmeltingMultiplier(6);
        Lapis.setByProductMultiplier(4);
        Sodalite.setOreMultiplier(6);
        Sodalite.setSmeltingMultiplier(6);
        Sodalite.setByProductMultiplier(4);
        Lazurite.setOreMultiplier(6);
        Lazurite.setSmeltingMultiplier(6);
        Lazurite.setByProductMultiplier(4);
        Monazite.setOreMultiplier(8);
        Monazite.setSmeltingMultiplier(8);
        Monazite.setByProductMultiplier(2);
        Coal.setBurnTime(1600);
        Charcoal.setBurnTime(1600);
        Lignite.setBurnTime(1200);
        Coke.setBurnTime(3200);
        Tenorite.addOreByProducts(Iron, Manganese, Malachite);
        Bornite.addOreByProducts(Pyrite, Cobalt, Cadmium, Gold);
        Chalcocite.addOreByProducts(Sulfur, Lead, Silver);
        Cuprite.addOreByProducts(Iron, Antimony, Malachite);
        Enargite.addOreByProducts(Pyrite, Zinc, Quartzite);
        Tennantite.addOreByProducts(Iron, Antimony, Zinc);
        Chalcopyrite.addOreByProducts(Pyrite, Cobalt, Cadmium, Gold);
        Sphalerite.addOreByProducts(GarnetYellow, Cadmium, Gallium, Zinc);
        GlauconiteSand.addOreByProducts(Sodium, Aluminium, Iron);
        Glauconite.addOreByProducts(Sodium, Aluminium, Iron);
        Vermiculite.addOreByProducts(Iron, Aluminium, Magnesium);
        FullersEarth.addOreByProducts(Aluminium, Silicon, Magnesium);
        Bentonite.addOreByProducts(Aluminium, Calcium, Magnesium);
        Uraninite.addOreByProducts(Uranium, Thorium, Uranium235);
        Pitchblende.addOreByProducts(Thorium, Uranium, Lead);
        Galena.addOreByProducts(Sulfur, Silver, Lead);
        Lapis.addOreByProducts(Lazurite, Sodalite, Pyrite);
        Pyrite.addOreByProducts(Sulfur, Phosphor, Iron);
        Copper.addOreByProducts(Cobalt, Gold, Nickel);
        Nickel.addOreByProducts(Cobalt, Platinum, Iron);
        GarnetRed.addOreByProducts(Spessartine, Pyrope, Almandine);
        GarnetYellow.addOreByProducts(Andradite, Grossular, Uvarovite);
        Cooperite.addOreByProducts(Palladium, Nickel, Iridium);
        Cinnabar.addOreByProducts(Redstone, Sulfur, Glowstone);
        Tantalite.addOreByProducts(Manganese, Niobium, Tantalum);
        Pollucite.addOreByProducts(Caesium, Aluminium, Rubidium);
        Chrysotile.addOreByProducts(Asbestos, Silicon, Magnesium);
        Asbestos.addOreByProducts(Asbestos, Silicon, Magnesium);
        Pentlandite.addOreByProducts(Iron, Sulfur, Cobalt);
        Uranium.addOreByProducts(Lead, Uranium235, Thorium);
        Scheelite.addOreByProducts(Manganese, Molybdenum, Calcium);
        Tungstate.addOreByProducts(Manganese, Silver, Lithium);
        Bauxite.addOreByProducts(Grossular, Rutile, Gallium);
        QuartzSand.addOreByProducts(CertusQuartz, Quartzite, Barite);
        Quartzite.addOreByProducts(CertusQuartz, Barite);
        CertusQuartz.addOreByProducts(Quartzite, Barite);
        Redstone.addOreByProducts(Cinnabar, RareEarth, Glowstone);
        Monazite.addOreByProducts(Thorium, Neodymium, RareEarth);
        Malachite.addOreByProducts(Copper, BrownLimonite, Calcite);
        YellowLimonite.addOreByProducts(Nickel, BrownLimonite, Cobalt);
        BrownLimonite.addOreByProducts(Malachite, YellowLimonite);
        Neodymium.addOreByProducts(Monazite, RareEarth);
        Bastnasite.addOreByProducts(Neodymium, RareEarth);
        Glowstone.addOreByProducts(Redstone, Gold);
        Zinc.addOreByProducts(Tin, Gallium);
        Tungsten.addOreByProducts(Manganese, Molybdenum);
        Diatomite.addOreByProducts(BandedIron, Sapphire);
        Iron.addOreByProducts(Nickel, Tin);
        Lepidolite.addOreByProducts(Lithium, Caesium);
        Gold.addOreByProducts(Copper, Nickel);
        Tin.addOreByProducts(Iron, Zinc);
        Antimony.addOreByProducts(Zinc, Iron);
        Silver.addOreByProducts(Lead, Sulfur);
        Lead.addOreByProducts(Silver, Sulfur);
        Thorium.addOreByProducts(Uranium, Lead);
        Plutonium.addOreByProducts(Uranium, Lead);
        Electrum.addOreByProducts(Gold, Silver);
        Bronze.addOreByProducts(Copper, Tin);
        Brass.addOreByProducts(Copper, Zinc);
        Coal.addOreByProducts(Lignite, Thorium);
        Ilmenite.addOreByProducts(Iron, Rutile);
        Manganese.addOreByProducts(Chrome, Iron);
        Sapphire.addOreByProducts(Aluminium, GreenSapphire);
        GreenSapphire.addOreByProducts(Aluminium, Sapphire);
        Platinum.addOreByProducts(Nickel, Iridium);
        Emerald.addOreByProducts(Beryllium, Aluminium);
        Olivine.addOreByProducts(Pyrope, Magnesium);
        Chrome.addOreByProducts(Iron, Magnesium);
        Chromite.addOreByProducts(Iron, Magnesium);
        Tetrahedrite.addOreByProducts(Antimony, Zinc);
        GarnetSand.addOreByProducts(GarnetRed, GarnetYellow);
        Magnetite.addOreByProducts(Iron, Gold);
        GraniticMineralSand.addOreByProducts(GraniteBlack, Magnetite);
        BasalticMineralSand.addOreByProducts(Basalt, Magnetite);
        Basalt.addOreByProducts(Olivine, DarkAsh);
        VanadiumMagnetite.addOreByProducts(Magnetite, Vanadium);
        Lazurite.addOreByProducts(Sodalite, Lapis);
        Sodalite.addOreByProducts(Lazurite, Lapis);
        Spodumene.addOreByProducts(Aluminium, Lithium);
        Ruby.addOreByProducts(Chrome, GarnetRed);
        Phosphor.addOreByProducts(Apatite, Phosphate);
        Iridium.addOreByProducts(Platinum, Osmium);
        Pyrope.addOreByProducts(GarnetRed, Magnesium);
        Almandine.addOreByProducts(GarnetRed, Aluminium);
        Spessartine.addOreByProducts(GarnetRed, Manganese);
        Andradite.addOreByProducts(GarnetYellow, Iron);
        Grossular.addOreByProducts(GarnetYellow, Calcium);
        Uvarovite.addOreByProducts(GarnetYellow, Chrome);
        Calcite.addOreByProducts(Andradite, Malachite);
        NaquadahEnriched.addOreByProducts(Naquadah, Naquadria);
        Naquadah.addOreByProducts(NaquadahEnriched);
        Pyrolusite.addOreByProducts(Manganese);
        Molybdenite.addOreByProducts(Molybdenum);
        Stibnite.addOreByProducts(Antimony);
        Garnierite.addOreByProducts(Nickel);
        Lignite.addOreByProducts(Coal);
        Diamond.addOreByProducts(Graphite);
        Beryllium.addOreByProducts(Emerald);
        Apatite.addOreByProducts(Phosphor);
        Magnesite.addOreByProducts(Magnesium);
        NetherQuartz.addOreByProducts(Netherrack);
        PigIron.addOreByProducts(Iron);
        Steel.addOreByProducts(Iron);
        Graphite.addOreByProducts(Carbon);
        Netherrack.addOreByProducts(Sulfur);
        Flint.addOreByProducts(Obsidian);
        Cobaltite.addOreByProducts(Cobalt);
        Cobalt.addOreByProducts(Cobaltite);
        Sulfur.addOreByProducts(Sulfur);
        Saltpeter.addOreByProducts(Saltpeter);
        Endstone.addOreByProducts(Helium3);
        Osmium.addOreByProducts(Iridium);
        Magnesium.addOreByProducts(Olivine);
        Aluminium.addOreByProducts(Bauxite);
        Titanium.addOreByProducts(Almandine);
        Obsidian.addOreByProducts(Olivine);
        Ash.addOreByProducts(Carbon);
        DarkAsh.addOreByProducts(Carbon);
        Redrock.addOreByProducts(Clay);
        Marble.addOreByProducts(Calcite);
        Clay.addOreByProducts(Clay);
        Cassiterite.addOreByProducts(Tin);
        CassiteriteSand.addOreByProducts(Tin);
        GraniteBlack.addOreByProducts(Biotite);
        GraniteRed.addOreByProducts(PotassiumFeldspar);
        Phosphate.addOreByProducts(Phosphorus);
        Phosphorus.addOreByProducts(Phosphate);
        Tanzanite.addOreByProducts(Opal);
        Opal.addOreByProducts(Tanzanite);
        Amethyst.addOreByProducts(Amethyst);
        Topaz.addOreByProducts(BlueTopaz);
        BlueTopaz.addOreByProducts(Topaz);
        Niter.addOreByProducts(Saltpeter);
        Vinteum.addOreByProducts(Vinteum);
        Lithium.addOreByProducts(Lithium);
        Silicon.addOreByProducts(SiliconDioxide);
        Salt.addOreByProducts(RockSalt);
        RockSalt.addOreByProducts(Salt);
        Andesite.addOreByProducts(Basalt);
        Diorite.addOreByProducts(NetherQuartz);
        Salt.addOreByProducts(Borax);
        RockSalt.addOreByProducts(Borax);
        Lepidolite.addOreByProducts(Boron);
        Vinteum.addEnchantmentForTools(Enchantments.field_185308_t, 2);
        BlackBronze.addEnchantmentForTools(Enchantments.field_185303_l, 2);
        RoseGold.addEnchantmentForTools(Enchantments.field_185303_l, 4);
        Invar.addEnchantmentForTools(Enchantments.field_180312_n, 3);
        BismuthBronze.addEnchantmentForTools(Enchantments.field_180312_n, 5);
        RedAlloy.setCableProperties(GTValues.V[0], 1, 0);
        Tin.setCableProperties(GTValues.V[1], 1, 1);
        Copper.setCableProperties(GTValues.V[2], 1, 2);
        RedAlloy.setCableProperties(GTValues.V[0], 1, 0);
        Cobalt.setCableProperties(GTValues.V[1], 2, 2);
        Lead.setCableProperties(GTValues.V[1], 2, 2);
        Tin.setCableProperties(GTValues.V[1], 1, 1);
        Zinc.setCableProperties(GTValues.V[1], 1, 1);
        SolderingAlloy.setCableProperties(GTValues.V[1], 1, 1);
        Iron.setCableProperties(GTValues.V[2], 2, 3);
        Nickel.setCableProperties(GTValues.V[2], 3, 3);
        Cupronickel.setCableProperties(GTValues.V[2], 2, 3);
        Copper.setCableProperties(GTValues.V[2], 1, 2);
        AnnealedCopper.setCableProperties(GTValues.V[2], 1, 1);
        Kanthal.setCableProperties(GTValues.V[3], 4, 3);
        Gold.setCableProperties(GTValues.V[3], 2, 2);
        Electrum.setCableProperties(GTValues.V[3], 3, 2);
        Silver.setCableProperties(GTValues.V[3], 1, 1);
        Nichrome.setCableProperties(GTValues.V[4], 3, 4);
        Steel.setCableProperties(GTValues.V[4], 2, 2);
        BlackSteel.setCableProperties(GTValues.V[4], 3, 2);
        Titanium.setCableProperties(GTValues.V[4], 4, 2);
        Aluminium.setCableProperties(GTValues.V[4], 1, 1);
        Graphene.setCableProperties(GTValues.V[5], 1, 1);
        Osmium.setCableProperties(GTValues.V[5], 4, 2);
        Platinum.setCableProperties(GTValues.V[5], 2, 1);
        TungstenSteel.setCableProperties(GTValues.V[5], 3, 2);
        Tungsten.setCableProperties(GTValues.V[5], 2, 2);
        HSSG.setCableProperties(GTValues.V[6], 4, 2);
        NiobiumTitanium.setCableProperties(GTValues.V[6], 4, 2);
        VanadiumGallium.setCableProperties(GTValues.V[6], 4, 2);
        YttriumBariumCuprate.setCableProperties(GTValues.V[6], 4, 4);
        Naquadah.setCableProperties(GTValues.V[7], 2, 2);
        NaquadahAlloy.setCableProperties(GTValues.V[8], 2, 4);
        Duranium.setCableProperties(GTValues.V[8], 1, 8);
        Copper.setFluidPipeProperties(25, 1000, true);
        Bronze.setFluidPipeProperties(35, 2000, true);
        Steel.setFluidPipeProperties(50, 2500, true);
        StainlessSteel.setFluidPipeProperties(100, 3000, true);
        Titanium.setFluidPipeProperties(200, 5000, true);
        TungstenSteel.setFluidPipeProperties(300, 7500, true);
        Plastic.setFluidPipeProperties(200, 350, true);
        Polytetrafluoroethylene.setFluidPipeProperties(200, 600, true);
    }
}

