/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import codechicken.lib.vec.Vector3;
import gregtech.api.block.ICustomParticleBlock;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.UIFactory;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.impl.ModularUIGui;
import gregtech.api.net.PacketBlockParticle;
import gregtech.api.net.PacketUIClientAction;
import gregtech.api.net.PacketUIOpen;
import gregtech.api.net.PacketUIWidgetUpdate;
import gregtech.api.util.GTLog;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkHandler {
    private static final HashMap<Class<? extends Packet>, PacketCodec<? extends Packet>> codecMap = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Class<? extends Packet>, PacketExecutor<? extends Packet, NetHandlerPlayClient>> clientExecutors;
    private static final HashMap<Class<? extends Packet>, PacketExecutor<? extends Packet, NetHandlerPlayServer>> serverExecutors;
    private static final IntIdentityHashBiMap<Class<? extends Packet>> packetMap;
    public static FMLEventChannel channel;

    private NetworkHandler() {
    }

    public static void init() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("gregtech");
        channel.register((Object)new NetworkHandler());
        PacketEncoder<PacketUIWidgetUpdate> widgetUpdateEncoder = (packet, buf) -> {
            buf.func_150787_b(packet.updateData.readableBytes());
            buf.writeBytes((ByteBuf)packet.updateData);
            buf.func_150787_b(packet.windowId);
            buf.func_150787_b(packet.widgetId);
        };
        PacketDecoder<PacketUIWidgetUpdate> widgetUpdateDecoder = buf -> {
            ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
            ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
            directSliceBuffer.release();
            return new PacketUIWidgetUpdate(buf.func_150792_a(), buf.func_150792_a(), new PacketBuffer(copiedDataBuffer));
        };
        NetworkHandler.registerPacket(1, PacketUIOpen.class, new PacketCodec<PacketUIOpen>((packet, buf) -> {
            buf.func_150787_b(packet.serializedHolder.readableBytes());
            buf.writeBytes((ByteBuf)packet.serializedHolder);
            buf.func_150787_b(packet.uiFactoryId);
            buf.func_150787_b(packet.windowId);
            buf.func_150787_b(packet.initialWidgetUpdates.size());
            for (PacketUIWidgetUpdate widgetUpdate : packet.initialWidgetUpdates) {
                widgetUpdateEncoder.encode(widgetUpdate, buf);
            }
        }, buf -> {
            ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
            ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
            directSliceBuffer.release();
            int uiFactoryId = buf.func_150792_a();
            int windowId = buf.func_150792_a();
            ArrayList<PacketUIWidgetUpdate> initialWidgetUpdates = new ArrayList<PacketUIWidgetUpdate>();
            int initialWidgetUpdatesCount = buf.func_150792_a();
            for (int i = 0; i < initialWidgetUpdatesCount; ++i) {
                initialWidgetUpdates.add((PacketUIWidgetUpdate)widgetUpdateDecoder.decode(buf));
            }
            return new PacketUIOpen(uiFactoryId, new PacketBuffer(copiedDataBuffer), windowId, initialWidgetUpdates);
        }));
        NetworkHandler.registerPacket(2, PacketUIWidgetUpdate.class, new PacketCodec<PacketUIWidgetUpdate>((packet, buf) -> {
            buf.func_150787_b(packet.updateData.readableBytes());
            buf.writeBytes((ByteBuf)packet.updateData);
            buf.func_150787_b(packet.windowId);
            buf.func_150787_b(packet.widgetId);
        }, buf -> {
            ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
            ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
            directSliceBuffer.release();
            return new PacketUIWidgetUpdate(buf.func_150792_a(), buf.func_150792_a(), new PacketBuffer(copiedDataBuffer));
        }));
        NetworkHandler.registerPacket(3, PacketUIClientAction.class, new PacketCodec<PacketUIClientAction>((packet, buf) -> {
            buf.func_150787_b(packet.updateData.readableBytes());
            buf.writeBytes((ByteBuf)packet.updateData);
            buf.func_150787_b(packet.windowId);
            buf.func_150787_b(packet.widgetId);
        }, buf -> {
            ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
            ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
            directSliceBuffer.release();
            return new PacketUIClientAction(buf.func_150792_a(), buf.func_150792_a(), new PacketBuffer(copiedDataBuffer));
        }));
        NetworkHandler.registerPacket(4, PacketBlockParticle.class, new PacketCodec<PacketBlockParticle>((packet, buf) -> {
            buf.func_179255_a(packet.blockPos);
            buf.writeFloat((float)packet.entityPos.x);
            buf.writeFloat((float)packet.entityPos.y);
            buf.writeFloat((float)packet.entityPos.z);
            buf.func_150787_b(packet.particlesAmount);
        }, buf -> new PacketBlockParticle(buf.func_179259_c(), new Vector3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat()), buf.func_150792_a())));
        NetworkHandler.registerServerExecutor(PacketUIClientAction.class, (packet, handler) -> {
            Container openContainer = handler.field_147369_b.field_71070_bA;
            if (openContainer instanceof ModularUIContainer && openContainer.field_75152_c == packet.windowId) {
                ModularUI modularUI = ((ModularUIContainer)openContainer).getModularUI();
                PacketBuffer buffer = packet.updateData;
                ((Widget)modularUI.guiWidgets.get((Object)packet.widgetId)).handleClientAction(buffer.func_150792_a(), buffer);
            }
        });
        if (FMLCommonHandler.instance().getSide().isClient()) {
            NetworkHandler.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void initClient() {
        NetworkHandler.registerClientExecutor(PacketUIOpen.class, (packet, handler) -> {
            UIFactory<?> uiFactory = UIFactory.FACTORY_REGISTRY.getObjectById(packet.uiFactoryId);
            if (uiFactory == null) {
                GTLog.logger.warn("Couldn't find UI Factory with id '{}'", (Object)packet.uiFactoryId);
            } else {
                uiFactory.initClientUI(packet.serializedHolder, packet.windowId, packet.initialWidgetUpdates);
            }
        });
        NetworkHandler.registerClientExecutor(PacketUIWidgetUpdate.class, (packet, handler) -> ModularUIGui.addWidgetUpdate(packet));
        NetworkHandler.registerClientExecutor(PacketBlockParticle.class, (packet, handler) -> {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IBlockState blockState = world.func_180495_p(packet.blockPos);
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            ((ICustomParticleBlock)blockState.func_177230_c()).handleCustomParticle((World)world, packet.blockPos, particleManager, packet.entityPos, packet.particlesAmount);
        });
    }

    public static <T extends Packet> void registerPacket(int packetId, Class<T> packetClass, PacketCodec<T> codec) {
        packetMap.func_186814_a(packetClass, packetId);
        codecMap.put(packetClass, codec);
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends Packet> void registerClientExecutor(Class<T> packet, PacketExecutor<T, NetHandlerPlayClient> executor) {
        clientExecutors.put(packet, executor);
    }

    public static <T extends Packet> void registerServerExecutor(Class<T> packet, PacketExecutor<T, NetHandlerPlayServer> executor) {
        serverExecutors.put(packet, executor);
    }

    public static FMLProxyPacket packet2proxy(Packet packet) {
        PacketCodec<? extends Packet> codec = codecMap.get(packet.getClass());
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150787_b(packetMap.func_186815_a(packet.getClass()));
        codec.encoder.encode(packet, buf);
        return new FMLProxyPacket(buf, "gregtech");
    }

    public static Packet proxy2packet(FMLProxyPacket packet) {
        PacketBuffer payload = (PacketBuffer)packet.payload();
        Class packetClass = (Class)packetMap.func_186813_a(payload.func_150792_a());
        PacketCodec<? extends Packet> codec = codecMap.get(packetClass);
        return codec.decoder.decode(payload);
    }

    public static NetworkRegistry.TargetPoint blockPoint(World world, BlockPos blockPos) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 128.0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        Packet packet = NetworkHandler.proxy2packet(event.getPacket());
        if (clientExecutors.containsKey(packet.getClass())) {
            PacketExecutor<? extends Packet, NetHandlerPlayClient> executor = clientExecutors.get(packet.getClass());
            executor.execute(packet, (NetHandlerPlayClient)event.getHandler());
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        Packet packet = NetworkHandler.proxy2packet(event.getPacket());
        if (serverExecutors.containsKey(packet.getClass())) {
            PacketExecutor<? extends Packet, NetHandlerPlayServer> executor = serverExecutors.get(packet.getClass());
            executor.execute(packet, (NetHandlerPlayServer)event.getHandler());
        }
    }

    static {
        serverExecutors = new HashMap();
        packetMap = new IntIdentityHashBiMap(10);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            clientExecutors = new HashMap();
        }
    }

    public static final class PacketCodec<T extends Packet> {
        public final PacketEncoder<T> encoder;
        public final PacketDecoder<T> decoder;

        public PacketCodec(PacketEncoder<T> encoder, PacketDecoder<T> decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }
    }

    @FunctionalInterface
    public static interface PacketExecutor<T, R extends INetHandler> {
        public void execute(T var1, R var2);
    }

    @FunctionalInterface
    public static interface PacketDecoder<T extends Packet> {
        public T decode(PacketBuffer var1);
    }

    @FunctionalInterface
    public static interface PacketEncoder<T extends Packet> {
        public void encode(T var1, PacketBuffer var2);
    }

    public static interface Packet {
        default public FMLProxyPacket toFMLPacket() {
            return NetworkHandler.packet2proxy(this);
        }
    }
}

