/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.SteamRecipeMapWorkableHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.render.SimpleSidedCubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SteamMetaTileEntity
extends MetaTileEntity {
    public final TextureArea BRONZE_BACKGROUND_TEXTURE;
    public final TextureArea BRONZE_SLOT_BACKGROUND_TEXTURE;
    protected final boolean isHighPressure;
    protected final OrientedOverlayRenderer renderer;
    protected SteamRecipeMapWorkableHandler workableHandler;
    protected FluidTank steamFluidTank;

    public SteamMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, OrientedOverlayRenderer renderer, boolean isHighPressure) {
        super(metaTileEntityId);
        this.workableHandler = new SteamRecipeMapWorkableHandler(this, recipeMap, isHighPressure, (IFluidTank)this.steamFluidTank, 1.0);
        this.isHighPressure = isHighPressure;
        this.renderer = renderer;
        this.BRONZE_BACKGROUND_TEXTURE = this.getFullGuiTexture("%s_gui");
        this.BRONZE_SLOT_BACKGROUND_TEXTURE = this.getFullGuiTexture("slot_%s");
    }

    @SideOnly(value=Side.CLIENT)
    private SimpleSidedCubeRenderer getBaseRenderer() {
        if (this.isHighPressure) {
            if (this.isBrickedCasing()) {
                return Textures.STEAM_BRICKED_CASING_STEEL;
            }
            return Textures.STEAM_CASING_STEEL;
        }
        if (this.isBrickedCasing()) {
            return Textures.STEAM_BRICKED_CASING_BRONZE;
        }
        return Textures.STEAM_CASING_BRONZE;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            EnumFacing currentVentingSide = this.workableHandler.getVentingSide();
            if (currentVentingSide == facing || this.getFrontFacing() == facing) {
                return false;
            }
            this.workableHandler.setVentingSide(facing);
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.getBaseRenderer().getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.TOP);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
        this.renderer.render(renderState, translation, pipeline, this.getFrontFacing(), this.workableHandler.isActive());
        Textures.PIPE_OUT_OVERLAY.renderSided(this.workableHandler.getVentingSide(), renderState, translation, pipeline);
    }

    protected boolean isBrickedCasing() {
        return false;
    }

    @Override
    public FluidTankList createImportFluidHandler() {
        this.steamFluidTank = new FilteredFluidHandler(this.getSteamCapacity()).setFillPredicate(ModHandler::isSteam);
        return new FluidTankList(false, new IFluidTank[]{this.steamFluidTank});
    }

    public int getSteamCapacity() {
        return 16000;
    }

    protected TextureArea getFullGuiTexture(String pathTemplate) {
        String type = this.isHighPressure ? "steel" : "bronze";
        return TextureArea.fullImage(String.format("textures/gui/steam/%s/%s.png", type, pathTemplate.replace("%s", type)));
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        return ModularUI.builder(this.BRONZE_BACKGROUND_TEXTURE, 176, 166).widget(new LabelWidget(6, 6, this.getMetaFullName(), new Object[0])).widget(new ImageWidget(79, 42, 18, 18, this.getFullGuiTexture("not_enough_steam_%s")).setPredicate(() -> this.workableHandler.isHasNotEnoughEnergy())).bindPlayerInventory(player.field_71071_by, this.BRONZE_SLOT_BACKGROUND_TEXTURE);
    }
}

