/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetUIAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;

public class AbstractWidgetGroup
extends Widget {
    private List<Widget> widgets = new ArrayList<Widget>();
    private WidgetGroupUIAccess groupUIAccess = new WidgetGroupUIAccess();
    private boolean isInitialized;
    private boolean isVisible = true;

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        this.widgets.stream().flatMap(it -> it.getNativeWidgets().stream()).forEach(it -> it.setEnabled(visible));
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected void addWidget(Widget widget) {
        if (this.isInitialized) {
            throw new IllegalStateException("Cannot add widgets after initialization!");
        }
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (!this.widgets.contains(widget)) {
            this.widgets.add(widget);
            widget.setUiAccess(this.groupUIAccess);
        }
    }

    public boolean isWidgetVisible(Widget widget) {
        return this.isVisible;
    }

    public boolean isWidgetClickable(Widget widget) {
        return this.isWidgetVisible(widget);
    }

    @Override
    public void initWidget() {
        this.isInitialized = true;
        for (Widget widget : this.widgets) {
            widget.setGui(this.gui);
            widget.setSizes(this.sizes);
            widget.initWidget();
        }
    }

    @Override
    public List<INativeWidget> getNativeWidgets() {
        ArrayList<INativeWidget> nativeWidgets = new ArrayList<INativeWidget>();
        for (Widget widget : this.widgets) {
            nativeWidgets.addAll(widget.getNativeWidgets());
        }
        if (this instanceof INativeWidget) {
            nativeWidgets.add((INativeWidget)((Object)this));
        }
        return nativeWidgets;
    }

    @Override
    public void detectAndSendChanges() {
        for (Widget widget : this.widgets) {
            widget.detectAndSendChanges();
        }
    }

    @Override
    public void updateScreen() {
        for (Widget widget : this.widgets) {
            widget.updateScreen();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetVisible(widget)) continue;
            widget.drawInForeground(mouseX, mouseY);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetVisible(widget)) continue;
            widget.drawInBackground(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetClickable(widget) || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetClickable(widget) || !widget.mouseDragged(mouseX, mouseY, button, timeDragged)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetClickable(widget) || !widget.mouseReleased(mouseX, mouseY, mouseX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetClickable(widget) || !widget.keyTyped(charTyped, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.readUpdateInfo(widgetUpdateId, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.handleClientAction(widgetUpdateId, buffer);
        }
    }

    private class WidgetGroupUIAccess
    implements WidgetUIAccess {
        private WidgetGroupUIAccess() {
        }

        @Override
        public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeClientAction(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }

        @Override
        public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }
    }
}

