/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.util;

import java.awt.Color;
import mekanism.api.IHeatTransfer;
import mekanism.api.transmitters.IGridTransmitter;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HeatUtils {
    @CapabilityInject(value=IGridTransmitter.class)
    public static Capability<IGridTransmitter> GRID_TRANSMITTER_CAPABILITY = null;

    public static double[] simulate(IHeatTransfer source) {
        double[] heatTransferred = new double[]{0.0, 0.0};
        for (EnumFacing side : EnumFacing.field_82609_l) {
            double heatToTransfer;
            double invConduction;
            IHeatTransfer sink = source.getAdjacent(side);
            if (sink != null) {
                invConduction = sink.getInverseConductionCoefficient() + source.getInverseConductionCoefficient();
                heatToTransfer = source.getTemp() / invConduction;
                source.transferHeatTo(-heatToTransfer);
                sink.transferHeatTo(heatToTransfer);
                if (sink instanceof ICapabilityProvider && GRID_TRANSMITTER_CAPABILITY != null && ((ICapabilityProvider)sink).hasCapability(GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) continue;
                heatTransferred[0] = heatTransferred[0] + heatToTransfer;
                continue;
            }
            invConduction = 10000.0 + source.getInsulationCoefficient(side) + source.getInverseConductionCoefficient();
            heatToTransfer = source.getTemp() / invConduction;
            source.transferHeatTo(-heatToTransfer);
            heatTransferred[1] = heatTransferred[1] + heatToTransfer;
        }
        return heatTransferred;
    }

    public static Color getHeatColor(double temperature) {
        int red = (temperature /= 100.0) <= 66.0 ? 255 : MathHelper.func_76125_a((int)((int)(329.698727446 * Math.pow(temperature - 60.0, -0.1332047592))), (int)0, (int)255);
        int green = temperature <= 66.0 ? MathHelper.func_76125_a((int)((int)(99.4708025861 * Math.log(temperature) - 161.1195681661)), (int)0, (int)255) : MathHelper.func_76125_a((int)((int)(288.1221695283 * Math.pow(temperature - 60.0, -0.0755148492))), (int)0, (int)255);
        int blue = temperature >= 66.0 ? 255 : (temperature <= 19.0 ? 0 : MathHelper.func_76125_a((int)((int)(138.5177312231 * Math.log(temperature - 10.0) - 305.0447927307)), (int)0, (int)255));
        return new Color(red, green, blue);
    }
}

