/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentMysticalMechanics;
import modulardiversity.jei.ingredients.MysticalMechanics;
import modulardiversity.util.IResourceToken;

public class RequirementMysticalMechanics
extends RequirementConsumePerTick<MysticalMechanics, ResourceToken> {
    private double requiredLevelMin;
    private double requiredLevelMax;
    private double levelOutput;

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double requiredLevelMin, double requiredLevelMax) {
        this(actionType, requiredLevelMin, requiredLevelMax, 0.0);
    }

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double levelOutput) {
        this(actionType, 0.0, 0.0, levelOutput);
    }

    public RequirementMysticalMechanics(MachineComponent.IOType actionType, double requiredLevelMin, double requiredLevelMax, double levelOutput) {
        super(ComponentType.Registry.getComponent((String)"mysticalmechanics"), actionType);
        this.requiredLevelMin = requiredLevelMin;
        this.requiredLevelMax = requiredLevelMax;
        this.levelOutput = levelOutput;
    }

    public double getRequiredLevelMin() {
        return this.requiredLevelMin;
    }

    public double getRequiredLevelMax() {
        return this.requiredLevelMax;
    }

    public double getLevelOutput() {
        return this.levelOutput;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredLevelMin, this.requiredLevelMax, this.levelOutput);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("mysticalmechanics") && component instanceof MachineComponents.MysticalMechanicsHatch && component.getIOType() == this.getActionType();
    }

    public ComponentRequirement<MysticalMechanics> deepCopy() {
        return new RequirementMysticalMechanics(this.getActionType(), this.requiredLevelMin, this.requiredLevelMax, this.levelOutput);
    }

    public ComponentRequirement.JEIComponent<MysticalMechanics> provideJEIComponent() {
        return new JEIComponentMysticalMechanics(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private double requiredLevelMin;
        private double requiredLevelMax;
        private double outputLevel;
        private boolean requiredlevelMet;

        public ResourceToken(double requiredLevelMin, double requiredLevelMax, double outputLevel) {
            this.requiredLevelMin = requiredLevelMin;
            this.requiredLevelMax = requiredLevelMax;
            this.outputLevel = outputLevel;
        }

        public double getRequiredLevelMin() {
            return this.requiredLevelMin;
        }

        public double getRequiredLevelMax() {
            return this.requiredLevelMax;
        }

        public double getOutputLevel() {
            return this.outputLevel;
        }

        public void setRequiredlevelMet() {
            this.requiredlevelMet = true;
        }

        @Override
        public float getModifier() {
            return 0.0f;
        }

        @Override
        public void setModifier(float modifier) {
        }

        @Override
        public boolean isEmpty() {
            return this.requiredlevelMet;
        }
    }
}

