/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentMekHeat;
import modulardiversity.jei.ingredients.MekHeat;
import modulardiversity.util.IResourceToken;

public class RequirementMekHeat
extends RequirementConsumePerTick<MekHeat, ResourceToken> {
    double temperature;
    double temperatureRequiredMin;
    double temperatureRequiredMax;

    public RequirementMekHeat(MachineComponent.IOType actionType, double temperature, double temperatureRequiredMin, double temperatureRequiredMax) {
        super(ComponentType.Registry.getComponent((String)"mekheat"), actionType);
        this.temperature = temperature;
        this.temperatureRequiredMin = temperatureRequiredMin;
        this.temperatureRequiredMax = temperatureRequiredMax;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTemperatureRequiredMax() {
        return this.temperatureRequiredMax;
    }

    public double getTemperatureRequiredMin() {
        return this.temperatureRequiredMin;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.temperature, this.temperatureRequiredMin, this.temperatureRequiredMax);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("mekheat") && component instanceof MachineComponents.MekHeatHatch && component.getIOType() == this.getActionType();
    }

    public ComponentRequirement<MekHeat> deepCopy() {
        return new RequirementMekHeat(this.getActionType(), this.temperature, this.temperatureRequiredMin, this.temperatureRequiredMax);
    }

    public ComponentRequirement.JEIComponent<MekHeat> provideJEIComponent() {
        return new JEIComponentMekHeat(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        public double temperature;
        public double requiredTemperatureMin;
        public double requiredTemperatureMax;
        private boolean requiredTemperatureMet;

        public ResourceToken(double temperature, double requiredTemperatureMin, double requiredTemperatureMax) {
            this.temperature = temperature;
            this.requiredTemperatureMin = requiredTemperatureMin;
            this.requiredTemperatureMax = requiredTemperatureMax;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public double getRequiredTemperatureMin() {
            return this.requiredTemperatureMin;
        }

        public double getRequiredTemperatureMax() {
            return this.requiredTemperatureMax;
        }

        public void setTemperatureMet() {
            this.requiredTemperatureMet = true;
        }

        @Override
        public float getModifier() {
            return (float)this.temperature;
        }

        @Override
        public void setModifier(float modifier) {
            this.temperature = modifier;
        }

        @Override
        public boolean isEmpty() {
            return this.requiredTemperatureMet;
        }
    }
}

