/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentHotAir;
import modulardiversity.jei.ingredients.HotAir;
import modulardiversity.util.IResourceToken;

public class RequirementHotAir
extends RequirementConsumePerTick<HotAir, ResourceToken> {
    public final int requiredTemp;

    public RequirementHotAir(MachineComponent.IOType ioType, int requiredTemp) {
        super(ComponentType.Registry.getComponent((String)"hotair"), ioType);
        this.requiredTemp = requiredTemp;
    }

    public ComponentRequirement deepCopy() {
        return new RequirementHotAir(this.getActionType(), this.requiredTemp);
    }

    public ComponentRequirement.JEIComponent<HotAir> provideJEIComponent() {
        return new JEIComponentHotAir(this);
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredTemp);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("hotair") && component instanceof MachineComponents.HotAirHatch && component.getIOType() == this.getActionType();
    }

    public static class ResourceToken
    implements IResourceToken {
        private int tempRequired;
        private boolean requiredTempMet;

        public ResourceToken(int tempRequired) {
            this.tempRequired = tempRequired;
        }

        public int getRequiredTemp() {
            return this.tempRequired;
        }

        public void setRequiredTempMet() {
            this.requiredTempMet = true;
        }

        @Override
        public float getModifier() {
            return this.tempRequired;
        }

        @Override
        public void setModifier(float modifier) {
            this.tempRequired = (int)modifier;
        }

        @Override
        public boolean isEmpty() {
            return this.requiredTempMet;
        }
    }
}

