/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumeOnce;
import modulardiversity.jei.JEIComponentEmber;
import modulardiversity.jei.ingredients.Embers;
import modulardiversity.util.IResourceToken;

public class RequirementEmber
extends RequirementConsumeOnce<Embers, ResourceToken> {
    public double requiredEmber;

    public RequirementEmber(MachineComponent.IOType actionType, double requiredEmber) {
        super(ComponentType.Registry.getComponent((String)"ember"), actionType);
        this.requiredEmber = requiredEmber;
    }

    public ComponentRequirement deepCopy() {
        return new RequirementEmber(this.getActionType(), this.requiredEmber);
    }

    public ComponentRequirement.JEIComponent<Embers> provideJEIComponent() {
        return new JEIComponentEmber(this);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("ember") && component instanceof MachineComponents.EmberHatch && component.getIOType() == this.getActionType();
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredEmber);
    }

    public static class ResourceToken
    implements IResourceToken {
        private double ember;

        public ResourceToken(double ember) {
            this.ember = ember;
        }

        public double getEmber() {
            return this.ember;
        }

        public void setEmber(double ember) {
            this.ember = ember;
        }

        @Override
        public float getModifier() {
            return (float)this.ember;
        }

        @Override
        public void setModifier(float modifier) {
            this.ember = modifier;
        }

        @Override
        public boolean isEmpty() {
            return this.ember <= 0.0;
        }
    }
}

