/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.ticket;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ticket.ITicketManager;

public abstract class SimpleTicket<T> {
    @Nullable
    private ITicketManager<T> manager;
    protected boolean isValid = false;

    public final void setBackend(@Nonnull ITicketManager<T> ticketManager) {
        Preconditions.checkState((this.manager == null ? 1 : 0) != 0, (Object)"Ticket is already registered to a managing system");
        this.manager = ticketManager;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        Preconditions.checkState((this.manager != null ? 1 : 0) != 0, (Object)"Ticket is not registered to a managing system");
        if (this.isValid()) {
            this.manager.remove(this);
        }
        this.isValid = false;
    }

    public void validate() {
        Preconditions.checkState((this.manager != null ? 1 : 0) != 0, (Object)"Ticket is not registered to a managing system");
        if (!this.isValid()) {
            this.manager.add(this);
        }
        this.isValid = true;
    }

    public abstract boolean matches(T var1);
}

