/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.rotations;

import com.google.common.collect.Maps;
import java.nio.FloatBuffer;
import java.util.Map;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.geometry.Orientation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class TransformProvider {
    public static final TransformProvider instance = new TransformProvider();
    private final Map<Orientation, Transformation> transformations = Maps.newEnumMap(Orientation.class);

    private TransformProvider() {
    }

    private Transformation getTransformation(Orientation orientation) {
        Transformation r = this.transformations.get((Object)orientation);
        if (r == null) {
            r = new Transformation(orientation);
            this.transformations.put(orientation, r);
        }
        return r;
    }

    public Matrix4f getMatrixForOrientation(Orientation orientation) {
        Transformation transformation = this.getTransformation(orientation);
        return new Matrix4f(transformation.asMatrix);
    }

    public Matrix4f getInverseMatrixForOrientation(Orientation orientation) {
        Transformation transformation = this.getTransformation(orientation);
        return new Matrix4f(transformation.asInverseMatrix);
    }

    public void multMatrix(Orientation orientation) {
        Transformation transformation = this.getTransformation(orientation);
        GL11.glMultMatrix((FloatBuffer)transformation.asBuffer);
        transformation.asBuffer.rewind();
    }

    public void multInverseMatrix(Orientation orientation) {
        Transformation transformation = this.getTransformation(orientation);
        GL11.glMultMatrix((FloatBuffer)transformation.asInverseBuffer);
        transformation.asInverseBuffer.rewind();
    }

    private static class Transformation {
        private final Matrix4f asMatrix;
        private final Matrix4f asInverseMatrix;
        private final FloatBuffer asBuffer;
        private final FloatBuffer asInverseBuffer;

        public Transformation(Orientation orientation) {
            javax.vecmath.Matrix4f originalMatrix = new javax.vecmath.Matrix4f();
            originalMatrix.set(orientation.getLocalToWorldMatrix());
            this.asMatrix = TRSRTransformation.toLwjgl((javax.vecmath.Matrix4f)originalMatrix);
            this.asBuffer = BufferUtils.createFloatBuffer((int)16);
            this.asMatrix.store(this.asBuffer);
            this.asBuffer.rewind();
            this.asInverseMatrix = new Matrix4f();
            Matrix4f.invert((Matrix4f)this.asMatrix, (Matrix4f)this.asInverseMatrix);
            this.asInverseBuffer = BufferUtils.createFloatBuffer((int)16);
            this.asInverseMatrix.store(this.asInverseBuffer);
            this.asInverseBuffer.rewind();
        }
    }
}

