/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.executable.IExecutable;

public class SingleExprEvaluator<E, M> {
    private final Calculator<E, M> calculator;
    private boolean useFallback;
    private M exprType;
    private String expr;
    private IExecutable<E> compiledExpr;

    public SingleExprEvaluator(Calculator<E, M> calculator) {
        this.calculator = calculator;
    }

    public static <E, M> SingleExprEvaluator<E, M> create(Calculator<E, M> calculator) {
        return new SingleExprEvaluator<E, M>(calculator);
    }

    public void setExpr(M exprType, String expr) {
        this.exprType = exprType;
        this.expr = expr;
        this.compiledExpr = null;
        this.useFallback = false;
    }

    public boolean isExprValid() {
        if (this.useFallback) {
            return false;
        }
        if (this.compiledExpr == null) {
            try {
                this.compiledExpr = this.calculator.compilers.compile(this.exprType, this.expr);
            }
            catch (Exception ex) {
                this.useFallback = true;
                return false;
            }
        }
        return true;
    }

    public E evaluate(EnvironmentConfigurator<E> conf, Supplier<E> fallbackValue) {
        if (this.useFallback || Strings.isNullOrEmpty((String)this.expr) || this.exprType == null) {
            return (E)fallbackValue.get();
        }
        if (this.compiledExpr == null) {
            try {
                this.compiledExpr = this.calculator.compilers.compile(this.exprType, this.expr);
            }
            catch (Exception ex) {
                this.useFallback = true;
                return (E)fallbackValue.get();
            }
        }
        conf.accept(this.calculator.environment);
        try {
            return this.calculator.environment.executeAndPop(this.compiledExpr);
        }
        catch (Exception ex) {
            this.useFallback = true;
            return (E)fallbackValue.get();
        }
    }

    public static interface EnvironmentConfigurator<E> {
        public void accept(Environment<E> var1);
    }
}

