/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.base.IFactory;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TileEntityAdvancedElectricMachine<RECIPE extends AdvancedMachineRecipe<RECIPE>>
extends TileEntityBasicMachine<AdvancedMachineInput, ItemStackOutput, RECIPE>
implements IGasHandler,
ITubeConnection,
ITierUpgradeable,
ISustainedData {
    public int BASE_SECONDARY_ENERGY_PER_TICK;
    public double secondaryEnergyPerTick;
    public int secondaryEnergyThisTick;
    public static int MAX_GAS = 210;
    public GasTank gasTank;
    public Gas prevGas;
    private static final String[] methods = new String[]{"getEnergy", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityAdvancedElectricMachine(String soundPath, String name, double maxEnergy, double baseEnergyUsage, int ticksRequired, int secondaryPerTick) {
        super(soundPath, name, maxEnergy, baseEnergyUsage, 4, ticksRequired, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiAdvancedMachine.png"));
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 0, 3, 0, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.gasTank = new GasTank(MAX_GAS);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.BASE_SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.secondaryEnergyPerTick = secondaryPerTick;
        if (this.upgradeableSecondaryEfficiency()) {
            this.upgradeComponent.setSupported(Upgrade.GAS);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier != Tier.BaseTier.BASIC) {
            return false;
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5), 3);
        TileEntityFactory factory = (TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v());
        IFactory.RecipeType type = IFactory.RecipeType.getFromMachine(this.func_145838_q(), this.func_145832_p());
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.soundURL = this.soundURL;
        factory.progress[0] = this.operatingTicks;
        factory.updateDelay = this.updateDelay;
        factory.isActive = this.isActive;
        factory.clientActive = this.clientActive;
        factory.controlType = this.controlType;
        factory.prevEnergy = this.prevEnergy;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.upgradeComponent.setUpgradeSlot(0);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.recipeType = type;
        factory.upgradeComponent.setSupported(Upgrade.GAS, type.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        for (TransmissionType transmission : this.configComponent.transmissions) {
            factory.configComponent.setConfig(transmission, this.configComponent.getConfig(transmission).asByteArray());
            factory.configComponent.setEjecting(transmission, this.configComponent.isEjecting(transmission));
        }
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.inventory.set(5, this.inventory.get(0));
        factory.inventory.set(4, this.inventory.get(1));
        factory.inventory.set(8, this.inventory.get(2));
        factory.inventory.set(1, this.inventory.get(3));
        factory.inventory.set(0, this.inventory.get(4));
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        return true;
    }

    public abstract GasStack getItemGas(ItemStack var1);

    public abstract boolean isValidGas(Gas var1);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            this.handleSecondaryFuel();
            boolean inactive = false;
            MachineRecipe recipe = this.getRecipe();
            int n = this.secondaryEnergyThisTick = this.useStatisticalMechanics() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
                this.gasTank.draw(this.secondaryEnergyThisTick, true);
                this.electricityStored -= this.energyPerTick;
            } else {
                inactive = true;
                this.setActive(false);
            }
            if (inactive && this.getRecipe() == null) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.gasTank.getGasType() != null && this.gasTank.getStored() != 0) {
                this.prevGas = this.gasTank.getGasType();
            }
        }
    }

    public void handleSecondaryFuel() {
        if (!((ItemStack)this.inventory.get(1)).func_190926_b() && this.gasTank.getNeeded() > 0) {
            GasStack stack = this.getItemGas((ItemStack)this.inventory.get(1));
            int gasNeeded = this.gasTank.getNeeded();
            if (stack != null && this.gasTank.canReceive(stack.getGas()) && gasNeeded >= stack.amount) {
                this.gasTank.receive(stack, true);
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
        }
    }

    public boolean upgradeableSecondaryEfficiency() {
        return false;
    }

    public boolean useStatisticalMechanics() {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 4) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            for (AdvancedMachineInput input : this.getRecipes().keySet()) {
                if (!input.itemStack.func_77969_a(itemstack)) continue;
                return true;
            }
        } else {
            if (slotID == 3) {
                return ChargeUtils.canBeDischarged(itemstack);
            }
            if (slotID == 1) {
                return this.getItemGas(itemstack) != null;
            }
        }
        return false;
    }

    @Override
    public AdvancedMachineInput getInput() {
        return new AdvancedMachineInput((ItemStack)this.inventory.get(0), this.prevGas);
    }

    @Override
    public RECIPE getRecipe() {
        AdvancedMachineInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((AdvancedMachineInput)((AdvancedMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((AdvancedMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((AdvancedMachineRecipe)recipe).operate((NonNullList<ItemStack>)this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((AdvancedMachineRecipe)recipe).canOperate((NonNullList<ItemStack>)this.inventory, 0, 2, this.gasTank, this.secondaryEnergyThisTick);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (dataStream.readBoolean()) {
                this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
            } else {
                this.gasTank.setGas(null);
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.gasTank.setMaxGas(MAX_GAS);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.SPEED || this.upgradeableSecondaryEfficiency() && upgrade == Upgrade.GAS) {
            this.secondaryEnergyPerTick = MekanismUtils.getSecondaryEnergyPerTickMean(this, this.BASE_SECONDARY_ENERGY_PER_TICK);
        }
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.gasTank.getStored()};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate(RecipeHandler.getRecipe(this.getInput(), this.getRecipes()))};
            }
            case 6: {
                return new Object[]{this.maxEnergy};
            }
            case 7: {
                return new Object[]{this.maxEnergy - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        GasUtils.writeSustainedData(this.gasTank, itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        GasUtils.readSustainedData(this.gasTank, itemStack);
    }
}

