/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.IUpgradeItem;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileComponentUpgrade
implements ITileComponent {
    public static int UPGRADE_TICKS_REQUIRED = 40;
    private Map<Upgrade, Integer> upgrades = new HashMap<Upgrade, Integer>();
    private Set<Upgrade> supported = new HashSet<Upgrade>();
    private int upgradeSlot;
    public int upgradeTicks;
    public TileEntityContainerBlock tileEntity;

    public TileComponentUpgrade(TileEntityContainerBlock tile, int slot) {
        this.tileEntity = tile;
        this.upgradeSlot = slot;
        this.setSupported(Upgrade.SPEED);
        this.setSupported(Upgrade.ENERGY);
        tile.components.add(this);
    }

    public void readFrom(TileComponentUpgrade upgrade) {
        this.upgrades = upgrade.upgrades;
        this.supported = upgrade.supported;
        this.upgradeSlot = upgrade.upgradeSlot;
        this.upgradeTicks = upgrade.upgradeTicks;
    }

    @Override
    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            if (!((ItemStack)this.tileEntity.inventory.get(this.upgradeSlot)).func_190926_b() && ((ItemStack)this.tileEntity.inventory.get(this.upgradeSlot)).func_77973_b() instanceof IUpgradeItem) {
                Upgrade type = ((IUpgradeItem)((ItemStack)this.tileEntity.inventory.get(this.upgradeSlot)).func_77973_b()).getUpgradeType((ItemStack)this.tileEntity.inventory.get(this.upgradeSlot));
                if (this.supports(type) && this.getUpgrades(type) < type.getMax()) {
                    if (this.upgradeTicks < UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        this.addUpgrade(type);
                        ((ItemStack)this.tileEntity.inventory.get(this.upgradeSlot)).func_190918_g(1);
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), this.tileEntity.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this.tileEntity)));
                        this.tileEntity.func_70296_d();
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
        }
    }

    public int getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public void setUpgradeSlot(int i) {
        this.upgradeSlot = i;
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / UPGRADE_TICKS_REQUIRED;
    }

    public int getUpgrades(Upgrade upgrade) {
        if (this.upgrades.get((Object)upgrade) == null) {
            return 0;
        }
        return this.upgrades.get((Object)upgrade);
    }

    public void addUpgrade(Upgrade upgrade) {
        this.upgrades.put(upgrade, Math.min(upgrade.getMax(), this.getUpgrades(upgrade) + 1));
        this.tileEntity.recalculateUpgradables(upgrade);
    }

    public void removeUpgrade(Upgrade upgrade) {
        this.upgrades.put(upgrade, Math.max(0, this.getUpgrades(upgrade) - 1));
        if (this.upgrades.get((Object)upgrade) == 0) {
            this.upgrades.remove((Object)upgrade);
        }
        this.tileEntity.recalculateUpgradables(upgrade);
    }

    public void setSupported(Upgrade upgrade) {
        this.setSupported(upgrade, true);
    }

    public void setSupported(Upgrade upgrade, boolean isSupported) {
        if (isSupported) {
            this.supported.add(upgrade);
        } else {
            this.supported.remove((Object)upgrade);
        }
    }

    public boolean supports(Upgrade upgrade) {
        return this.supported.contains((Object)upgrade);
    }

    public Set<Upgrade> getInstalledTypes() {
        return this.upgrades.keySet();
    }

    public Set<Upgrade> getSupportedTypes() {
        return this.supported;
    }

    public void clearSupportedTypes() {
        this.supported.clear();
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.upgrades.clear();
        int amount = dataStream.readInt();
        for (int i = 0; i < amount; ++i) {
            this.upgrades.put(Upgrade.values()[dataStream.readInt()], dataStream.readInt());
        }
        this.upgradeTicks = dataStream.readInt();
        for (Upgrade upgrade : this.getSupportedTypes()) {
            this.tileEntity.recalculateUpgradables(upgrade);
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.upgrades.size());
        for (Map.Entry<Upgrade, Integer> entry : this.upgrades.entrySet()) {
            data.add(entry.getKey().ordinal());
            data.add(entry.getValue());
        }
        data.add(this.upgradeTicks);
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.upgrades = Upgrade.buildMap(nbtTags);
        for (Upgrade upgrade : this.getSupportedTypes()) {
            this.tileEntity.recalculateUpgradables(upgrade);
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        Upgrade.saveMap(this.upgrades, nbtTags);
    }

    @Override
    public void invalidate() {
    }
}

