/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileComponentEjector
implements ITileComponent {
    public TileEntityContainerBlock tileEntity;
    public boolean strictInput;
    public EnumColor outputColor;
    public EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    public int tickDelay = 0;
    public Map<TransmissionType, SideData> sideData = new HashMap<TransmissionType, SideData>();
    public Map<TransmissionType, int[]> trackers = new HashMap<TransmissionType, int[]>();
    public static final int GAS_OUTPUT = 256;
    public static final int FLUID_OUTPUT = 256;

    public TileComponentEjector(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public TileComponentEjector setOutputData(TransmissionType type, SideData data) {
        this.sideData.put(type, data);
        this.trackers.put(type, new int[data.availableSlots.length]);
        return this;
    }

    public void readFrom(TileComponentEjector ejector) {
        this.strictInput = ejector.strictInput;
        this.outputColor = ejector.outputColor;
        this.inputColors = ejector.inputColors;
        this.tickDelay = ejector.tickDelay;
        this.sideData = ejector.sideData;
    }

    private List<EnumFacing> getTrackedOutputs(TransmissionType type, int index, List<EnumFacing> dirs) {
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>();
        for (int i = this.trackers.get((Object)type)[index] + 1; i <= this.trackers.get((Object)type)[index] + 6; ++i) {
            for (EnumFacing side : dirs) {
                if (EnumFacing.func_82600_a((int)(i % 6)) != side) continue;
                sides.add(side);
            }
        }
        return sides;
    }

    @Override
    public void tick() {
        if (this.tickDelay == 0) {
            if (this.sideData.get((Object)TransmissionType.ITEM) != null) {
                this.outputItems();
            }
        } else {
            --this.tickDelay;
        }
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            int emit;
            GasStack toEmit;
            GasTank tank;
            List<EnumFacing> outputSides;
            SideData data;
            if (this.sideData.get((Object)TransmissionType.GAS) != null && this.getEjecting(TransmissionType.GAS)) {
                data = this.sideData.get((Object)TransmissionType.GAS);
                outputSides = this.getOutputSides(TransmissionType.GAS, data);
                if (((ITankManager)((Object)this.tileEntity)).getTanks() != null && (tank = (GasTank)((ITankManager)((Object)this.tileEntity)).getTanks()[data.availableSlots[0]]).getStored() > 0) {
                    toEmit = tank.getGas().copy().withAmount(Math.min(256, tank.getStored()));
                    emit = GasUtils.emit(toEmit, this.tileEntity, outputSides);
                    tank.draw(emit, true);
                }
            }
            if (this.sideData.get((Object)TransmissionType.FLUID) != null && this.getEjecting(TransmissionType.FLUID)) {
                data = this.sideData.get((Object)TransmissionType.FLUID);
                outputSides = this.getOutputSides(TransmissionType.FLUID, data);
                if (((ITankManager)((Object)this.tileEntity)).getTanks() != null && (tank = (FluidTank)((ITankManager)((Object)this.tileEntity)).getTanks()[data.availableSlots[0]]).getFluidAmount() > 0) {
                    toEmit = PipeUtils.copy(tank.getFluid(), Math.min(256, tank.getFluidAmount()));
                    emit = PipeUtils.emit(outputSides, (FluidStack)toEmit, this.tileEntity);
                    tank.drain(emit, true);
                }
            }
        }
    }

    public List<EnumFacing> getOutputSides(TransmissionType type, SideData data) {
        ArrayList<EnumFacing> outputSides = new ArrayList<EnumFacing>();
        ISideConfiguration configurable = (ISideConfiguration)((Object)this.tileEntity);
        SideConfig sideConfig = configurable.getConfig().getConfig(type);
        ArrayList<SideData> outputs = configurable.getConfig().getOutputs(type);
        EnumFacing[] facings = MekanismUtils.getBaseOrientations(this.tileEntity.facing);
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing side = facings[i];
            if (sideConfig.get(side) != outputs.indexOf(data)) continue;
            outputSides.add(EnumFacing.field_82609_l[i]);
        }
        return outputSides;
    }

    public void outputItems() {
        if (!this.getEjecting(TransmissionType.ITEM) || this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        SideData data = this.sideData.get((Object)TransmissionType.ITEM);
        List<EnumFacing> outputSides = this.getOutputSides(TransmissionType.ITEM, data);
        for (int index = 0; index < this.sideData.get((Object)((Object)TransmissionType.ITEM)).availableSlots.length; ++index) {
            int slotID = this.sideData.get((Object)((Object)TransmissionType.ITEM)).availableSlots[index];
            if (this.tileEntity.func_70301_a(slotID).func_190926_b()) continue;
            ItemStack stack = this.tileEntity.func_70301_a(slotID);
            List<EnumFacing> outputs = this.getTrackedOutputs(TransmissionType.ITEM, index, outputSides);
            for (EnumFacing side : outputs) {
                TransitRequest.TransitResponse response;
                TileEntity tile = Coord4D.get(this.tileEntity).offset(side).getTileEntity((IBlockAccess)this.tileEntity.func_145831_w());
                ItemStack prev = stack.func_77946_l();
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d())) {
                    response = TransporterUtils.insert(this.tileEntity, CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d()), TransitRequest.getFromStack(stack.func_77946_l()), this.outputColor, true, 0);
                    if (!response.isEmpty()) {
                        stack.func_190918_g(response.stack.func_190916_E());
                    }
                } else {
                    response = InventoryUtils.putStackInInventory(tile, TransitRequest.getFromStack(stack.func_77946_l()), side, false);
                    if (!response.isEmpty()) {
                        stack.func_190918_g(response.stack.func_190916_E());
                    }
                }
                if (stack.func_190926_b() || prev.func_190916_E() != stack.func_190916_E()) {
                    this.trackers.get((Object)((Object)TransmissionType.ITEM))[index] = side.ordinal();
                }
                if (!stack.func_190926_b()) continue;
                break;
            }
            this.tileEntity.func_70299_a(slotID, stack);
            this.tileEntity.func_70296_d();
        }
        this.tickDelay = 20;
    }

    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setInputColor(EnumFacing side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getInputColor(EnumFacing side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.strictInput = nbtTags.func_74767_n("strictInput");
        if (nbtTags.func_74764_b("ejectColor")) {
            this.outputColor = TransporterUtils.colors.get(nbtTags.func_74762_e("ejectColor"));
        }
        for (TransmissionType type : this.sideData.keySet()) {
            for (int i = 0; i < this.sideData.get((Object)((Object)type)).availableSlots.length; ++i) {
                this.trackers.get((Object)((Object)type))[i] = nbtTags.func_74762_e("tracker" + type.getTransmission() + i);
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (!nbtTags.func_74764_b("inputColors" + i)) continue;
            int inC = nbtTags.func_74762_e("inputColors" + i);
            this.inputColors[i] = inC != -1 ? TransporterUtils.colors.get(inC) : null;
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.strictInput = dataStream.readBoolean();
        int c = dataStream.readInt();
        this.outputColor = c != -1 ? TransporterUtils.colors.get(c) : null;
        for (int i = 0; i < 6; ++i) {
            int inC = dataStream.readInt();
            this.inputColors[i] = inC != -1 ? TransporterUtils.colors.get(inC) : null;
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            nbtTags.func_74768_a("ejectColor", TransporterUtils.colors.indexOf((Object)this.outputColor));
        }
        for (TransmissionType type : this.sideData.keySet()) {
            for (int i = 0; i < this.sideData.get((Object)((Object)type)).availableSlots.length; ++i) {
                nbtTags.func_74768_a("tracker" + type.getTransmission() + i, this.trackers.get((Object)type)[i]);
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (this.inputColors[i] == null) {
                nbtTags.func_74768_a("inputColors" + i, -1);
                continue;
            }
            nbtTags.func_74768_a("inputColors" + i, TransporterUtils.colors.indexOf((Object)this.inputColors[i]));
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.strictInput);
        if (this.outputColor != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.outputColor));
        } else {
            data.add(-1);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.inputColors[i] == null) {
                data.add(-1);
                continue;
            }
            data.add(TransporterUtils.colors.indexOf((Object)this.inputColors[i]));
        }
    }

    @Override
    public void invalidate() {
    }

    private boolean getEjecting(TransmissionType type) {
        return ((ISideConfiguration)((Object)this.tileEntity)).getConfig().isEjecting(type);
    }
}

