/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import mekanism.common.config.MekanismConfig;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MekSound
implements ISound {
    protected Sound sound;
    protected SoundEventAccessor soundEvent;
    protected ISound.AttenuationType attenuation;
    protected ResourceLocation soundLocation;
    protected float volume;
    protected float pitch;
    protected float x;
    protected float y;
    protected float z;
    protected boolean repeat;
    protected int repeatDelay;

    public MekSound(String sound) {
        this(sound, 0.0f);
    }

    public MekSound(String sound, float volume) {
        this(sound, volume, 0.0f);
    }

    public MekSound(String sound, float volume, float pitch) {
        this(sound, volume, pitch, false, 0);
    }

    public MekSound(String sound, float volume, float pitch, boolean repeat, int repeatDelay) {
        this(sound, volume, pitch, repeat, repeatDelay, 0.0, 0.0, 0.0, ISound.AttenuationType.NONE);
    }

    public MekSound(String sound, float volume, float pitch, double x, double y, double z) {
        this(sound, volume, pitch, false, 0, x, y, z);
    }

    public MekSound(String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public MekSound(String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        this(new ResourceLocation(sound), volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
    }

    public MekSound(ResourceLocation sound) {
        this(sound, 0.0f);
    }

    public MekSound(ResourceLocation sound, float volume) {
        this(sound, volume, 0.0f);
    }

    public MekSound(ResourceLocation sound, float volume, float pitch) {
        this(sound, volume, pitch, false, 0);
    }

    public MekSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay) {
        this(sound, volume, pitch, repeat, repeatDelay, 0.0, 0.0, 0.0, ISound.AttenuationType.NONE);
    }

    public MekSound(ResourceLocation sound, float volume, float pitch, double x, double y, double z) {
        this(sound, volume, pitch, false, 0, x, y, z);
    }

    public MekSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public MekSound(ResourceLocation resource, float v, float p, boolean rep, int delay, double xPos, double yPos, double zPos, ISound.AttenuationType att) {
        this.attenuation = att;
        this.soundLocation = resource;
        this.volume = v;
        this.pitch = p;
        this.x = (float)xPos;
        this.y = (float)yPos;
        this.z = (float)zPos;
        this.repeat = rep;
        this.repeatDelay = delay;
    }

    public MekSound(MekSound other) {
        this.attenuation = other.attenuation;
        this.soundLocation = other.soundLocation;
        this.volume = other.volume;
        this.pitch = other.pitch;
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.repeat = other.repeat;
        this.repeatDelay = other.repeatDelay;
    }

    public ISound.AttenuationType func_147656_j() {
        return this.attenuation;
    }

    public ResourceLocation func_147650_b() {
        return this.soundLocation;
    }

    public float func_147653_e() {
        return (float)((double)this.volume * MekanismConfig.current().client.baseSoundVolume.val());
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public float func_147649_g() {
        return this.x;
    }

    public float func_147654_h() {
        return this.y;
    }

    public float func_147651_i() {
        return this.z;
    }

    public boolean func_147657_c() {
        return this.repeat;
    }

    public int func_147652_d() {
        return this.repeatDelay;
    }

    public SoundEventAccessor func_184366_a(SoundHandler handler) {
        this.soundEvent = handler.func_184398_a(this.soundLocation);
        this.sound = this.soundEvent == null ? SoundHandler.field_147700_a : this.soundEvent.func_148720_g();
        return this.soundEvent;
    }

    public Sound func_184364_b() {
        return this.sound;
    }

    public SoundCategory func_184365_d() {
        return SoundCategory.BLOCKS;
    }
}

