/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.tcomplement.common.TCompNetwork;
import knightminer.tcomplement.library.IHeaterConsumer;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.tanks.FluidHandlerDrainOnlyWrapper;
import knightminer.tcomplement.library.tanks.MelterTank;
import knightminer.tcomplement.melter.client.GuiMelter;
import knightminer.tcomplement.melter.inventory.ContainerMelter;
import knightminer.tcomplement.melter.multiblock.MultiblockMelter;
import knightminer.tcomplement.melter.network.MelterFuelUpdatePacket;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.network.HeatingStructureFuelUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructureFuelTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class TileMelter
extends TileHeatingStructureFuelTank<MultiblockMelter>
implements ITickable,
IInventoryGui,
IHeaterConsumer {
    private int tick;
    private FluidTankAnimated tank;
    private IFluidHandler tankWrapper;
    protected static final int CAPACITY = 2304;

    public TileMelter() {
        super("gui.tcomplement.melter.name", 3, 1);
        this.setMultiblock(new MultiblockMelter(this));
        this.tank = new MelterTank(2304, this);
        this.tankWrapper = new FluidHandlerDrainOnlyWrapper((IFluidHandler)this.tank);
    }

    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public boolean isSolidFuel() {
        return this.hasFuel() && this.currentFuel == null;
    }

    public TileHeater getSolidHeater() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileHeater) {
            return (TileHeater)te;
        }
        return null;
    }

    public void func_73660_a() {
        if (this.isClientWorld()) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick % 20 == 0) {
                this.checkMultiblockStructure();
            }
        } else {
            if (this.tick % 4 == 0) {
                this.heatItems();
            }
            if (this.needsFuel) {
                this.consumeFuel();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    protected void consumeFuel() {
        if (this.hasFuel()) {
            return;
        }
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        this.currentTank = this.field_174879_c.func_177977_b();
        TileEntity te = world.func_175625_s(this.currentTank);
        if (te instanceof TileTank) {
            FluidTankAnimated tank = ((TileTank)te).getInternalTank();
            FluidStack liquid = tank.getFluid();
            if (liquid != null) {
                FluidStack in = liquid.copy();
                int bonusFuel = TinkerRegistry.consumeSmelteryFuel((FluidStack)in);
                int amount = liquid.amount - in.amount;
                FluidStack drained = tank.drain(amount, false);
                if (drained != null && drained.amount == amount) {
                    tank.drain(amount, true);
                    this.currentFuel = drained.copy();
                    this.fuelQuality = bonusFuel;
                    this.addFuel(bonusFuel, drained.getFluid().getTemperature(drained) - 300);
                    if (this.isServerWorld()) {
                        TinkerNetwork.sendToAll((AbstractPacket)new HeatingStructureFuelUpdatePacket(this.field_174879_c, this.currentTank, this.temperature, this.currentFuel));
                    }
                    return;
                }
            }
            this.fuelQuality = 0;
        } else if (te instanceof TileHeater) {
            int time = ((TileHeater)te).consumeFuel();
            if (time > 0) {
                this.currentFuel = null;
                this.fuelQuality = time /= 2;
                this.addFuel(time, 200);
                if (this.isServerWorld()) {
                    TCompNetwork.sendToAll((AbstractPacket)new MelterFuelUpdatePacket(this.field_174879_c, this.temperature));
                }
            } else {
                this.fuelQuality = 0;
            }
        }
    }

    protected void updateStructureInfo(MultiblockDetection.MultiblockStructure structure) {
        if (structure.blocks.size() < 2) {
            return;
        }
        this.tanks.clear();
        BlockPos down = this.field_174879_c.func_177977_b();
        if (this.func_145831_w().func_180495_p(down).func_177230_c() instanceof BlockTank) {
            this.tanks.add(down);
            if (this.isSolidFuel()) {
                this.fuel = 0;
                this.temperature = 0;
                this.needsFuel = true;
            }
        }
        this.resize(3);
    }

    protected int getUpdatedInventorySize(int width, int height, int depth) {
        return 3;
    }

    protected void updateHeatRequired(int index) {
        MeltingRecipe melting;
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b() && (melting = TCompRegistry.getMelting(stack)) != null) {
            this.setHeatRequiredForSlot(index, Math.max(5, melting.getUsableTemperature()));
            if (!this.hasFuel()) {
                this.consumeFuel();
            }
            return;
        }
        this.setHeatRequiredForSlot(index, 0);
    }

    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        MeltingRecipe recipe = TCompRegistry.getMelting(stack);
        if (recipe == null) {
            return false;
        }
        FluidStack fluid = recipe.output.copy();
        FluidStack current = this.getTank().getFluid();
        if (current != null && current.getFluid() != fluid.getFluid()) {
            this.itemTemperatures[slot] = this.itemTempRequired[slot] * 3 + 1;
            return false;
        }
        int filled = this.getTank().fill(fluid.copy(), false);
        if (filled == fluid.amount) {
            this.getTank().fill(fluid, true);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return true;
        }
        this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        this.tank.renderOffset += (float)(this.tank.getFluidAmount() - oldAmount);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerMelter(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiMelter((ContainerMelter)this.createContainer(inventoryplayer, world, pos), this);
    }

    @SideOnly(value=Side.CLIENT)
    public TileHeatingStructureFuelTank.FuelInfo getFuelDisplay() {
        FluidStack fuel;
        IFluidTank tank;
        TileHeatingStructureFuelTank.FuelInfo info = new TileHeatingStructureFuelTank.FuelInfo();
        if (this.hasFuel() && this.currentFuel != null) {
            info.fluid = this.currentFuel.copy();
            info.heat = this.temperature + 300;
            info.maxCap = this.currentFuel.amount;
        }
        if ((tank = this.getTankAt(this.field_174879_c.func_177977_b())) != null && (fuel = tank.getFluid()) != null) {
            if (info.fluid == null) {
                info.fluid = fuel.copy();
                info.heat = info.fluid.getFluid().getTemperature(info.fluid);
                info.maxCap = tank.getCapacity();
            } else if (tank.getFluid().isFluidEqual(info.fluid)) {
                info.fluid.amount += tank.getFluidAmount();
                info.maxCap += tank.getCapacity();
            }
        }
        return info;
    }

    @Override
    public int getFuelQuality() {
        return this.fuelQuality;
    }

    private IFluidTank getTankAt(BlockPos pos) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.getTank().writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getTank().readFromNBT(compound);
    }
}

