/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.match;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.structure.MatchableStructure;
import hellfirepvp.astralsorcery.common.structure.ObservableArea;
import hellfirepvp.astralsorcery.common.structure.ObservableAreaBoundingBox;
import hellfirepvp.astralsorcery.common.structure.StructureMatcher;
import hellfirepvp.astralsorcery.common.structure.StructureRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.BlockStateChangeSet;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class StructureMatcherPatternArray
extends StructureMatcher {
    private PatternBlockArray structure;
    private ObservableArea structureArea;
    private List<BlockPos> mismatches = Lists.newArrayList();

    public StructureMatcherPatternArray(@Nonnull ResourceLocation registryName) {
        super(registryName);
        this.setStructure(registryName);
    }

    private void setStructure(ResourceLocation structName) {
        MatchableStructure struct = StructureRegistry.INSTANCE.getStructure(structName);
        if (!(struct instanceof PatternBlockArray)) {
            throw new IllegalArgumentException("Passed structure matcher key does not have a registered underlying structure pattern: " + structName);
        }
        this.structure = (PatternBlockArray)struct;
        this.structureArea = new ObservableAreaBoundingBox(this.structure.getMin(), this.structure.getMax());
    }

    public void initialize(IBlockAccess world, BlockPos center) {
        for (BlockPos offset : this.structure.getPattern().keySet()) {
            if (this.structure.matchSingleBlock(world, center, offset)) continue;
            this.mismatches.add(offset);
        }
    }

    @Override
    public ObservableArea getObservableArea() {
        return this.structureArea;
    }

    @Override
    public boolean notifyChange(IBlockAccess world, BlockPos centre, BlockStateChangeSet changeSet) {
        for (BlockStateChangeSet.StateChange change : changeSet.getChanges()) {
            if (this.structure.hasBlockAt(change.pos) && !this.structure.matchSingleBlockState(change.pos, change.newState)) {
                if (this.mismatches.contains(change.pos)) continue;
                this.mismatches.add(change.pos);
                continue;
            }
            this.mismatches.remove(change.pos);
        }
        return this.mismatches.size() <= 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.mismatches.clear();
        NBTTagList tagMismatches = tag.func_150295_c("mismatchList", 10);
        for (int i = 0; i < tagMismatches.func_74745_c(); ++i) {
            NBTTagCompound tagPos = tagMismatches.func_150305_b(i);
            this.mismatches.add(NBTHelper.readBlockPosFromNBT(tagPos));
        }
        this.setStructure(new ResourceLocation(tag.func_74779_i("structureToMatch")));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagMismatches = new NBTTagList();
        for (BlockPos pos : this.mismatches) {
            NBTTagCompound tagPos = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(pos, tagPos);
            tagMismatches.func_74742_a((NBTBase)tagPos);
        }
        tag.func_74782_a("mismatchList", (NBTBase)tagMismatches);
        tag.func_74778_a("structureToMatch", this.structure.getRegistryName().toString());
    }
}

