/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.base;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXCrystal;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PtEffectCrystalFootprint
extends PatreonEffectHelper.PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;
    private Color color;

    public PtEffectCrystalFootprint(UUID uniqueId, PatreonEffectHelper.FlareColor chosenColor, UUID playerUUID, Color footprintColor) {
        super(uniqueId, chosenColor);
        this.playerUUID = playerUUID;
        this.color = footprintColor;
    }

    @Override
    public void initialize() {
        super.initialize();
        TickManager.getInstance().register(this);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer player = (EntityPlayer)context[0];
        Side side = (Side)context[1];
        if (side == Side.CLIENT && player != null && player.func_110124_au().equals(this.playerUUID) && player.field_70122_E && player.field_70173_aa % 1 == 0 && rand.nextBoolean()) {
            this.spawnFootprint(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDust(EntityPlayer player) {
        Vector3 pos = Vector3.atEntityCorner((Entity)player).subtract(player.field_70130_N / 2.0f, 0.0, player.field_70130_N / 2.0f).add(player.field_70130_N * rand.nextFloat(), 0.01, player.field_70130_N * rand.nextFloat());
        float scale = rand.nextFloat() * 0.3f + 0.25f;
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(pos);
        p.setColor(this.color).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        p.scale(scale);
        p.gravity(0.004);
        p.setMaxAge(45 + rand.nextInt(30));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFootprint(EntityPlayer player) {
        Vector3 pos = Vector3.atEntityCorner((Entity)player).subtract(player.field_70130_N / 2.0f, 0.1, player.field_70130_N / 2.0f).add(player.field_70130_N * rand.nextFloat(), 0.0, player.field_70130_N * rand.nextFloat());
        EntityFXCrystal crystal = new EntityFXCrystal(pos.getX(), pos.getY(), pos.getZ());
        crystal.rotation(rand.nextFloat() * 25.0f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 25.0f * (float)(rand.nextBoolean() ? 1 : -1), 180.0f + rand.nextFloat() * 25.0f * (float)(rand.nextBoolean() ? 1 : -1));
        crystal.setColor(this.color);
        crystal.setMaxAge(70 + rand.nextInt(40));
        crystal.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        crystal.scale(0.025f + rand.nextFloat() * 0.03f);
        EffectHandler.getInstance().registerFX(crystal);
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Patreon - Crystal footprints " + this.playerUUID.toString();
    }
}

