/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.command;

import com.google.gson.JsonElement;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDDefaultGameType;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDDifficulty;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDGameRule;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDSetWorldSpawn;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDTime;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDWeather;
import fi.dy.masa.justenoughdimensions.command.utils.CommandJEDWorldBorder;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.util.world.DimensionDump;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.StringUtils;

public class CommandJED
extends CommandBase {
    private final Map<ICommandSender, String> commandConfirmations = new HashMap<ICommandSender, String>();

    public String func_71517_b() {
        return "jed";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "jed.commands.usage.generic";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandJED.func_71530_a((String[])args, (String[])new String[]{"debug", "defaultgamemode", "delete-dimension", "difficulty", "dimbuilder", "gamerule", "list-loaded-dimensions", "list-registered-dimensions", "load-dimension", "register", "reload", "reload-main-config", "seed", "setworldspawn", "time", "unload-empty-dimensions", "unregister", "unregister-remove", "weather", "worldborder"});
        }
        if (args.length >= 2) {
            String cmd;
            block27: {
                if (args[0].equals("dimbuilder")) {
                    if (args.length == 2) {
                        return CommandJED.func_71530_a((String[])args, (String[])new String[]{"clear", "create-as", "dimtype", "list", "list-onetime", "read-from", "remove", "remove-onetime", "save-as", "set", "set-onetime"});
                    }
                    return super.func_184883_a(server, sender, args, pos);
                }
                cmd = args[0];
                args = CommandJED.dropFirstStrings(args, 1);
                try {
                    CommandJED.func_175755_a((String)args[0]);
                    if (!cmd.equals("delete-dimension")) {
                        args = CommandJED.dropFirstStrings(args, 1);
                    }
                }
                catch (NumberInvalidException e) {
                    if (sender.func_174793_f() != null) break block27;
                    return super.func_184883_a(server, sender, args, pos);
                }
            }
            if (cmd.equals("weather") && args.length == 1) {
                return CommandJED.func_71530_a((String[])args, (String[])new String[]{"clear", "rain", "thunder"});
            }
            if (cmd.equals("time")) {
                if (args.length == 1) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"add", "set", "query"});
                }
                if (args.length == 2 && args[0].equals("set")) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"day", "night"});
                }
                if (args.length == 2 && args[0].equals("query")) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"day", "daytime", "gametime"});
                }
            } else {
                if (cmd.equals("defaultgamemode") && args.length == 1) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"survival", "creative", "adventure", "spectator"});
                }
                if (cmd.equals("delete-dimension") && args.length == 2) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"confirm"});
                }
                if (cmd.equals("difficulty") && args.length == 1) {
                    return CommandJED.func_71530_a((String[])args, (String[])new String[]{"peaceful", "easy", "normal", "hard"});
                }
                if (cmd.equals("gamerule")) {
                    if (args.length == 1) {
                        return CommandJED.func_71530_a((String[])args, (String[])this.getOverWorldGameRules(server).func_82763_b());
                    }
                    if (args.length == 2 && this.getOverWorldGameRules(server).func_180264_a(args[0], GameRules.ValueType.BOOLEAN_VALUE)) {
                        return CommandJED.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
                    }
                } else {
                    if (cmd.equals("setworldspawn") && args.length == 1) {
                        return CommandJED.func_71530_a((String[])args, (String[])new String[]{"query"});
                    }
                    if (cmd.equals("unload-empty-dimensions") && args.length == 1) {
                        return CommandJED.func_71530_a((String[])args, (String[])new String[]{"unload-chunks"});
                    }
                    if (cmd.equals("worldborder")) {
                        if (args.length == 1) {
                            return CommandJED.func_71530_a((String[])args, (String[])new String[]{"set", "center", "damage", "warning", "add", "get"});
                        }
                        if (args[0].equals("damage") && args.length == 2) {
                            return CommandJED.func_71530_a((String[])args, (String[])new String[]{"buffer", "amount"});
                        }
                        if (args[0].equals("warning") && args.length == 2) {
                            return CommandJED.func_71530_a((String[])args, (String[])new String[]{"time", "distance"});
                        }
                        if (args[0].equals("center") && args.length <= 3) {
                            return CommandJED.func_181043_b((String[])args, (int)1, (BlockPos)pos);
                        }
                    }
                }
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int dimension;
        if (args.length == 0) {
            CommandJED.throwUsage("generic", new Object[0]);
        }
        String cmd = args[0];
        args = CommandJED.dropFirstStrings(args, 1);
        if (cmd.equals("reload")) {
            DimensionConfig.instance().unregisterCustomDimensions();
            DimensionConfig.instance().readDimensionConfig();
            DimensionConfig.instance().registerDimensions();
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.reloaded", (Object[])new Object[0]);
            return;
        }
        if (cmd.equals("reload-main-config")) {
            if (Configs.reloadConfigsFromFile()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.reload_main_config.success", new Object[0]));
                return;
            } else {
                CommandJED.throwCommand("reload_main_config.failure", new Object[0]);
            }
            return;
        }
        if (cmd.equals("list-registered-dimensions")) {
            Integer[] dims = DimensionManager.getStaticDimensionIDs();
            CharSequence[] dimsStr = new String[dims.length];
            for (int i = 0; i < dimsStr.length; ++i) {
                dimsStr[i] = String.valueOf(dims[i]);
            }
            for (String line : DimensionDump.getFormattedRegisteredDimensionsDump()) {
                JustEnoughDimensions.logger.info(line);
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.listdims.list", new Object[]{String.join((CharSequence)", ", dimsStr)}));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.output.printed.to.console.full", new Object[0]));
            return;
        }
        if (cmd.equals("list-loaded-dimensions")) {
            for (String line : DimensionDump.getFormattedLoadedDimensionsDump()) {
                JustEnoughDimensions.logger.info(line);
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.output.printed.to.console", new Object[0]));
            return;
        }
        if (cmd.equals("unload-empty-dimensions")) {
            int count = WorldUtils.unloadEmptyDimensions(args.length == 1 && args[0].equals("unload-chunks"));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.unloaded.dimensions", new Object[]{String.valueOf(count)}));
            return;
        }
        if (cmd.equals("load-dimension")) {
            if (args.length == 1) {
                int dimension2 = CommandJED.func_175755_a((String)args[0]);
                if (server.func_71218_a(dimension2) != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.loaded.dimension", new Object[]{String.valueOf(dimension2)}));
                    return;
                } else {
                    CommandJED.throwCommand("load_dimension_failed", String.valueOf(dimension2));
                }
                return;
            } else {
                CommandJED.throwUsage("load_dimension", new Object[0]);
            }
            return;
        }
        if (cmd.equals("dimbuilder")) {
            this.dimBuilder(args, sender);
            return;
        }
        if (cmd.equals("register")) {
            this.register(args, sender);
            return;
        }
        if (cmd.equals("unregister")) {
            if (args.length != 1) throw new WrongUsageException("/jed unregister <dimension id>", new Object[0]);
            int dimension3 = CommandJED.func_175755_a((String)args[0]);
            if (this.unregister(dimension3)) {
                CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.unregister", (Object[])new Object[]{dimension3});
                return;
            } else {
                CommandJED.throwCommand("dimension.cannotunregisteroverworld", new Object[0]);
            }
            return;
        }
        if (cmd.equals("unregister-remove")) {
            if (args.length != 1) throw new WrongUsageException("/jed unregister-remove <dimension id>", new Object[0]);
            int dimension4 = CommandJED.func_175755_a((String)args[0]);
            this.unregister(dimension4);
            DimensionConfig.instance().removeDimensionAndSaveConfig(dimension4);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.unregister.remove", (Object[])new Object[]{dimension4});
            return;
        }
        if (cmd.equals("delete-dimension")) {
            if (args.length == 1) {
                int dimension5 = CommandJED.func_175755_a((String)args[0]);
                if (dimension5 == 0) {
                    CommandJED.throwCommand("delete_dimension.cant_delete_overworld", new Object[0]);
                }
                String str = cmd + String.join((CharSequence)" ", args);
                this.commandConfirmations.put(sender, str);
                CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.generic.confirmation_command_cached", (Object[])new Object[0]);
                return;
            }
            if (args.length != 2 || !args[1].equals("confirm")) throw new WrongUsageException("/jed delete-dimension <dimension id> [confirm]", new Object[0]);
            int dimension6 = CommandJED.func_175755_a((String)args[0]);
            String cached = this.commandConfirmations.remove(sender);
            if (cached == null || !cached.equals(cmd + args[0])) throw new WrongUsageException("/jed delete-dimension <dimension id> [confirm]", new Object[0]);
            if (WorldUtils.tryDeleteDimension(dimension6, sender)) {
                CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.delete_dimension.success", (Object[])new Object[]{dimension6});
                return;
            }
            CommandJED.throwCommand("delete_dimension.failed", dimension6);
            throw new WrongUsageException("/jed delete-dimension <dimension id> [confirm]", new Object[0]);
        }
        if (cmd.equals("broadcast")) return;
        if (cmd.equals("debug")) {
            Entity ent;
            WorldServer world = null;
            if (args.length == 1) {
                try {
                    int dim = CommandJED.func_175755_a((String)args[0]);
                    world = DimensionManager.getWorld((int)dim);
                }
                catch (Exception dim) {
                    // empty catch block
                }
            }
            if (world == null && (ent = sender.func_174793_f()) != null) {
                world = ent.func_130014_f_();
            }
            if (world == null) return;
            IChunkProvider cp = world.func_72863_F();
            DimensionType dimType = null;
            try {
                dimType = DimensionManager.getProviderType((int)world.field_73011_w.getDimension());
            }
            catch (Exception e) {
                dimType = world.field_73011_w.func_186058_p();
            }
            JustEnoughDimensions.logger.info("============= JED DEBUG START ==========");
            JustEnoughDimensions.logger.info("DIM: {}", (Object)world.field_73011_w.getDimension());
            String clazzName = "?";
            try {
                Class clazz = (Class)ReflectionHelper.getPrivateValue(DimensionType.class, (Object)dimType, (String[])new String[]{"field_186077_g", "clazz"});
                clazzName = clazz.getName();
            }
            catch (Exception clazz) {
                // empty catch block
            }
            JustEnoughDimensions.logger.info(String.format("DimensionType: ID: %d, name: '%s', suffix: '%s', shouldLoadSpawn: %s, WorldProvider class: '%s'", dimType.func_186068_a(), dimType.func_186065_b(), dimType.func_186067_c(), dimType.shouldLoadSpawn(), clazzName));
            JustEnoughDimensions.logger.info("DimensionType.toString(): {}", (Object)dimType.toString());
            JustEnoughDimensions.logger.info("Seed: {}", (Object)world.func_72912_H().func_76063_b());
            JustEnoughDimensions.logger.info("getSpawnPoint(): {}", (Object)world.func_175694_M());
            JustEnoughDimensions.logger.info("getSpawnCoordinate(): {}", (Object)world.field_73011_w.func_177496_h());
            JustEnoughDimensions.logger.info("World class: {}", (Object)world.getClass().getName());
            WorldType type = world.func_72912_H().func_76067_t();
            JustEnoughDimensions.logger.info("WorldType: '{}' (class: {})", (Object)type.func_77127_a(), (Object)type.getClass().getName());
            JustEnoughDimensions.logger.info("WorldInfo class: '{}'", (Object)world.func_72912_H().getClass().getName());
            JustEnoughDimensions.logger.info("WorldProvider: {}", (Object)world.field_73011_w.getClass().getName());
            JustEnoughDimensions.logger.info("ChunkProvider: {}", (Object)cp.getClass().getName());
            JustEnoughDimensions.logger.info("ChunkProviderServer.chunkGenerator: {}", (Object)(cp instanceof ChunkProviderServer ? ((ChunkProviderServer)cp).field_186029_c.getClass().getName() : "null"));
            JustEnoughDimensions.logger.info("BiomeProvider: {}", (Object)world.func_72959_q().getClass().getName());
            JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists((World)world);
            if (props != null) {
                JustEnoughDimensions.logger.info("Dimension has JED properties");
                String str = JEDJsonUtils.serialize((JsonElement)props.getFullJEDProperties());
                JustEnoughDimensions.logger.info("JED properties tag: {}", (Object)str);
            } else {
                JustEnoughDimensions.logger.info("Dimension doesn't have JED properties");
            }
            NBTTagCompound tag = world.func_72912_H().func_76082_a(new NBTTagCompound());
            JustEnoughDimensions.logger.info("Vanilla level NBT: {}", (Object)tag.toString());
            JustEnoughDimensions.logger.info("============= JED DEBUG END ==========");
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.output.printed.to.console", new Object[0]));
            return;
        }
        Entity entity = sender.func_174793_f();
        boolean dimensionKnown = entity != null;
        int n = dimension = entity != null ? entity.func_130014_f_().field_73011_w.getDimension() : 0;
        if (args.length >= 1) {
            try {
                dimension = CommandJED.func_175755_a((String)args[0]);
                args = CommandJED.dropFirstStrings(args, 1);
                dimensionKnown = true;
            }
            catch (NumberInvalidException numberInvalidException) {
                // empty catch block
            }
        }
        if (!dimensionKnown) {
            CommandJED.throwUsage("generic", new Object[0]);
        }
        if (cmd.equals("defaultgamemode")) {
            CommandJEDDefaultGameType.execute(this, dimension, args, server, sender);
            return;
        } else if (cmd.equals("difficulty")) {
            CommandJEDDifficulty.execute(this, dimension, args, sender);
            return;
        } else if (cmd.equals("gamerule")) {
            CommandJEDGameRule.execute(this, dimension, args, server, sender);
            return;
        } else if (cmd.equals("seed")) {
            this.commandSeed(dimension, sender);
            return;
        } else if (cmd.equals("setworldspawn")) {
            CommandJEDSetWorldSpawn.execute(this, dimension, args, sender);
            return;
        } else if (cmd.equals("time")) {
            CommandJEDTime.execute(this, dimension, args, sender);
            return;
        } else if (cmd.equals("weather")) {
            CommandJEDWeather.execute(this, dimension, args, sender);
            return;
        } else if (cmd.equals("worldborder")) {
            CommandJEDWorldBorder.execute(this, dimension, args, server, sender);
            return;
        } else {
            CommandJED.throwUsage("generic", new Object[0]);
        }
    }

    private void commandSeed(int dimension, ICommandSender sender) throws CommandException {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            CommandJED.throwNumber("dimension.notloaded", dimension);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.seed.success", new Object[]{(long)dimension, world.func_72912_H().func_76063_b()}));
    }

    private GameRules getOverWorldGameRules(MinecraftServer server) {
        return server.func_71218_a(0).func_82736_K();
    }

    private void register(String[] args, ICommandSender sender) throws CommandException {
        if (args.length == 1) {
            int dimension = CommandJED.func_175755_a((String)args[0]);
            String str = DimensionConfig.instance().registerDimensionFromConfig(dimension);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.register.from.config", (Object[])new Object[]{dimension, str});
        } else if (args.length == 2 && args[1].equals("create")) {
            int dimension = CommandJED.func_175755_a((String)args[0]);
            String str = DimensionConfig.instance().registerNewDimension(dimension);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.register.create.simple", (Object[])new Object[]{dimension, str});
        } else if (args.length == 5 || args.length == 6) {
            int dimension = CommandJED.func_175755_a((String)args[0]);
            boolean keepLoaded = Boolean.parseBoolean(args[3]);
            boolean override = args.length == 6 ? Boolean.parseBoolean(args[5]) : false;
            String str = DimensionConfig.instance().registerNewDimension(dimension, args[1], args[2], keepLoaded, args[4], override);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.register.custom", (Object[])new Object[]{dimension, str});
        } else {
            CommandJED.throwUsage("register", new Object[0]);
        }
    }

    private boolean unregister(int dimension) throws CommandException {
        if (DimensionManager.isDimensionRegistered((int)dimension)) {
            if (DimensionManager.getWorld((int)dimension) == null) {
                if (dimension != 0) {
                    DimensionManager.unregisterDimension((int)dimension);
                    return true;
                }
            } else {
                CommandJED.throwNumber("dimension.loaded", dimension);
            }
        } else {
            CommandJED.throwNumber("dimension.notregistered", dimension);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dimBuilder(String[] args, ICommandSender sender) throws CommandException {
        if (args.length < 1) {
            this.dimBuilderPrintHelp(sender);
            return;
        } else if (args[0].equals("dimtype")) {
            if (args.length != 6) throw new WrongUsageException("/jed dimbuilder dimtype <DimensionType id> <name> <suffix> <keeploaded true/false> <worldprovidername>", new Object[0]);
            DimensionConfig.instance().dimbuilderDimtype(CommandJED.func_175755_a((String)args[1]), args[2], args[3], args[4], args[5]);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.dimtype.success", (Object[])new Object[0]);
            return;
        } else if (args[0].equals("clear")) {
            if (args.length != 1) throw new WrongUsageException("/jed dimbuilder clear", new Object[0]);
            DimensionConfig.instance().dimbuilderClear();
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.clear.success", (Object[])new Object[0]);
            return;
        } else if (args[0].equals("set") || args[0].equals("set-onetime")) {
            if (args.length < 3) throw new WrongUsageException("/jed dimbuilder <set | set-onetime> <key> <value>", new Object[0]);
            DimensionConfig.WorldInfoType type = args[0].equals("set-onetime") ? DimensionConfig.WorldInfoType.ONE_TIME : DimensionConfig.WorldInfoType.REGULAR;
            CharSequence[] valueParts = CommandJED.dropFirstStrings(args, 2);
            String value = String.join((CharSequence)" ", valueParts);
            DimensionConfig.instance().dimbuilderSet(args[1], value, type);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.set.success", (Object[])new Object[]{args[1], value});
            return;
        } else if (args[0].equals("remove") || args[0].equals("remove-onetime")) {
            if (args.length < 2) throw new WrongUsageException("/jed dimbuilder <remove | remove-onetime> <key> [key] ...", new Object[0]);
            DimensionConfig.WorldInfoType type = args[0].equals("remove-onetime") ? DimensionConfig.WorldInfoType.ONE_TIME : DimensionConfig.WorldInfoType.REGULAR;
            for (int i = 1; i < args.length; ++i) {
                if (DimensionConfig.instance().dimbuilderRemove(args[i], type)) {
                    CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.remove.success", (Object[])new Object[]{args[i]});
                    continue;
                }
                CommandJED.throwCommand("dimbuilder.remove.fail", args[i]);
            }
            return;
        } else if (args[0].equals("list") || args[0].equals("list-onetime")) {
            DimensionConfig.WorldInfoType type;
            DimensionConfig.WorldInfoType worldInfoType = type = args[0].equals("list-onetime") ? DimensionConfig.WorldInfoType.ONE_TIME : DimensionConfig.WorldInfoType.REGULAR;
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    DimensionConfig.instance().dimbuilderList(args[i], type, sender);
                }
                return;
            } else {
                DimensionConfig.instance().dimbuilderList(null, type, sender);
            }
            return;
        } else if (args[0].equals("read-from")) {
            if (args.length != 2) throw new WrongUsageException("/jed dimbuilder read-from <dimension id>", new Object[0]);
            int dimension = CommandJED.func_175755_a((String)args[1]);
            if (DimensionConfig.instance().dimbuilderReadFrom(dimension)) {
                CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.read.from.success", (Object[])new Object[]{dimension});
                return;
            } else {
                CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.read.from.fail", (Object[])new Object[]{dimension});
            }
            return;
        } else if (args[0].equals("save-as")) {
            if (args.length != 2) throw new WrongUsageException("/jed dimbuilder save-as <dimension id>", new Object[0]);
            int dimension = CommandJED.func_175755_a((String)args[1]);
            DimensionConfig.instance().dimbuilderSaveAs(dimension);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.save.as.success", (Object[])new Object[]{dimension});
            return;
        } else if (args[0].equals("create-as")) {
            if (args.length != 2) throw new WrongUsageException("/jed dimbuilder create-as <dimension id>", new Object[0]);
            int dimension = CommandJED.func_175755_a((String)args[1]);
            DimensionConfig.instance().dimbuilderCreateAs(dimension);
            CommandJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.dimbuilder.create.as.success", (Object[])new Object[]{dimension});
            return;
        } else {
            this.dimBuilderPrintHelp(sender);
        }
    }

    private void dimBuilderPrintHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder clear"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder create-as <dim id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder dimtype <DimensionType ID> <name> <suffix> <keeploaded> <worldprovider>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder <list | list-onetime> [key1] [key2] ..."));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder <remove | remove-onetime> <key>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder read-from <dim id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder save-as <dim id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/jed dimbuilder <set | set-onetime> <key> <value which can have spaces>"));
    }

    public static String[] dropFirstStrings(String[] input, int toDrop) {
        if (toDrop > input.length) {
            return new String[0];
        }
        String[] arr = new String[input.length - toDrop];
        System.arraycopy(input, toDrop, arr, 0, input.length - toDrop);
        return arr;
    }

    public static void throwUsage(String type, Object ... params) throws CommandException {
        throw new WrongUsageException("jed.commands.usage." + type, params);
    }

    public static void throwNumber(String type, Object ... params) throws CommandException {
        throw new NumberInvalidException("jed.commands.error." + type, params);
    }

    public static void throwCommand(String type, Object ... params) throws CommandException {
        throw new CommandException("jed.commands.error." + type, params);
    }

    public static void runBroadcastCommand(ICommandSender sender, String commandType, Object ... args) {
        String fullCommand = "jed broadcast " + commandType + " " + StringUtils.join((Object[])args, (char)' ');
        try {
            JustEnoughDimensions.logInfo("Running a broadcast command '{}'", fullCommand);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D().func_71556_a(sender, fullCommand);
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Exception while executing a broadcast command '{}'", (Object)fullCommand, (Object)e);
        }
    }
}

