/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.RegionCacheInfo;
import xaero.map.region.MapTileChunk;

public class MapRegion
implements Comparable<MapRegion>,
RegionCacheInfo {
    public static final int SIDE_LENGTH = 8;
    private Boolean saveExists;
    private File loadedFromFile;
    private boolean beingWritten;
    private long lastSaveTime = System.currentTimeMillis();
    private byte loadState;
    private int version = -1;
    private int initialVersion;
    private String world;
    private String dim;
    private MapTileChunk[][] chunks = new MapTileChunk[8][8];
    private int regionX;
    private int regionZ;
    private boolean shouldCache;
    private boolean isRefreshing;
    private boolean allCachePrepared;
    private File cacheFile = null;
    public final Object writerThreadPauseSync = new Object();
    private int pauseWriting;
    private boolean recacheHasBeenRequested;
    private boolean reloadHasBeenRequested;
    private boolean waitingForRegionBelow;
    private static int comparisonX = 0;
    private static int comparisonZ = 0;
    private int[] redBuffer = new int[4];
    private int[] greenBuffer = new int[4];
    private int[] blueBuffer = new int[4];
    private float[] brightnessBuffer = new float[4];
    private float[] postBrightnessBuffer = new float[4];
    private BlockPos.MutableBlockPos mutableGlobalPos = new BlockPos.MutableBlockPos();

    public MapRegion(String world, String dim, int x, int z) {
        this.world = world;
        this.regionX = x;
        this.regionZ = z;
        this.dim = dim;
        this.initialVersion = MapProcessor.instance.getGlobalVersion();
    }

    public void destroyBufferUpdateObjects() {
        this.redBuffer = null;
        this.greenBuffer = null;
        this.blueBuffer = null;
        this.brightnessBuffer = null;
        this.postBrightnessBuffer = null;
        this.mutableGlobalPos = null;
    }

    public void restoreBufferUpdateObjects() {
        this.redBuffer = new int[4];
        this.greenBuffer = new int[4];
        this.blueBuffer = new int[4];
        this.brightnessBuffer = new float[4];
        this.postBrightnessBuffer = new float[4];
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
    }

    public void requestRefresh() {
        if (!this.isRefreshing) {
            this.isRefreshing = true;
            MapProcessor.instance.addToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Requesting refresh for region %s.", this));
            }
        }
    }

    public void cancelRefresh() {
        if (this.isRefreshing) {
            this.isRefreshing = false;
            MapProcessor.instance.removeToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Canceling refresh for region %s.", this));
            }
        }
    }

    public static void setComparison(EntityPlayer player) {
        MapRegion.setComparison((int)Math.floor(player.field_70165_t) >> 9, (int)Math.floor(player.field_70161_v) >> 9);
    }

    public static void setComparison(int x, int z) {
        comparisonX = x;
        comparisonZ = z;
    }

    @Override
    public int compareTo(MapRegion arg0) {
        int toRegion2;
        if (this.loadState < arg0.loadState) {
            return -1;
        }
        if (this.loadState > arg0.loadState) {
            return 1;
        }
        if (this.shouldCache && !arg0.shouldCache) {
            return 1;
        }
        if (arg0.shouldCache && !this.shouldCache) {
            return -1;
        }
        int toRegion = this.distanceFromPlayer();
        if (toRegion > (toRegion2 = arg0.distanceFromPlayer())) {
            return 1;
        }
        if (toRegion == toRegion2) {
            return 0;
        }
        return -1;
    }

    public int distanceFromPlayer() {
        int toRegionX = this.regionX - comparisonX;
        int toRegionZ = this.regionZ - comparisonZ;
        return (int)Math.sqrt(toRegionX * toRegionX + toRegionZ * toRegionZ);
    }

    public void deleteTexturesAndBuffers() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                for (int t = 0; t < c.getGlTextures().length; ++t) {
                    if (c.getGlTexture(t) != -1) {
                        MapProcessor.instance.requestTextureDeletion(c.getGlTexture(t));
                    }
                    if (c.getBuffer(t) == null) continue;
                    c.deleteBuffer(t);
                }
                c.deletePBOs();
            }
        }
    }

    public void deleteGLBuffers() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                c.deletePBOs();
            }
        }
    }

    public void clean() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                c.clean();
                this.chunks[i][j] = null;
            }
        }
    }

    public void saveCacheTextures(File outputFile) throws IOException {
        if (WorldMap.settings.debug) {
            System.out.println("Saving cache: " + this.regionX + "_" + this.regionZ);
        }
        ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        DataOutputStream output = new DataOutputStream(zipOutput);
        ZipEntry e = new ZipEntry("cache.xaero");
        zipOutput.putNextEntry(e);
        byte[] usableBuffer = new byte[16384];
        byte[] integerByteBuffer = new byte[4];
        output.writeInt(2);
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk chunk = this.chunks[i][j];
                if (chunk == null) continue;
                if (!chunk.isCachePrepared()) {
                    throw new RuntimeException("Trying to save cache but " + chunk.getX() + " " + chunk.getZ() + " is not prepared.");
                }
                output.write(i << 4 | j);
                chunk.writeCacheData(output, usableBuffer, integerByteBuffer);
            }
        }
        zipOutput.closeEntry();
        output.close();
    }

    public void loadCacheTextures(int levelsToBuffer) throws IOException {
        if (this.cacheFile == null) {
            return;
        }
        if (this.cacheFile.exists()) {
            ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
            DataInputStream input = new DataInputStream(zipInput);
            ZipEntry entry = zipInput.getNextEntry();
            if (entry != null) {
                byte[] integerByteBuffer = new byte[4];
                int cacheSaveVersion = input.readInt();
                if (cacheSaveVersion > 2) {
                    input.close();
                    System.out.println("Trying to load newer region cache " + this.regionX + "_" + this.regionZ + " using an older version of Xaero's World Map!");
                    MapProcessor.instance.getMapSaveLoad().backupFile(this.cacheFile, cacheSaveVersion);
                    this.cacheFile = null;
                    this.shouldCache = true;
                    return;
                }
                byte[] usableBuffer = new byte[16384];
                int chunkCoords = input.read();
                while (chunkCoords != -1) {
                    int x = chunkCoords >> 4;
                    int z = chunkCoords & 0xF;
                    MapTileChunk chunk = this.chunks[x][z];
                    if (chunk == null) {
                        this.chunks[x][z] = chunk = new MapTileChunk(this, this.regionX * 8 + x, this.regionZ * 8 + z);
                    }
                    chunk.readCacheData(cacheSaveVersion, input, usableBuffer, integerByteBuffer, levelsToBuffer);
                    chunkCoords = input.read();
                }
                zipInput.closeEntry();
            }
            input.close();
        } else {
            this.cacheFile = null;
            this.shouldCache = true;
        }
    }

    public boolean isResting() {
        return this.loadState != 3 && this.loadState != 1 && !this.recacheHasBeenRequested;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public void setShouldCache(boolean shouldCache, String by) {
        this.shouldCache = shouldCache;
        if (WorldMap.settings.detailed_debug) {
            System.out.println("shouldCache set to " + shouldCache + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
    }

    @Override
    public File getCacheFile() {
        return this.cacheFile;
    }

    @Override
    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public int getRegionX() {
        return this.regionX;
    }

    @Override
    public int getRegionZ() {
        return this.regionZ;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        if (WorldMap.settings.detailed_debug) {
            System.out.println("Version set to " + version + " by for " + this);
        }
    }

    public boolean isBeingWritten() {
        return this.beingWritten;
    }

    public void setBeingWritten(boolean beingWritten) {
        this.beingWritten = beingWritten;
    }

    public byte getLoadState() {
        return this.loadState;
    }

    public void setLoadState(byte loadState) {
        this.loadState = loadState;
    }

    public MapTileChunk getChunk(int x, int z) {
        return this.chunks[x][z];
    }

    public void setChunk(int x, int z, MapTileChunk chunk) {
        this.chunks[x][z] = chunk;
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    public String getDim() {
        return this.dim;
    }

    public int[] getRedBuffer() {
        return this.redBuffer;
    }

    public int[] getGreenBuffer() {
        return this.greenBuffer;
    }

    public int[] getBlueBuffer() {
        return this.blueBuffer;
    }

    public float[] getBrightnessBuffer() {
        return this.brightnessBuffer;
    }

    public float[] getPostBrightnessBuffer() {
        return this.postBrightnessBuffer;
    }

    public BlockPos.MutableBlockPos getMutableGlobalPos() {
        return this.mutableGlobalPos;
    }

    public File getLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(File loadedFromFile) {
        this.loadedFromFile = loadedFromFile;
    }

    public Boolean getSaveExists() {
        return this.saveExists;
    }

    public void setSaveExists(Boolean saveExists) {
        this.saveExists = saveExists;
    }

    public long getLastSaveTime() {
        return this.lastSaveTime;
    }

    public void setLastSaveTime(long lastSaveTime) {
        this.lastSaveTime = lastSaveTime;
    }

    public boolean isAllCachePrepared() {
        return this.allCachePrepared;
    }

    public void setAllCachePrepared(boolean allCachePrepared) {
        if (this.allCachePrepared && !allCachePrepared && WorldMap.settings.detailed_debug) {
            System.out.println("Cancelling cache: " + this.getRegionX() + "_" + this.getRegionZ() + " " + this.getLoadState());
        }
        this.allCachePrepared = allCachePrepared;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void setRefreshing(boolean isRefreshing) {
        this.isRefreshing = isRefreshing;
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    public boolean recacheHasBeenRequested() {
        return this.recacheHasBeenRequested;
    }

    public void setRecacheHasBeenRequested(boolean recacheHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && recacheHasBeenRequested != this.recacheHasBeenRequested) {
            System.out.println("Recache set to " + recacheHasBeenRequested + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
        this.recacheHasBeenRequested = recacheHasBeenRequested;
    }

    public String toString() {
        return this.regionX + "_" + this.regionZ + " " + super.toString();
    }

    public boolean hasVersion() {
        return this.version != -1;
    }

    public boolean isWaitingForRegionBelow() {
        return this.waitingForRegionBelow;
    }

    public void setWaitingForRegionBelow(boolean waitingForRegionBelow) {
        this.waitingForRegionBelow = waitingForRegionBelow;
    }

    public boolean reloadHasBeenRequested() {
        return this.reloadHasBeenRequested;
    }

    public void setReloadHasBeenRequested(boolean reloadHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && reloadHasBeenRequested != this.reloadHasBeenRequested) {
            System.out.println("Reload set to " + reloadHasBeenRequested + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
        this.reloadHasBeenRequested = reloadHasBeenRequested;
    }
}

