/*
 * Decompiled with CFR 0.152.
 */
package xaero.deallocator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ByteBufferDeallocator {
    private final String directBufferClassName = "java.nio.DirectByteBuffer";
    private final Method directBufferCleanerMethod;
    private final Method cleanerCleanMethod;

    public ByteBufferDeallocator() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
        this.directBufferCleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
        Class<?> cleanerClass = this.directBufferCleanerMethod.getReturnType();
        this.cleanerCleanMethod = Runnable.class.isAssignableFrom(cleanerClass) ? Runnable.class.getDeclaredMethod("run", new Class[0]) : cleanerClass.getDeclaredMethod("clean", new Class[0]);
    }

    public synchronized void deallocate(ByteBuffer buffer, boolean debug) {
        if (buffer == null || !buffer.isDirect()) {
            return;
        }
        boolean cleanerAccessibleBU = this.directBufferCleanerMethod.isAccessible();
        boolean cleanAccessibleBU = this.cleanerCleanMethod.isAccessible();
        try {
            this.directBufferCleanerMethod.setAccessible(true);
            Object cleaner = this.directBufferCleanerMethod.invoke((Object)buffer, new Object[0]);
            if (cleaner != null) {
                this.cleanerCleanMethod.setAccessible(true);
                this.cleanerCleanMethod.invoke(cleaner, new Object[0]);
            } else if (debug) {
                System.out.println("No cleaner to deallocate a buffer!");
            }
        }
        catch (IllegalAccessException e) {
            this.reportException(e);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
        }
        catch (InvocationTargetException e) {
            this.reportException(e);
        }
        this.directBufferCleanerMethod.setAccessible(cleanerAccessibleBU);
        this.cleanerCleanMethod.setAccessible(cleanAccessibleBU);
    }

    private void reportException(Exception e) {
        System.out.println("Failed to deallocate a direct byte buffer: ");
        e.printStackTrace();
    }
}

