/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.ParticlePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemHeartUpgrade
extends ItemCyberware {
    private static Map<UUID, Integer> timesPlatelets = new HashMap<UUID, Integer>();
    private static Map<UUID, Boolean> isPlateletWorking = new HashMap<UUID, Boolean>();
    private static Map<UUID, Boolean> isStemWorking = new HashMap<UUID, Boolean>();
    private static Map<UUID, Integer> timesMedkit = new HashMap<UUID, Integer>();
    private static Map<UUID, Float> damageMedkit = new HashMap<UUID, Float>();

    public ItemHeartUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == CyberwareContent.cyberheart && (stack.func_77952_i() == 0 || stack.func_77952_i() == 3);
    }

    @SubscribeEvent
    public void handleDeath(LivingDeathEvent event) {
        ItemStack test;
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test = new ItemStack((Item)this, 1, 0)) && !event.isCanceled()) {
            ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)e);
            ItemStack stack = CyberwareAPI.getCyberware((Entity)e, test);
            if (!CyberwareAPI.getCyberwareNBT(stack).func_74764_b("used") && cyberware.usePower(test, this.getPowerConsumption(test), false)) {
                NonNullList<ItemStack> items = cyberware.getInstalledCyberware(ICyberware.EnumSlot.HEART);
                NonNullList itemsNew = NonNullList.func_191196_a();
                itemsNew.addAll(items);
                for (int i = 0; i < items.size(); ++i) {
                    ItemStack item = (ItemStack)items.get(i);
                    if (item.func_190926_b() || item.func_77973_b() != this || item.func_77952_i() != 0) continue;
                    itemsNew.set(i, (Object)ItemStack.field_190927_a);
                    break;
                }
                if (e instanceof EntityPlayer) {
                    cyberware.setInstalledCyberware(e, ICyberware.EnumSlot.HEART, (NonNullList<ItemStack>)itemsNew);
                    cyberware.updateCapacity();
                    if (!e.field_70170_p.field_72995_K) {
                        CyberwareAPI.updateData((Entity)e);
                    }
                } else {
                    stack = CyberwareAPI.getCyberware((Entity)e, test);
                    NBTTagCompound com = CyberwareAPI.getCyberwareNBT(stack);
                    com.func_74757_a("used", true);
                    stack.func_77978_p().func_74782_a("cyberwareFunctionData", (NBTBase)com);
                    CyberwareAPI.updateData((Entity)e);
                }
                e.func_70606_j(e.func_110138_aP() / 3.0f);
                CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new ParticlePacket(1, (float)e.field_70165_t, (float)e.field_70163_u + e.field_70131_O / 2.0f, (float)e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_70170_p.field_73011_w.getDimension(), e.field_70165_t, e.field_70163_u, e.field_70161_v, 20.0));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        int t;
        EntityLivingBase e = event.getEntityLiving();
        ItemStack test = new ItemStack((Item)this, 1, 2);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            isStemWorking.put(e.func_110124_au(), CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)));
        }
        test = new ItemStack((Item)this, 1, 1);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            isPlateletWorking.put(e.func_110124_au(), CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)));
        }
        if (e != null && this.isPlateletWorking(e) && CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            if (e.func_110143_aJ() >= e.func_110138_aP() * 0.8f && e.func_110143_aJ() != e.func_110138_aP()) {
                t = this.getPlateletTime(e);
                if (t >= 40) {
                    timesPlatelets.put(e.func_110124_au(), e.field_70173_aa);
                    e.func_70691_i(1.0f);
                }
            } else {
                timesPlatelets.put(e.func_110124_au(), e.field_70173_aa);
            }
        } else if (timesPlatelets.containsKey(e.func_110124_au())) {
            timesPlatelets.remove(e.func_110124_au());
        }
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 2))) {
            if (this.isStemWorking(e) && (t = this.getMedkitTime(e)) >= 100 && damageMedkit.get(e.func_110124_au()).floatValue() > 0.0f) {
                CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new ParticlePacket(0, (float)e.field_70165_t, (float)e.field_70163_u + e.field_70131_O / 2.0f, (float)e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_70170_p.field_73011_w.getDimension(), e.field_70165_t, e.field_70163_u, e.field_70161_v, 20.0));
                e.func_70691_i(damageMedkit.get(e.func_110124_au()).floatValue());
                timesMedkit.put(e.func_110124_au(), 0);
                damageMedkit.put(e.func_110124_au(), Float.valueOf(0.0f));
            }
        } else if (timesMedkit.containsKey(e.func_145782_y())) {
            // empty if block
        }
    }

    private boolean isPlateletWorking(EntityLivingBase e) {
        if (!isPlateletWorking.containsKey(e.func_110124_au())) {
            isPlateletWorking.put(e.func_110124_au(), false);
            return false;
        }
        return isPlateletWorking.get(e.func_110124_au());
    }

    private boolean isStemWorking(EntityLivingBase e) {
        if (!isStemWorking.containsKey(e.func_110124_au())) {
            isStemWorking.put(e.func_110124_au(), false);
            return false;
        }
        return isStemWorking.get(e.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleHurt(LivingHurtEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (!event.isCanceled() && CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 2))) {
            float damageAmount = event.getAmount();
            DamageSource damageSrc = event.getSource();
            damageAmount = this.applyArmorCalculations(e, damageSrc, damageAmount);
            damageAmount = this.applyPotionDamageCalculations(e, damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - e.func_110139_bj(), 0.0f);
            damageMedkit.put(e.func_110124_au(), Float.valueOf(damageAmount));
            timesMedkit.put(e.func_110124_au(), e.field_70173_aa);
        }
    }

    protected float applyArmorCalculations(EntityLivingBase e, DamageSource source, float damage) {
        if (!source.func_76363_c()) {
            damage = CombatRules.func_189427_a((float)damage, (float)e.func_70658_aO(), (float)((float)e.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        return damage;
    }

    protected float applyPotionDamageCalculations(EntityLivingBase e, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (e.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (e.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)e.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    private int getPlateletTime(EntityLivingBase e) {
        if (e != null) {
            if (!timesPlatelets.containsKey(e.func_110124_au())) {
                timesPlatelets.put(e.func_110124_au(), e.field_70173_aa);
                return 0;
            }
            return e.field_70173_aa - timesPlatelets.get(e.func_110124_au());
        }
        return 0;
    }

    private int getMedkitTime(EntityLivingBase e) {
        if (e != null) {
            if (!timesMedkit.containsKey(e.func_110124_au())) {
                timesMedkit.put(e.func_110124_au(), e.field_70173_aa);
                damageMedkit.put(e.func_110124_au(), Float.valueOf(0.0f));
                return 0;
            }
            return e.field_70173_aa - timesMedkit.get(e.func_110124_au());
        }
        return 0;
    }

    @SubscribeEvent
    public void power(CyberwareUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack test = new ItemStack((Item)this, 1, 3);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            CyberwareAPI.getCapability((Entity)e).addPower(this.getPowerProduction(test), test);
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 500 : (stack.func_77952_i() == 1 ? 3 : (stack.func_77952_i() == 2 ? 7 : 0));
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 500 : 0;
    }

    @Override
    public boolean hasCustomPowerMessage(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    @Override
    public int getPowerProduction(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 6 : 0;
    }
}

