/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.item;

import net.minecraft.block.SoundType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import reborncore.mcmultipart.item.IItemMultipartFactory;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.multipart.MultipartHelper;

public abstract class ItemMultiPart
extends Item
implements IItemMultipartFactory {
    @Override
    public abstract IMultipart createPart(World var1, BlockPos var2, EnumFacing var3, Vec3d var4, ItemStack var5, EntityPlayer var6);

    public boolean place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        IMultipart part = this.createPart(world, pos, side, hit, stack, player);
        if (part != null && MultipartHelper.canAddPart(world, pos, part)) {
            if (!world.field_72995_K) {
                MultipartHelper.addPart(world, pos, part);
            }
            this.consumeItem(stack);
            SoundType sound = this.getPlacementSound(stack);
            if (sound != null) {
                world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, sound.func_185843_a(), sound.func_185847_b());
            }
            return true;
        }
        return false;
    }

    protected void consumeItem(ItemStack stack) {
        --stack.field_77994_a;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Vec3d hit = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        double depth = (hit.field_72450_a * 2.0 - 1.0) * (double)side.func_82601_c() + (hit.field_72448_b * 2.0 - 1.0) * (double)side.func_96559_d() + (hit.field_72449_c * 2.0 - 1.0) * (double)side.func_82599_e();
        if (depth < 1.0 && this.place(world, pos, side, hit, stack, player)) {
            return EnumActionResult.SUCCESS;
        }
        if (this.place(world, pos.func_177972_a(side), side.func_176734_d(), hit, stack, player)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public SoundType getPlacementSound(ItemStack stack) {
        return SoundType.field_185853_f;
    }

    public boolean func_82788_x() {
        return true;
    }
}

