/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.block;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.mcmultipart.capabilities.ISlottedCapabilityProvider;
import reborncore.mcmultipart.capabilities.MultipartCapabilityHelper;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.microblock.IMicroblockContainerTile;
import reborncore.mcmultipart.microblock.MicroblockContainer;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.multipart.PartSlot;

public class TileCoverable
extends TileEntity
implements IMicroblockContainerTile,
ISlottedCapabilityProvider {
    private MicroblockContainer container;

    @Override
    public World getWorldIn() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPosIn() {
        return this.func_174877_v();
    }

    @Override
    public MicroblockContainer getMicroblockContainer() {
        return this.container != null ? this.container : (this.container = new MicroblockContainer(this));
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return true;
    }

    @Override
    public void onMicroblocksChanged() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return MultipartCapabilityHelper.hasCapability(this.container, capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object impl = super.getCapability(capability, facing);
        if (impl != null) {
            return (T)impl;
        }
        return MultipartCapabilityHelper.getCapability(this.container, capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        return this.container.hasCapability(capability, slot, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        return this.container.getCapability(capability, slot, facing);
    }

    public void onLoad() {
        super.onLoad();
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            iMultipart.onLoaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            iMultipart.onUnloaded();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.getMicroblockContainer().getPartContainer().writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getMicroblockContainer().getPartContainer().readFromNBT(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.getMicroblockContainer().getPartContainer().writeToNBT(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = super.getRenderBoundingBox().func_72317_d((double)(-this.getPosIn().func_177958_n()), (double)(-this.getPosIn().func_177956_o()), (double)(-this.getPosIn().func_177952_p()));
        for (IMultipart iMultipart : this.getMicroblockContainer().getParts()) {
            AxisAlignedBB bb = iMultipart.getRenderBoundingBox();
            if (bb == null) continue;
            bounds = bounds.func_111270_a(bb);
        }
        return bounds.func_72317_d((double)this.getPosIn().func_177958_n(), (double)this.getPosIn().func_177956_o(), (double)this.getPosIn().func_177952_p());
    }
}

