/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.RebornCore;

public class OreUtil {
    public static ArrayList<String> oreNames = new ArrayList();

    public static boolean doesOreExistAndValid(String name) {
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static ItemStack getStackFromName(String name) {
        return OreUtil.getStackFromName(name, 1);
    }

    public static ItemStack getStackFromName(String name, int stackSize) {
        ItemStack stack = ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77946_l();
        stack.field_77994_a = stackSize;
        return stack;
    }

    public static void scanForOres() {
        String[] validPrefixes = new String[]{"ingot", "ore", "crushed", "plate", "nugget", "dustSmall", "dust", "block"};
        for (String oreDicName : OreDictionary.getOreNames()) {
            for (String prefix : validPrefixes) {
                if (!oreDicName.startsWith(prefix) || oreNames.contains(oreDicName.replace(prefix, "").toLowerCase())) continue;
                oreNames.add(oreDicName.replace(prefix, "").toLowerCase());
            }
        }
        RebornCore.logHelper.info("Found " + oreNames.size() + " ores");
    }

    public static boolean hasIngot(String name) {
        return OreUtil.doesOreExistAndValid("ingot" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasOre(String name) {
        return OreUtil.doesOreExistAndValid("ore" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasCrushedOre(String name) {
        return OreUtil.doesOreExistAndValid("crushed" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasPlate(String name) {
        return OreUtil.doesOreExistAndValid("plate" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasNugget(String name) {
        return OreUtil.doesOreExistAndValid("nugget" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasDustSmall(String name) {
        return OreUtil.doesOreExistAndValid("dustSmall" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasDust(String name) {
        return OreUtil.doesOreExistAndValid("dust" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasBlock(String name) {
        return OreUtil.doesOreExistAndValid("block" + OreUtil.capitalizeFirstLetter(name));
    }

    public static String capitalizeFirstLetter(String original) {
        if (original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }
}

