/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.forge;

import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PoweredItem;

public class ForgePowerItemManager
implements IEnergyStorage {
    ItemStack stack;
    IEnergyItemInfo itemPowerInfo;

    public ForgePowerItemManager(ItemStack stack) {
        this.stack = stack;
        if (stack.func_77973_b() instanceof IEnergyItemInfo) {
            this.itemPowerInfo = (IEnergyItemInfo)stack.func_77973_b();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(this.stack, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(this.stack, maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(this.stack);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(this.stack);
    }

    public boolean canExtract() {
        return this.itemPowerInfo.canProvideEnergy(this.stack);
    }

    public boolean canReceive() {
        return this.itemPowerInfo.canAcceptEnergy(this.stack);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().forge()) {
            return 0;
        }
        if (!this.itemPowerInfo.canAcceptEnergy(container)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - this.getEnergyStored(container), Math.min((int)this.itemPowerInfo.getMaxTransfer(container) * RebornCoreConfig.euPerFU, maxReceive *= RebornCoreConfig.euPerFU));
        if (!simulate) {
            PoweredItem.setEnergy(PoweredItem.getEnergy(container) + (double)energyReceived, container);
        }
        return energyReceived / RebornCoreConfig.euPerFU;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().forge()) {
            return 0;
        }
        if (!this.itemPowerInfo.canAcceptEnergy(container)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(container), Math.min(maxExtract *= RebornCoreConfig.euPerFU, maxExtract));
        if (!simulate) {
            PoweredItem.setEnergy(PoweredItem.getEnergy(container) - (double)energyExtracted, container);
        }
        return energyExtracted / RebornCoreConfig.euPerFU;
    }

    public int getEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().forge()) {
            return 0;
        }
        return (int)PoweredItem.getEnergy(container) / RebornCoreConfig.euPerFU;
    }

    public int getMaxEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().forge()) {
            return 0;
        }
        return (int)this.itemPowerInfo.getMaxPower(container) / RebornCoreConfig.euPerFU;
    }
}

