/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.powerSystem.tesla.AdvancedTeslaItemContainer;
import reborncore.common.powerSystem.tesla.TeslaManager;

public class PoweredItemContainerProvider
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    ItemStack stack;

    public PoweredItemContainerProvider(ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower()) && TeslaManager.manager.isTeslaCapability(capability)) {
            return true;
        }
        return RebornCoreConfig.getRebornPower().forge() && capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower()) && TeslaManager.manager.isTeslaCapability(capability)) {
            return (T)new AdvancedTeslaItemContainer(this.stack);
        }
        if (RebornCoreConfig.getRebornPower().forge() && capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerItemManager(this.stack);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }
}

