/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Loader;
import reborncore.RebornCore;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.tesla.TeslaManager;
import reborncore.mixin.json.JsonUtil;

public class PowerSystem {
    public static File priorityConfig;
    public static EnergySystem energySystem;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPowerNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerNoSuffix((int)eu);
    }

    public static String getLocaliszedPowerFormatted(double eu) {
        return PowerSystem.getLocaliszedPowerFormatted((int)eu);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return eu + " " + EnergySystem.EU.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return eu * RebornCoreConfig.euPerFU + " " + EnergySystem.TESLA.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.RF)) {
            return eu * RebornCoreConfig.euPerRF + " " + EnergySystem.RF.abbreviation;
        }
        return eu * RebornCoreConfig.euPerFU + " " + EnergySystem.FE.abbreviation;
    }

    public static String getLocaliszedPowerFormatted(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu) + " " + EnergySystem.EU.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU) + " " + EnergySystem.TESLA.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.RF)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerRF) + " " + EnergySystem.RF.abbreviation;
        }
        return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU) + " " + EnergySystem.FE.abbreviation;
    }

    public static String getLocaliszedPowerFormattedNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu);
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU);
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.RF)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerRF);
        }
        return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU);
    }

    public static String getLocaliszedPowerNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return eu + "";
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return eu * RebornCoreConfig.euPerFU + "";
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.RF)) {
            return eu * RebornCoreConfig.euPerRF + "";
        }
        return eu * RebornCoreConfig.euPerFU + "";
    }

    private static String getRoundedString(double euValue, String units) {
        if (euValue >= 1000000.0) {
            double tenX = Math.round(euValue / 100000.0);
            return Double.toString(tenX / 10.0).concat(" m " + units);
        }
        if (euValue >= 1000.0) {
            double tenX = Math.round(euValue / 100.0);
            return Double.toString(tenX / 10.0).concat(" k " + units);
        }
        return Double.toString(Math.floor(euValue)).concat(" " + units);
    }

    public static EnergySystem getDisplayPower() {
        return energySystem;
    }

    public static void bumpPowerConfig() {
        int nextId = 0;
        if (energySystem.index > EnergySystem.values().length) {
            nextId = 0;
        } else {
            for (EnergySystem system : EnergySystem.values()) {
                if (system.index <= energySystem.index || !system.isValid.test(system)) continue;
                nextId = system.index;
                break;
            }
        }
        energySystem = EnergySystem.indexOf(nextId);
        PowerSystem.writeConfig(new EnergyPriorityConfig(energySystem));
    }

    public static void reloadConfig() {
        if (!priorityConfig.exists()) {
            PowerSystem.writeConfig(new EnergyPriorityConfig(EnergySystem.FE));
            energySystem = EnergySystem.FE;
        }
        if (priorityConfig.exists()) {
            EnergyPriorityConfig config = null;
            try (FileReader reader = new FileReader(priorityConfig);){
                config = (EnergyPriorityConfig)JsonUtil.GSON.fromJson((Reader)reader, EnergyPriorityConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                RebornCore.logHelper.error("Failed to read power config, will reset to defautls and save a new file.");
                priorityConfig.delete();
                config = new EnergyPriorityConfig(EnergySystem.FE);
                PowerSystem.writeConfig(config);
            }
            if (config == null) {
                config = new EnergyPriorityConfig(EnergySystem.FE);
                PowerSystem.writeConfig(config);
            }
            energySystem = config.energySystem;
        }
    }

    public static void writeConfig(EnergyPriorityConfig config) {
        try (FileWriter writer = new FileWriter(priorityConfig);){
            JsonUtil.GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        energySystem = EnergySystem.FE;
    }

    public static class EnergyPriorityConfig {
        public EnergySystem energySystem;

        public EnergyPriorityConfig(EnergySystem energySystem) {
            this.energySystem = energySystem;
        }
    }

    public static enum EnergySystem {
        TESLA(-14827597, "Tesla", 71, 151, -16149364, 0, system -> TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower())),
        EU(-6815744, "EU", 43, 151, -11010048, 1, system -> RebornCoreConfig.getRebornPower().eu() && Loader.isModLoaded((String)"IC2")),
        FE(-2011620, "FE", 15, 151, -5031921, 2, system -> RebornCoreConfig.getRebornPower().forge()),
        RF(-5031921, "RF", 140, 151, -7143424, 3, system -> RebornCoreConfig.getRebornPower().rf());

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;
        private int index;
        private Predicate<EnergySystem> isValid;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour, int index, Predicate<EnergySystem> isValid) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
            this.index = index;
            this.isValid = isValid;
        }

        public static EnergySystem indexOf(int index) {
            for (EnergySystem system : EnergySystem.values()) {
                if (system.index != index) continue;
                return system;
            }
            return FE;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

