/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.netmonitor.GuiNetworkMonitor;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConnectedBlocksReady
implements IMessage {
    private int minx;
    private int miny;
    private int minz;
    private Map<BlockPos, BlockInfo> blockInfoMap;

    public void fromBytes(ByteBuf buf) {
        this.minx = buf.readInt();
        this.miny = buf.readInt();
        this.minz = buf.readInt();
        int size = buf.readInt();
        this.blockInfoMap = new HashMap<BlockPos, BlockInfo>();
        for (int i = 0; i < size; ++i) {
            BlockPos coordinate = new BlockPos(buf.readShort() + this.minx, buf.readShort() + this.miny, buf.readShort() + this.minz);
            BlockInfo blockInfo = new BlockInfo(coordinate, buf.readInt(), buf.readInt());
            this.blockInfoMap.put(coordinate, blockInfo);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.minx);
        buf.writeInt(this.miny);
        buf.writeInt(this.minz);
        buf.writeInt(this.blockInfoMap.size());
        for (Map.Entry<BlockPos, BlockInfo> me : this.blockInfoMap.entrySet()) {
            BlockPos c = me.getKey();
            buf.writeShort(c.func_177958_n() - this.minx);
            buf.writeShort(c.func_177956_o() - this.miny);
            buf.writeShort(c.func_177952_p() - this.minz);
            buf.writeInt(me.getValue().getEnergyStored());
            buf.writeInt(me.getValue().getMaxEnergyStored());
        }
    }

    public PacketConnectedBlocksReady() {
    }

    public PacketConnectedBlocksReady(Map<BlockPos, BlockInfo> blockInfoMap, int minx, int miny, int minz) {
        this.blockInfoMap = new HashMap<BlockPos, BlockInfo>(blockInfoMap);
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
    }

    public static class Handler
    implements IMessageHandler<PacketConnectedBlocksReady, IMessage> {
        public IMessage onMessage(PacketConnectedBlocksReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketConnectedBlocksReady message, MessageContext ctx) {
            GuiNetworkMonitor.setServerConnectedBlocks(message.blockInfoMap);
        }
    }
}

