/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storage.LevelEmitterTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiLevelEmitter
extends GenericGuiContainer<LevelEmitterTileEntity> {
    public static final int STORAGE_WIDTH = 180;
    public static final int STORAGE_HEIGHT = 152;
    public static final String OREDICT_USE = "Use";
    public static final String OREDICT_IGNORE = "Ignore";
    public static final String STARRED = "Routable";
    public static final String NOTSTARRED = "All";
    private TextField amountField;
    private ChoiceLabel oreDictLabel;
    private ChoiceLabel starredLabel;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/levelemitter.png");

    public GuiLevelEmitter(LevelEmitterTileEntity levelEmitterTileEntity, LevelEmitterContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)levelEmitterTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "levelemit");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        this.amountField = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set the amount of items in slot"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 3, 80, 14))).addTextEvent((parent, newText) -> this.setAmount());
        int amount = ((LevelEmitterTileEntity)this.tileEntity).getAmount();
        this.amountField.setText(String.valueOf(amount));
        this.starredLabel = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{NOTSTARRED, STARRED}).addChoiceEvent((parent, newChoice) -> this.setMetaUsage()).setChoiceTooltip(NOTSTARRED, new String[]{"All inventories are considered"}).setChoiceTooltip(STARRED, new String[]{"Only routable inventories are considered"});
        this.starredLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 19, 80, 14));
        this.starredLabel.setChoice(((LevelEmitterTileEntity)this.tileEntity).isStarred() ? STARRED : NOTSTARRED);
        this.oreDictLabel = new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{OREDICT_IGNORE, OREDICT_USE}).addChoiceEvent((parent, newChoice) -> this.setOredictUsage()).setChoiceTooltip(OREDICT_IGNORE, new String[]{"Ingore ore dictionary"}).setChoiceTooltip(OREDICT_USE, new String[]{"Use ore dictionary matching"});
        this.oreDictLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(60, 35, 80, 14));
        this.oreDictLabel.setChoice(((LevelEmitterTileEntity)this.tileEntity).isOreDict() ? OREDICT_USE : OREDICT_IGNORE);
        ((Panel)((Panel)((Panel)((Panel)((Panel)toplevel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Amount:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 3, 50, 14)))).addChild((Widget)this.amountField)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Routable:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 19, 50, 14)))).addChild((Widget)this.starredLabel)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Oredict:").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 35, 50, 14)))).addChild((Widget)this.oreDictLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setMetaUsage() {
        boolean b = STARRED.equals(this.starredLabel.getCurrentChoice());
        ((LevelEmitterTileEntity)this.tileEntity).setStarred(b);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setStarred", new Argument[]{new Argument("b", b)});
    }

    private void setOredictUsage() {
        boolean b = OREDICT_USE.equals(this.oreDictLabel.getCurrentChoice());
        ((LevelEmitterTileEntity)this.tileEntity).setOreDict(b);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setOreDict", new Argument[]{new Argument("b", b)});
    }

    private void setAmount() {
        int amount;
        String d = this.amountField.getText();
        try {
            amount = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            amount = 1;
        }
        ((LevelEmitterTileEntity)this.tileEntity).setAmount(amount);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCounter", new Argument[]{new Argument("amount", amount)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

