/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.network.clientinfo.PacketGetInfoFromServer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.powercell.PowerCellAdvancedTileEntity;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellCreativeTileEntity;
import mcjty.rftools.blocks.powercell.PowerCellInfoPacketClient;
import mcjty.rftools.blocks.powercell.PowerCellInfoPacketServer;
import mcjty.rftools.blocks.powercell.PowerCellNormalTileEntity;
import mcjty.rftools.blocks.powercell.PowerCellSimpleTileEntity;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPowerCell
extends GenericGuiContainer<PowerCellTileEntity> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/powercell.png");

    public GuiPowerCell(PowerCellAdvancedTileEntity te, PowerCellContainer container) {
        this((PowerCellTileEntity)te, container);
    }

    public GuiPowerCell(PowerCellNormalTileEntity te, PowerCellContainer container) {
        this((PowerCellTileEntity)te, container);
    }

    public GuiPowerCell(PowerCellSimpleTileEntity te, PowerCellContainer container) {
        this((PowerCellTileEntity)te, container);
    }

    public GuiPowerCell(PowerCellCreativeTileEntity te, PowerCellContainer container) {
        this((PowerCellTileEntity)te, container);
    }

    public GuiPowerCell(PowerCellTileEntity te, PowerCellContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)te, (Container)container, RFTools.GUI_MANUAL_MAIN, "powercell");
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(1000).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        this.energyBar.setValue(0);
        Button allNone = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("None")).setTooltips(new String[]{"Set all sides to 'none'"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(140, 10, 32, 15))).addButtonEvent(e -> this.sendServerCommand(RFToolsMessages.INSTANCE, PowerCellTileEntity.CMD_SETNONE, new Argument[0]));
        Button allInput = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("In")).setTooltips(new String[]{"Set all sides to", "accept energy"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(140, 27, 32, 15))).addButtonEvent(e -> this.sendServerCommand(RFToolsMessages.INSTANCE, PowerCellTileEntity.CMD_SETINPUT, new Argument[0]));
        Button allOutput = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Out")).setTooltips(new String[]{"Set all sides to", "send energy"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(140, 44, 32, 15))).addButtonEvent(e -> this.sendServerCommand(RFToolsMessages.INSTANCE, PowerCellTileEntity.CMD_SETOUTPUT, new Argument[0]));
        this.stats = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Stats")).setTooltips(new String[]{"Power statistics. Press to clear:"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 10, 32, 15))).addButtonEvent(e -> this.sendServerCommand(RFToolsMessages.INSTANCE, PowerCellTileEntity.CMD_CLEARSTATS, new Argument[0]));
        Label label = new Label(this.field_146297_k, (Gui)this);
        label.setText("Link:").setTooltips(new String[]{"Link a powercard to card", "on the left"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(26, 30, 40, 18));
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)allNone)).addChild((Widget)allInput)).addChild((Widget)allOutput)).addChild((Widget)label)).addChild((Widget)this.stats);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInfoFromServer("rftools", (InfoPacketServer)new PowerCellInfoPacketServer((PowerCellTileEntity)this.tileEntity)));
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.requestRF();
        this.stats.setTooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + PowerCellInfoPacketClient.tooltipInserted, "Extracted: " + PowerCellInfoPacketClient.tooltipExtracted});
        int maxValue = (PowerCellInfoPacketClient.tooltipBlocks - PowerCellInfoPacketClient.tooltipAdvancedBlocks - PowerCellInfoPacketClient.tooltipSimpleBlocks) * PowerCellConfiguration.rfPerNormalCell;
        maxValue += PowerCellInfoPacketClient.tooltipAdvancedBlocks * PowerCellConfiguration.rfPerNormalCell * PowerCellConfiguration.advancedFactor;
        this.energyBar.setMaxValue(maxValue += PowerCellInfoPacketClient.tooltipSimpleBlocks * PowerCellConfiguration.rfPerNormalCell / PowerCellConfiguration.simpleFactor);
        this.energyBar.setValue(PowerCellInfoPacketClient.tooltipEnergy);
    }
}

