/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageProvider;
import com.raoulvdberge.refinedstorage.integration.cyclopscore.IntegrationCyclopsCore;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.tile.IStorageGui;
import com.raoulvdberge.refinedstorage.tile.TileMultipartNode;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.externalstorage.FluidStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageCyclops;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageDSU;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageDrawer;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageDrawerGroup;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageItemHandler;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.microblock.IMicroblock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileExternalStorage
extends TileMultipartNode
implements IItemStorageProvider,
IFluidStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable,
IType,
IAccessType {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final TileDataParameter<AccessType> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Integer> STORED = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int stored = 0;
            for (IStorage<ItemStack> storage : tile.itemStorages) {
                stored += storage.getStored();
            }
            for (IStorage<ItemStack> storage : tile.fluidStorages) {
                stored += ((FluidStorageExternal)storage).getStored();
            }
            return stored;
        }
    });
    public static final TileDataParameter<Integer> CAPACITY = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileExternalStorage>(){

        @Override
        public Integer getValue(TileExternalStorage tile) {
            int capacity = 0;
            for (IStorage<ItemStack> storage : tile.itemStorages) {
                capacity += ((ItemStorageExternal)storage).getCapacity();
            }
            for (IStorage<ItemStack> storage : tile.fluidStorages) {
                capacity += ((FluidStorageExternal)storage).getCapacity();
            }
            return capacity;
        }
    });
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private List<ItemStorageExternal> itemStorages = new ArrayList<ItemStorageExternal>();
    private List<FluidStorageExternal> fluidStorages = new ArrayList<FluidStorageExternal>();
    private int networkTicks;

    public TileExternalStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    @Override
    public boolean canAddMicroblock(IMicroblock microblock) {
        return !TileExternalStorage.isBlockingMicroblock(microblock, this.getDirection());
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.externalStorageUsage + (this.itemStorages.size() + this.fluidStorages.size()) * RS.INSTANCE.config.externalStoragePerStorageUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        this.updateStorage(network);
        network.getItemStorageCache().invalidate();
        network.getFluidStorageCache().invalidate();
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.network != null) {
            if (this.networkTicks++ == 0) {
                this.updateStorage(this.network);
                return;
            }
            for (ItemStorageExternal storage : this.itemStorages) {
                storage.detectChanges(this.network);
            }
            boolean fluidChangeDetected = false;
            for (FluidStorageExternal storage : this.fluidStorages) {
                if (!storage.updateCache()) continue;
                fluidChangeDetected = true;
            }
            if (fluidChangeDetected) {
                this.network.getFluidStorageCache().invalidate();
            }
        }
        super.func_73660_a();
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        RSUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        RSUtils.writeItems((IItemHandler)this.fluidFilters, 1, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        RSUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 1, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        this.accessType = RSUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    public void updateStorage(INetworkMaster network) {
        IFluidHandler fluidHandler;
        this.itemStorages.clear();
        this.fluidStorages.clear();
        TileEntity facing = this.getFacingTile();
        if (this.type == 0) {
            IItemHandler itemHandler;
            if (facing instanceof IDrawerGroup) {
                this.itemStorages.add(new ItemStorageDrawerGroup(this, () -> {
                    TileEntity f = this.getFacingTile();
                    return f instanceof IDrawerGroup ? (IDrawerGroup)f : null;
                }));
            } else if (facing instanceof IDrawer) {
                this.itemStorages.add(new ItemStorageDrawer(this, () -> {
                    TileEntity f = this.getFacingTile();
                    return f instanceof IDrawer ? (IDrawer)f : null;
                }));
            } else if (facing instanceof IDeepStorageUnit) {
                this.itemStorages.add(new ItemStorageDSU(this, () -> {
                    TileEntity f = this.getFacingTile();
                    return f instanceof IDeepStorageUnit ? (IDeepStorageUnit)f : null;
                }));
            } else if (IntegrationCyclopsCore.isLoaded() && ItemStorageCyclops.isValid(facing, this.getDirection().func_176734_d())) {
                this.itemStorages.add(new ItemStorageCyclops(this));
            } else if (!(facing instanceof TileNode) && (itemHandler = RSUtils.getItemHandler(facing, this.getDirection().func_176734_d())) != null) {
                this.itemStorages.add(new ItemStorageItemHandler(this, () -> RSUtils.getItemHandler(this.getFacingTile(), this.getDirection().func_176734_d())));
            }
        } else if (this.type == 1 && (fluidHandler = RSUtils.getFluidHandler(facing, this.getDirection().func_176734_d())) != null) {
            this.fluidStorages.add(new FluidStorageExternal(this, () -> RSUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())));
        }
        network.getItemStorageCache().invalidate();
        network.getFluidStorageCache().invalidate();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IFluidStorage> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:external_storage";
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean> getVoidExcessParameter() {
        return null;
    }

    @Override
    public TileDataParameter<AccessType> getAccessTypeParameter() {
        return ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return null;
    }

    @Override
    public int getStored() {
        return STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType type) {
        this.accessType = type;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate();
            this.network.getFluidStorageCache().invalidate();
        }
        this.func_70296_d();
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return TYPE;
    }

    @Override
    public int getType() {
        return this.func_145831_w().field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
        if (this.network != null) {
            this.updateStorage(this.network);
        }
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    public ItemHandlerBasic getItemFilters() {
        return this.itemFilters;
    }

    public ItemHandlerFluid getFluidFilters() {
        return this.fluidFilters;
    }
}

