/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageDrawer;
import com.raoulvdberge.refinedstorage.tile.externalstorage.ItemStorageExternal;
import com.raoulvdberge.refinedstorage.tile.externalstorage.TileExternalStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ItemStorageDrawerGroup
extends ItemStorageExternal {
    private TileExternalStorage externalStorage;
    private Supplier<IDrawerGroup> groupSupplier;

    public ItemStorageDrawerGroup(TileExternalStorage externalStorage, Supplier<IDrawerGroup> groupSupplier) {
        this.externalStorage = externalStorage;
        this.groupSupplier = groupSupplier;
    }

    @Override
    public List<ItemStack> getStacks() {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!group.isDrawerEnabled(i)) continue;
            stacks.addAll(ItemStorageDrawer.getStacks(drawer));
        }
        return stacks;
    }

    @Override
    public int getStored() {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return 0;
        }
        int stored = 0;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!group.isDrawerEnabled(i)) continue;
            stored += drawer.getStoredItemCount();
        }
        return stored;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public int getCapacity() {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return 0;
        }
        int capacity = 0;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            if (!group.isDrawerEnabled(i)) continue;
            capacity += group.getDrawer(i).getMaxCapacity();
        }
        return capacity;
    }

    @Override
    @Nullable
    public ItemStack insertItem(@Nonnull ItemStack stack, int size, boolean simulate) {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return stack;
        }
        ItemStack remainder = stack;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            if (!group.isDrawerEnabled(i)) continue;
            remainder = ItemStorageDrawer.insertItem(this.externalStorage, group.getDrawer(i), stack, size, simulate);
            if (remainder == null || remainder.field_77994_a <= 0) break;
            size = remainder.field_77994_a;
        }
        return remainder;
    }

    @Override
    @Nullable
    public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        IDrawerGroup group = this.groupSupplier.get();
        if (group == null) {
            return null;
        }
        int toExtract = size;
        ItemStack result = null;
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            if (!group.isDrawerEnabled(i)) continue;
            ItemStack extracted = ItemStorageDrawer.extractItem(group.getDrawer(i), stack, toExtract, flags, simulate);
            if (extracted != null) {
                if (result == null) {
                    result = extracted;
                } else {
                    result.field_77994_a += extracted.field_77994_a;
                }
                toExtract -= extracted.field_77994_a;
            }
            if (toExtract == 0) break;
        }
        return result;
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }
}

