/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.capabilities.MultipartCapabilityHelper;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.IMicroblockContainerTile;
import mcmultipart.microblock.MicroblockContainer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.PartSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileMultipartNode
extends TileNode
implements IMicroblockContainerTile,
ISlottedCapabilityProvider {
    private MicroblockContainer container;

    public World getWorldIn() {
        return this.func_145831_w();
    }

    public BlockPos getPosIn() {
        return this.func_174877_v();
    }

    public MicroblockContainer getMicroblockContainer() {
        if (this.container == null) {
            this.container = new MicroblockContainer((IMicroblockContainerTile)this);
            this.container.getPartContainer().setListener(new IMultipartContainer.IMultipartContainerListener(){

                public void onAddPartPre(IMultipart part) {
                }

                public void onAddPartPost(IMultipart part) {
                    TileMultipartNode.this.onMicroblocksChanged();
                }

                public void onRemovePartPre(IMultipart part) {
                }

                public void onRemovePartPost(IMultipart part) {
                    TileMultipartNode.this.onMicroblocksChanged();
                }
            });
        }
        return this.container;
    }

    public boolean canAddMicroblock(IMicroblock microblock) {
        return true;
    }

    public void onMicroblocksChanged() {
        this.func_70296_d();
        if (this.network != null) {
            this.network.getNodeGraph().rebuild();
        } else if (this.func_145831_w() != null) {
            RSBlocks.CABLE.attemptConnect(this.func_145831_w(), this.field_174879_c);
        }
    }

    public static boolean hasBlockingMicroblock(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMultipartNode) {
            for (IMicroblock microblock : ((TileMultipartNode)tile).getMicroblockContainer().getParts()) {
                if (!TileMultipartNode.isBlockingMicroblock(microblock, direction)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockingMicroblock(IMicroblock microblock, EnumFacing direction) {
        if (!(microblock instanceof IMicroblock.IFaceMicroblock)) {
            return false;
        }
        IMicroblock.IFaceMicroblock faceMicroblock = (IMicroblock.IFaceMicroblock)microblock;
        return faceMicroblock.getFace() == direction && !faceMicroblock.isFaceHollow();
    }

    @Override
    public boolean canConduct(EnumFacing direction) {
        return !TileMultipartNode.hasBlockingMicroblock((IBlockAccess)this.func_145831_w(), this.field_174879_c, direction) && !TileMultipartNode.hasBlockingMicroblock((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177972_a(direction), direction.func_176734_d());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return MultipartCapabilityHelper.hasCapability((IMultipartContainer)this.container, capability, (EnumFacing)facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object impl = super.getCapability(capability, facing);
        if (impl != null) {
            return (T)impl;
        }
        return (T)MultipartCapabilityHelper.getCapability((IMultipartContainer)this.container, capability, (EnumFacing)facing);
    }

    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        return this.container.hasCapability(capability, slot, facing);
    }

    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        return (T)this.container.getCapability(capability, slot, facing);
    }

    public void onLoad() {
        super.onLoad();
        for (IMultipart part : this.getMicroblockContainer().getParts()) {
            part.onLoaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (IMultipart part : this.getMicroblockContainer().getParts()) {
            part.onUnloaded();
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        this.getMicroblockContainer().getPartContainer().writeToNBT(tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.getMicroblockContainer().getPartContainer().readFromNBT(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        this.getMicroblockContainer().getPartContainer().writeToNBT(tag);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        this.getMicroblockContainer().getPartContainer().readFromNBT(tag);
        super.readUpdate(tag);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = super.getRenderBoundingBox().func_72317_d((double)(-this.getPosIn().func_177958_n()), (double)(-this.getPosIn().func_177956_o()), (double)(-this.getPosIn().func_177952_p()));
        for (IMultipart part : this.getMicroblockContainer().getParts()) {
            AxisAlignedBB bb = part.getRenderBoundingBox();
            if (bb == null) continue;
            bounds = bounds.func_111270_a(bb);
        }
        return bounds.func_72317_d((double)this.getPosIn().func_177958_n(), (double)this.getPosIn().func_177956_o(), (double)this.getPosIn().func_177952_p());
    }
}

