/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiCraftingMonitor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCraftingMonitorElements
implements IMessage,
IMessageHandler<MessageCraftingMonitorElements, IMessage> {
    private List<ICraftingMonitorElement> elements = new ArrayList<ICraftingMonitorElement>();

    public MessageCraftingMonitorElements() {
    }

    public MessageCraftingMonitorElements(List<ICraftingMonitorElement> elements) {
        this.elements = elements;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Function<ByteBuf, ICraftingMonitorElement> factory = API.instance().getCraftingMonitorElementRegistry().getFactory(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (factory == null) continue;
            this.elements.add(factory.apply(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.elements.size());
        for (ICraftingMonitorElement task : this.elements) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)task.getId());
            task.write(buf);
        }
    }

    public IMessage onMessage(MessageCraftingMonitorElements message, MessageContext ctx) {
        GuiCraftingMonitor.ELEMENTS = message.elements;
        return null;
    }
}

