/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import cofh.api.energy.ItemEnergyContainer;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemProvider;
import com.raoulvdberge.refinedstorage.integration.forgeenergy.NetworkItemEnergyForge;
import com.raoulvdberge.refinedstorage.integration.ic2.IntegrationIC2;
import com.raoulvdberge.refinedstorage.integration.tesla.IntegrationTesla;
import com.raoulvdberge.refinedstorage.integration.tesla.NetworkItemEnergyTesla;
import com.raoulvdberge.refinedstorage.tile.TileController;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2"), @Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2")})
public abstract class ItemNetworkItem
extends ItemEnergyContainer
implements INetworkItemProvider,
ISpecialElectricItem,
IElectricItemManager {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_CREATIVE = 1;
    private static final String NBT_CONTROLLER_X = "ControllerX";
    private static final String NBT_CONTROLLER_Y = "ControllerY";
    private static final String NBT_CONTROLLER_Z = "ControllerZ";
    private static final String NBT_DIMENSION_ID = "DimensionID";

    public ItemNetworkItem(String name) {
        super(3200);
        this.setRegistryName("refinedstorage", name);
        this.func_77656_e(3200);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(RS.INSTANCE.tab);
        this.func_185043_a(new ResourceLocation("connected"), (stack, world, entity) -> entity != null && this.isValid(stack) ? 1.0f : 0.0f);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && this.isValid(stack)) {
            TileEntity controller;
            WorldServer controllerWorld = DimensionManager.getWorld((int)ItemNetworkItem.getDimensionId(stack));
            if (controllerWorld != null && (controller = controllerWorld.func_175625_s(new BlockPos(ItemNetworkItem.getX(stack), ItemNetworkItem.getY(stack), ItemNetworkItem.getZ(stack)))) instanceof TileController) {
                if (((TileController)controller).getNetworkItemHandler().onOpen(player, (World)controllerWorld, hand)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:network_item.out_of_range", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:network_item.not_found", new Object[0]));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new NetworkItemCapabilityProvider(stack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77952_i() != 1;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        ItemStack fullyCharged = new ItemStack(item, 1, 0);
        this.receiveEnergy(fullyCharged, this.getMaxEnergyStored(fullyCharged), false);
        list.add(fullyCharged);
        list.add(new ItemStack(item, 1, 1));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        if (stack.func_77952_i() != 1) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:energy_stored", (Object[])new Object[]{this.getEnergyStored(stack), this.getMaxEnergyStored(stack)}));
        }
        if (this.isValid(stack)) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:network_item.tooltip", (Object[])new Object[]{ItemNetworkItem.getX(stack), ItemNetworkItem.getY(stack), ItemNetworkItem.getZ(stack)}));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == RSBlocks.CONTROLLER) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a(NBT_CONTROLLER_X, pos.func_177958_n());
            tag.func_74768_a(NBT_CONTROLLER_Y, pos.func_177956_o());
            tag.func_74768_a(NBT_CONTROLLER_Z, pos.func_177952_p());
            tag.func_74768_a(NBT_DIMENSION_ID, player.field_71093_bK);
            this.initializeDefaults(tag);
            stack.func_77982_d(tag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void initializeDefaults(NBTTagCompound tag) {
    }

    public static int getDimensionId(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_DIMENSION_ID);
    }

    public static int getX(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_X);
    }

    public static int getY(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_Y);
    }

    public static int getZ(ItemStack stack) {
        return stack.func_77978_p().func_74762_e(NBT_CONTROLLER_Z);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() == newStack.func_77973_b() && this.isValid(oldStack) && this.isValid(newStack) && ItemNetworkItem.getX(oldStack) == ItemNetworkItem.getX(newStack) && ItemNetworkItem.getY(oldStack) == ItemNetworkItem.getY(newStack) && ItemNetworkItem.getZ(oldStack) == ItemNetworkItem.getZ(newStack) && ItemNetworkItem.getDimensionId(oldStack) == ItemNetworkItem.getDimensionId(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public String func_77658_a() {
        return "item.refinedstorage:" + this.getRegistryName().func_110623_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77952_i();
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack stack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return IntegrationIC2.toEU(this.receiveEnergy(stack, IntegrationIC2.toRS(amount), simulate));
    }

    @Optional.Method(modid="IC2")
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return IntegrationIC2.toEU(this.extractEnergy(stack, IntegrationIC2.toRS(amount), simulate));
    }

    @Optional.Method(modid="IC2")
    public double getCharge(ItemStack stack) {
        return IntegrationIC2.toEU(this.getEnergyStored(stack));
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack stack) {
        return IntegrationIC2.toEU(this.getMaxEnergyStored(stack));
    }

    @Optional.Method(modid="IC2")
    public boolean canUse(ItemStack stack, double amount) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="IC2")
    public String getToolTip(ItemStack stack) {
        return null;
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_X) && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_Y) && stack.func_77978_p().func_74764_b(NBT_CONTROLLER_Z) && stack.func_77978_p().func_74764_b(NBT_DIMENSION_ID);
    }

    private class NetworkItemCapabilityProvider
    implements ICapabilityProvider {
        private ItemStack stack;

        public NetworkItemCapabilityProvider(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY || IntegrationTesla.isLoaded() && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER);
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)new NetworkItemEnergyForge(this.stack);
            }
            if (IntegrationTesla.isLoaded() && (capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER)) {
                return (T)new NetworkItemEnergyTesla(this.stack);
            }
            return null;
        }
    }
}

