/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ReaderWriterHandlerItems
implements IReaderWriterHandler {
    public static final String ID = "items";
    private ItemStackHandler items = new ItemStackHandler(4);
    private ItemHandlerReaderWriter itemsReader;
    private ItemHandlerReaderWriter itemsWriter = new ItemHandlerReaderWriter((IItemHandler)this.items, false, true);

    public ReaderWriterHandlerItems(@Nullable NBTTagCompound tag) {
        this.itemsReader = new ItemHandlerReaderWriter((IItemHandler)this.items, true, false);
        if (tag != null) {
            RSUtils.readItems((IItemHandlerModifiable)this.items, 0, tag);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapability(IReaderWriter readerWriter, Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (readerWriter instanceof IReader || readerWriter instanceof IWriter);
    }

    @Override
    public <T> T getCapability(IReaderWriter readerWriter, Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (readerWriter instanceof IReader) {
                return (T)this.itemsReader;
            }
            if (readerWriter instanceof IWriter) {
                return (T)this.itemsWriter;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        RSUtils.writeItems((IItemHandler)this.items, 0, tag);
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    private class ItemHandlerReaderWriter
    implements IItemHandler {
        private IItemHandler parent;
        private boolean canInsert;
        private boolean canExtract;

        public ItemHandlerReaderWriter(IItemHandler parent, boolean canInsert, boolean canExtract) {
            this.parent = parent;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        public int getSlots() {
            return this.parent.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canInsert ? this.parent.insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canExtract ? this.parent.extractItem(slot, amount, simulate) : null;
        }
    }
}

