/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.network.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageProvider;
import com.raoulvdberge.refinedstorage.item.ItemBlockController;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.tile.TileNetworkTransmitter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class NetworkNodeGraph
implements INetworkNodeGraph {
    private TileController controller;
    private List<INetworkNode> nodes = new ArrayList<INetworkNode>();

    public NetworkNodeGraph(TileController controller) {
        this.controller = controller;
    }

    @Override
    public void rebuild(BlockPos start, boolean notify) {
        BlockPos currentPos;
        if (start == null) {
            start = this.controller.getPosition();
        }
        if (!this.controller.canRun()) {
            if (!this.nodes.isEmpty()) {
                this.disconnectAll();
            }
            return;
        }
        World world = this.getWorld();
        ArrayList<INetworkNode> newNodes = new ArrayList<INetworkNode>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        checked.add(start);
        toCheck.add(start);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos pos = start.func_177972_a(facing);
            checked.add(pos);
            toCheck.add(pos);
        }
        while ((currentPos = (BlockPos)toCheck.poll()) != null) {
            TileNetworkTransmitter transmitter;
            TileEntity tile = world.func_175625_s(currentPos);
            if (tile instanceof TileController && !this.controller.func_174877_v().equals((Object)currentPos)) {
                world.func_175698_g(currentPos);
                IBlockState state = world.func_180495_p(currentPos);
                InventoryHelper.func_180173_a((World)world, (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), (ItemStack)ItemBlockController.createStackWithNBT(new ItemStack((Block)RSBlocks.CONTROLLER, 1, state.func_177230_c().func_176201_c(state))));
                continue;
            }
            if (!(tile instanceof INetworkNode)) continue;
            INetworkNode node = (INetworkNode)tile;
            newNodes.add(node);
            if (tile instanceof TileNetworkTransmitter && (transmitter = (TileNetworkTransmitter)tile).canTransmit()) {
                if (!transmitter.isSameDimension()) {
                    WorldServer dimensionWorld = DimensionManager.getWorld((int)transmitter.getReceiverDimension());
                    if (dimensionWorld != null) {
                        NetworkNodeGraph dimensionGraph = new NetworkNodeGraph(this.controller, (World)dimensionWorld){
                            final /* synthetic */ World val$dimensionWorld;
                            {
                                this.val$dimensionWorld = world;
                                super(controller);
                            }

                            @Override
                            public World getWorld() {
                                return this.val$dimensionWorld;
                            }
                        };
                        dimensionGraph.rebuild(transmitter.getReceiver(), false);
                        newNodes.addAll(dimensionGraph.all());
                    }
                } else {
                    BlockPos receiver = transmitter.getReceiver();
                    if (checked.add(receiver)) {
                        toCheck.add(receiver);
                    }
                }
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos pos;
                if (!node.canConduct(facing) || !checked.add(pos = currentPos.func_177972_a(facing))) continue;
                toCheck.add(pos);
            }
        }
        ArrayList<INetworkNode> oldNodes = new ArrayList<INetworkNode>(this.nodes);
        this.nodes = newNodes;
        boolean changed = false;
        if (notify) {
            for (INetworkNode node : this.nodes) {
                if (oldNodes.contains(node)) continue;
                node.onConnected(this.controller);
                changed = true;
            }
            for (INetworkNode oldNode : oldNodes) {
                if (this.nodes.contains(oldNode)) continue;
                oldNode.onDisconnected(this.controller);
                changed = true;
            }
        }
        if (changed) {
            this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
        }
    }

    @Override
    public List<INetworkNode> all() {
        return this.nodes;
    }

    @Override
    public void replace(INetworkNode node) {
        this.nodes.remove(node);
        this.nodes.add(node);
        if (node instanceof ICraftingPatternContainer) {
            this.controller.rebuildPatterns();
        }
        if (node instanceof IItemStorageProvider) {
            this.controller.getItemStorageCache().invalidate();
        }
        if (node instanceof IFluidStorageProvider) {
            this.controller.getFluidStorageCache().invalidate();
        }
        this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
    }

    @Override
    public void disconnectAll() {
        ArrayList<INetworkNode> oldNodes = new ArrayList<INetworkNode>(this.nodes);
        this.nodes.clear();
        for (INetworkNode node : oldNodes) {
            if (!node.isConnected()) continue;
            node.onDisconnected(this.controller);
        }
        this.controller.getDataManager().sendParameterToWatchers(TileController.NODES);
    }

    protected World getWorld() {
        return this.controller.func_145831_w();
    }
}

