/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.block;

import com.valkyrieofnight.valkyrielib.item.VLItemBlock;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class VLBlockStairs
extends BlockStairs {
    private String blockName;
    private String modBase;
    private boolean playerBreakOnly = false;
    protected VLItemBlock itemBlock;

    protected VLBlockStairs(IBlockState modelState, String modID, String blockName, float hardness, float resistance, CreativeTabs tab) {
        super(modelState);
        this.blockName = blockName;
        this.modBase = modID;
        this.setRegistryName(blockName);
        this.func_149663_c(this.modBase + "." + blockName);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.itemBlock = new VLItemBlock((Block)this);
        this.register();
        this.func_149647_a(tab);
    }

    public void setPlayerBreakOnly(boolean opt) {
        this.playerBreakOnly = opt;
        if (opt) {
            this.addToolTipLocalized(LanguageHelper.toLoc("tooltip.valkyrielib.witherproof"));
            this.addToolTipLocalized(LanguageHelper.toLoc("tooltip.valkyrielib.playerbreakonly"));
        }
    }

    public void register() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)this.itemBlock, (ResourceLocation)this.getRegistryName());
    }

    public void addToolTipLocalized(String str) {
        if (this.itemBlock != null) {
            this.itemBlock.addToolTipLocalized(str);
        }
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        return !this.playerBreakOnly;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.playerBreakOnly) {
            world.func_175698_g(pos);
            this.func_180652_a(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (this.playerBreakOnly) {
            return false;
        }
        return super.func_149659_a(explosionIn);
    }
}

