/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core;

import com.enderio.core.IEnderMod;
import com.enderio.core.api.common.config.IConfigHandler;
import com.enderio.core.common.CommonProxy;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.Lang;
import com.enderio.core.common.OreDict;
import com.enderio.core.common.command.CommandReloadConfigs;
import com.enderio.core.common.command.CommandScoreboardInfo;
import com.enderio.core.common.compat.CompatRegistry;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.enchant.EnchantAutoSmelt;
import com.enderio.core.common.enchant.EnchantXPBoost;
import com.enderio.core.common.imc.IMCRegistry;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.util.EnderFileUtils;
import com.enderio.core.common.util.PermanentCache;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="endercore", name="EnderCore", version="1.10.2-0.4.1.65-beta", dependencies="after:ttCore", guiFactory="com.enderio.core.common.config.BaseConfigFactory", acceptedMinecraftVersions="[1.10.2]")
public class EnderCore
implements IEnderMod {
    public static final String MODID = "endercore";
    public static final String DOMAIN = "endercore".toLowerCase(Locale.US);
    public static final String NAME = "EnderCore";
    public static final String BASE_PACKAGE = "com.enderio";
    public static final String VERSION = "1.10.2-0.4.1.65-beta";
    public static final Logger logger = LogManager.getLogger((String)"EnderCore");
    public static final Lang lang = new Lang("endercore");
    @Mod.Instance(value="endercore")
    public static EnderCore instance;
    @SidedProxy(serverSide="com.enderio.core.common.CommonProxy", clientSide="com.enderio.core.client.ClientProxy")
    public static CommonProxy proxy;
    public List<IConfigHandler> configs = Lists.newArrayList();
    private Set<String> invisibleRequesters = Sets.newHashSet();

    public void requestInvisibleMode() {
        this.invisibleRequesters.add(Loader.instance().activeModContainer().getName());
    }

    public boolean invisibilityRequested() {
        return !this.invisibleRequesters.isEmpty();
    }

    public Set<String> getInvisibleRequsters() {
        return ImmutableSet.copyOf(this.invisibleRequesters);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.configFolder = event.getModConfigurationDirectory();
        ConfigHandler.enderConfigFolder = new File(ConfigHandler.configFolder.getPath() + "/" + MODID);
        ConfigHandler.configFile = new File(ConfigHandler.enderConfigFolder.getPath() + "/" + event.getSuggestedConfigurationFile().getName());
        if (!ConfigHandler.configFile.exists() && event.getSuggestedConfigurationFile().exists()) {
            try {
                FileUtils.copyFile((File)event.getSuggestedConfigurationFile(), (File)ConfigHandler.configFile);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            EnderFileUtils.safeDelete(event.getSuggestedConfigurationFile());
        }
        ConfigHandler.instance().initialize(ConfigHandler.configFile);
        Handlers.preInit(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        OreDict.registerVanilla();
        EnchantXPBoost.register();
        EnchantAutoSmelt.register();
        proxy.onPreInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        EnderPacketHandler.init();
        for (IConfigHandler c : this.configs) {
            c.initHook();
        }
        Handlers.register(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        if (event.getSide().isServer()) {
            ((CommandHandler)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)CommandReloadConfigs.SERVER);
        } else {
            ClientCommandHandler.instance.func_71560_a((ICommand)CommandReloadConfigs.CLIENT);
        }
        IMCRegistry.INSTANCE.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (IConfigHandler c : this.configs) {
            c.postInitHook();
        }
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        ConfigHandler.instance().loadRightClickCrops();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandScoreboardInfo());
        PermanentCache.saveCaches();
    }

    @Mod.EventHandler
    public void onIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCRegistry.INSTANCE.handleEvent(event);
    }

    @Override
    public String modid() {
        return MODID;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String version() {
        return VERSION;
    }
}

