/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.util.ListUtils;
import mekanism.api.util.UnitDisplayUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyGauge;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiNumberGauge;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiFuelTab;
import mekanism.generators.client.gui.element.GuiStatTab;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiReactorHeat
extends GuiMekanism {
    public TileEntityReactorController tileEntity;

    public GuiReactorHeat(InventoryPlayer inventory, final TileEntityReactorController tentity) {
        super((Container)new ContainerNull(inventory.field_70458_d, (TileEntityContainerBlock)tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            public List<String> getInfo() {
                return GuiReactorHeat.this.tileEntity.isFormed() ? ListUtils.asList((Object[])new String[]{LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)GuiReactorHeat.this.tileEntity.getEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)GuiReactorHeat.this.tileEntity.getReactor().getPassiveGeneration(false, true)) + "/t"}) : new ArrayList<String>();
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png")));
        this.guiElements.add(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getFluidTexture((Fluid)FluidRegistry.LAVA, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(GuiReactorHeat.this.tileEntity.getPlasmaTemp(), true);
            }

            public double getMaxLevel() {
                return 5.0E8;
            }

            public String getText(double level) {
                return "Plasma: " + MekanismUtils.getTemperatureDisplay((double)level, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
        }, GuiGauge.Type.STANDARD, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 7, 50));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            public double getProgress() {
                return GuiReactorHeat.this.tileEntity.getPlasmaTemp() > GuiReactorHeat.this.tileEntity.getCaseTemp() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 27, 75));
        this.guiElements.add(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getFluidTexture((Fluid)FluidRegistry.LAVA, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return UnitDisplayUtils.TemperatureUnit.AMBIENT.convertToK(GuiReactorHeat.this.tileEntity.getCaseTemp(), true);
            }

            public double getMaxLevel() {
                return 5.0E8;
            }

            public String getText(double level) {
                return "Case: " + MekanismUtils.getTemperatureDisplay((double)level, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN);
            }
        }, GuiGauge.Type.STANDARD, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 61, 50));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            public double getProgress() {
                return GuiReactorHeat.this.tileEntity.getCaseTemp() > 0.0 ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 81, 60));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            public double getProgress() {
                return GuiReactorHeat.this.tileEntity.getCaseTemp() > 0.0 && GuiReactorHeat.this.tileEntity.waterTank.getFluidAmount() > 0 && GuiReactorHeat.this.tileEntity.steamTank.getFluidAmount() < GuiReactorHeat.this.tileEntity.steamTank.getCapacity() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.SMALL_RIGHT, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 81, 90));
        this.guiElements.add(new GuiFluidGauge(new GuiFluidGauge.IFluidInfoHandler(){

            public FluidTank getTank() {
                return tentity.waterTank;
            }
        }, GuiGauge.Type.SMALL, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 115, 84));
        this.guiElements.add(new GuiFluidGauge(new GuiFluidGauge.IFluidInfoHandler(){

            public FluidTank getTank() {
                return tentity.steamTank;
            }
        }, GuiGauge.Type.SMALL, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 151, 84));
        this.guiElements.add(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(){

            public IStrictEnergyStorage getEnergyStorage() {
                return GuiReactorHeat.this.tileEntity;
            }
        }, GuiGauge.Type.SMALL, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"), 115, 46));
        this.guiElements.add(new GuiFuelTab((IGuiWrapper)this, (TileEntity)this.tileEntity, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png")));
        this.guiElements.add(new GuiStatTab((IGuiWrapper)this, (TileEntity)this.tileEntity, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png")));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 46, 6, 0x404040);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiTall.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 14, 14, 14);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0 && xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            SoundHandler.playSound((SoundEvent)SoundEvents.field_187909_gi);
            Mekanism.packetHandler.sendToServer((IMessage)new PacketSimpleGui.SimpleGuiMessage(Coord4D.get((TileEntity)this.tileEntity), 1, 10));
        }
    }
}

