/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import java.text.DecimalFormat;

public class DataUtils {
    public static DataUtils instance = new DataUtils();

    public static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static class XYZTri<X, Y, Z> {
        public X x;
        public Y y;
        public Z z;

        public XYZTri(X x, Y y, Z z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class XZPair<X, Z> {
        public X x;
        public Z z;

        public XZPair(X x, Z z) {
            this.x = x;
            this.z = z;
        }

        public X getKey() {
            return this.x;
        }

        public Z getValue() {
            return this.z;
        }
    }

    public static class IntPair {
        public int i1;
        public int i2;

        public IntPair(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }
    }
}

