/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IScrollListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiListEntry;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiScrollBar;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class MGuiList
extends MGuiElementBase
implements IScrollListener {
    protected boolean scrollBarEnabled = true;
    protected MGuiScrollBar scrollBar;
    public int leftPadding = 1;
    public int rightPadding = 1;
    public int topPadding = 1;
    public int bottomPadding = 1;
    public boolean disableList = false;
    protected boolean updateRequired = true;
    public boolean allowOutsideClicks = false;
    public boolean lockScrollBar = false;
    public LinkedList<MGuiListEntry> listEntries = new LinkedList();
    public LinkedList<MGuiElementBase> nonListEntries = new LinkedList();

    public MGuiList(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiList(IModularGui modularGui, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
    }

    public MGuiList(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
    }

    @Override
    public void initElement() {
        this.initScrollBar();
        this.updateEntriesAndScrollBar();
        super.initElement();
    }

    protected void initScrollBar() {
        if (this.scrollBar != null) {
            this.removeChild(this.scrollBar);
        }
        this.scrollBar = new MGuiScrollBar(this.modularGui, this.xPos + this.xSize - 10, this.yPos + 1, 10, this.ySize - 2);
        this.addChild(this.scrollBar);
        this.scrollBar.setListener(this);
        this.scrollBar.parentScrollable = this;
    }

    public MGuiList addEntry(MGuiListEntry entry) {
        this.listEntries.add(entry);
        entry.setList(this);
        super.addChild(entry);
        this.updateRequired = true;
        return this;
    }

    @Override
    public MGuiElementBase addChild(MGuiElementBase element) {
        this.nonListEntries.add(element);
        return super.addChild(element);
    }

    public void clear() {
        this.toRemove.addAll(this.listEntries);
        this.listEntries.clear();
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || this.listEntries.contains(mGuiElementBase)) continue;
            mGuiElementBase.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        this.cullList();
        if (this.disableList) {
            return;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled()) continue;
            mGuiElementBase.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || this.listEntries.contains(mGuiElementBase)) continue;
            mGuiElementBase.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        this.cullList();
        if (this.disableList) {
            return;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled()) continue;
            mGuiElementBase.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || this.listEntries.contains(mGuiElementBase)) continue;
            mGuiElementBase.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }
        this.cullList();
        if (this.disableList) {
            return;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled()) continue;
            mGuiElementBase.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    protected void cullList() {
        this.zOffset = 160.0;
        GlStateManager.func_179118_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double left = this.xPos;
        double top = 0.0;
        double right = this.xPos + this.xSize;
        double bottom = this.yPos + this.topPadding;
        double zLevel = this.getRenderZLevel();
        vertexbuffer.func_181662_b(left, bottom, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(right, top, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        top = this.yPos + this.ySize - this.bottomPadding;
        bottom = this.modularGui.screenHeight();
        vertexbuffer.func_181662_b(left, bottom, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(right, top, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(left, top, zLevel).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        this.zOffset = 0.0;
    }

    @Override
    public void scrollBarMoved(double pos) {
        int maxMove = this.getListHeight() - (this.ySize - 1);
        this.scrollBar.setIncrements(50.0 / (double)maxMove, 0.1);
        this.updateEntriesAndScrollBar();
    }

    protected void updateEntriesAndScrollBar() {
        boolean canScroll;
        double scrollPos = this.scrollBar == null ? 0.0 : this.scrollBar.getScrollPos();
        int yOffset = this.topPadding;
        int maxMove = this.getListHeight() - (this.ySize - 1);
        if (maxMove > 0 && scrollPos > 0.0) {
            yOffset = this.topPadding - (int)(scrollPos * (double)maxMove);
        }
        for (MGuiListEntry entry : this.listEntries) {
            if (!entry.isEnabled()) continue;
            entry.moveEntry(this.xPos + this.leftPadding, this.yPos + yOffset);
            yOffset += entry.getEntryHeight();
        }
        boolean bl = canScroll = maxMove > 0;
        if (!canScroll && this.lockScrollBar) {
            this.scrollBarEnabled = true;
            this.scrollBar.setEnabled(true);
            this.scrollBar.setBarSizeRatio(0.0);
        } else {
            this.scrollBarEnabled = canScroll;
            this.scrollBar.setEnabled(this.scrollBarEnabled);
            this.scrollBar.setBarSizeRatio((double)(maxMove + this.ySize) / (double)this.ySize);
        }
    }

    protected int getListHeight() {
        int height = 0;
        for (MGuiListEntry entry : this.listEntries) {
            if (!entry.isEnabled()) continue;
            height += entry.getEntryHeight();
        }
        return height + this.topPadding + this.bottomPadding;
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
    }

    @Override
    public boolean onUpdate() {
        if (!this.toRemove.isEmpty()) {
            this.nonListEntries.removeAll(this.toRemove);
        }
        if (this.updateRequired) {
            this.updateRequired = false;
            this.updateEntriesAndScrollBar();
        }
        return super.onUpdate();
    }

    public void schedualUpdate() {
        this.updateRequired = true;
    }

    public MGuiList setScrollBarEnabled(boolean scrollBarEnabled) {
        this.scrollBarEnabled = scrollBarEnabled;
        return this;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isMouseOver(mouseX, mouseY) && !this.allowOutsideClicks) {
            return false;
        }
        for (MGuiElementBase mGuiElementBase : this.nonListEntries) {
            if (!mGuiElementBase.isEnabled() || !mGuiElementBase.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        if (this.disableList) {
            return false;
        }
        for (MGuiElementBase mGuiElementBase : this.listEntries) {
            if (!mGuiElementBase.isEnabled() || !mGuiElementBase.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }
}

