/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.libs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.misc.FeatureDisabled;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModUtils {
    public static final List<Item> ITEMS = new ArrayList<Item>();
    public static final List<Block> BLOCKS = new ArrayList<Block>();

    public static void addConversionRecipes(ItemStack input, ItemStack output) {
        for (int amount = 1; amount < 10; ++amount) {
            Object[] inputs = new ItemStack[amount];
            Arrays.fill(inputs, input);
            GameRegistry.addShapelessRecipe((ItemStack)ItemStackUtils.copyStackWithSize((ItemStack)output, (int)amount), (Object[])inputs);
        }
    }

    public static Block registerBlock(Block block, String ID) {
        block.setRegistryName(ID);
        block.func_149647_a(DarkUtils.TAB);
        block.func_149663_c("darkutils." + ID.toLowerCase().replace("_", "."));
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)block.getRegistryName());
        BLOCKS.add(block);
        return block;
    }

    public static Block registerBlock(Block block, ItemBlock item, String ID) {
        block.setRegistryName(ID);
        block.func_149647_a(DarkUtils.TAB);
        block.func_149663_c("darkutils." + ID.toLowerCase().replace("_", "."));
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)block.getRegistryName());
        BLOCKS.add(block);
        return block;
    }

    public static Item registerItem(Item item, String ID) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(ID);
        }
        item.func_77637_a(DarkUtils.TAB);
        item.func_77655_b("darkutils." + ID.toLowerCase().replace("_", "."));
        GameRegistry.register((IForgeRegistryEntry)item);
        ITEMS.add(item);
        return item;
    }

    public static Object validateCrafting(Object object) {
        if (object instanceof ItemStack) {
            return ItemStackUtils.isValidStack((ItemStack)((ItemStack)object)) ? object : FeatureDisabled.itemDisabled;
        }
        return object != null ? object : FeatureDisabled.itemDisabled;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, String[] variants) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, String prefix, String[] variants) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), prefix, variants);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockInvModel(Block block, int meta) {
        ModUtils.registerItemInvModel(Item.func_150898_a((Block)block), meta);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, int meta, String model) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(model, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, String prefix, String[] variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":" + prefix + "_" + variants[meta], "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, String[] variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":" + variants[meta], "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemInvModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }
}

