/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.vector;

import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.features.vector.BlockVectorPlate;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FeatureVectorPlate
extends Feature {
    public static Block blockVectorPlate;
    public static Block blockFastVectorPlate;
    public static Block blockHyperVectorPlate;
    private static boolean craftVectorPlate;
    protected static boolean preventItemDespawn;
    protected static boolean preventItemPickup;
    private static double normalSpeed;
    private static double fastSpeed;
    private static double hyperSpeed;

    @Override
    public void onPreInit() {
        blockVectorPlate = new BlockVectorPlate(normalSpeed);
        ModUtils.registerBlock(blockVectorPlate, "trap_move");
        blockFastVectorPlate = new BlockVectorPlate(fastSpeed);
        ModUtils.registerBlock(blockFastVectorPlate, "trap_move_fast");
        blockHyperVectorPlate = new BlockVectorPlate(hyperSpeed);
        ModUtils.registerBlock(blockHyperVectorPlate, "trap_move_hyper");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        craftVectorPlate = config.getBoolean("Craft Vector Plate", this.configName, true, "Should the Vector Plate be craftable?");
        preventItemDespawn = config.getBoolean("Prevent Item Despawn", this.configName, true, "Should vector plates prevent item despawn?");
        preventItemPickup = config.getBoolean("Prevent Item Pickup", this.configName, true, "Should vector plates prevent items from being picked up, while they are being pushed?");
        normalSpeed = config.getFloat("Normal Speed", this.configName, 0.06f, 0.0f, 5.0f, "Speed modifier for the normal vector plate");
        fastSpeed = config.getFloat("Fast Speed", this.configName, 0.3f, 0.0f, 5.0f, "Speed modifier for the fast vector plate");
        hyperSpeed = config.getFloat("Hyper Speed", this.configName, 1.5f, 0.0f, 5.0f, "Speed modifier for the hyper vector plate");
    }

    @Override
    public void setupRecipes() {
        if (craftVectorPlate) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockVectorPlate, 8), new Object[]{"isi", "bfb", Character.valueOf('s'), "slimeball", Character.valueOf('b'), "stone", Character.valueOf('f'), Items.field_151102_aT}));
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockFastVectorPlate, 8), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), blockVectorPlate, Character.valueOf('y'), ModUtils.validateCrafting(new ItemStack(FeatureMaterial.itemMaterial, 1, 3))});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(blockHyperVectorPlate, 8), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), blockFastVectorPlate, Character.valueOf('y'), ModUtils.validateCrafting(new ItemStack(FeatureMaterial.blockWitherDust, 1, Short.MAX_VALUE))});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerBlockInvModel(blockVectorPlate);
        ModUtils.registerBlockInvModel(blockFastVectorPlate);
        ModUtils.registerBlockInvModel(blockHyperVectorPlate);
    }

    static {
        craftVectorPlate = true;
        preventItemDespawn = true;
        preventItemPickup = true;
        normalSpeed = 0.06;
        fastSpeed = 0.3;
        hyperSpeed = 1.5;
    }
}

