/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter.chests;

import cubex2.mods.chesttransporter.api.TransportableChest;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TransportableChestImpl
extends TransportableChest {
    protected final Block chestBlock;
    protected final int chestMeta;
    protected final int transporterDV;
    protected final String name;

    public TransportableChestImpl(Block chestBlock, int chestMeta, int transporterDV, String name) {
        this.chestBlock = chestBlock;
        this.chestMeta = chestMeta;
        this.transporterDV = transporterDV;
        this.name = name;
        this.setRegistryName(name);
    }

    @Override
    public boolean canGrabChest(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack transporter) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        return block == this.chestBlock && (this.chestMeta == -1 || this.chestMeta == meta);
    }

    @Override
    public boolean canPlaceChest(World world, BlockPos pos, EntityPlayer player, ItemStack transporter) {
        return true;
    }

    public Block getChestBlock() {
        return this.chestBlock;
    }

    public int getChestMetadata() {
        return this.chestMeta;
    }

    public int getTransporterDV() {
        return this.transporterDV;
    }

    @Override
    public ItemStack createChestStack(ItemStack transporter) {
        if (this.getChestMetadata() == -1) {
            return new ItemStack(this.getChestBlock());
        }
        return new ItemStack(this.getChestBlock(), 1, this.getChestMetadata());
    }

    @Override
    public Collection<ResourceLocation> getChestModels() {
        return Collections.singleton(new ResourceLocation("chesttransporter:item/" + this.name));
    }

    @Override
    public ResourceLocation getChestModel(ItemStack stack) {
        return new ResourceLocation("chesttransporter:item/" + this.name);
    }

    protected static ResourceLocation locationFromName(String iconName) {
        return new ResourceLocation("chesttransporter:item/" + iconName);
    }
}

