/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityTurretGun
extends TileEntityTurret {
    public int cycleRender;
    private ItemStack[] inventory = new ItemStack[2];
    public boolean expelCasings = false;

    @Override
    protected double getRange() {
        return 16.0;
    }

    @Override
    protected boolean canActivate() {
        return this.energyStorage.getEnergyStored() >= Config.IEConfig.Machines.turret_gun_consumption && this.inventory[0] != null;
    }

    @Override
    protected int getChargeupTicks() {
        return 5;
    }

    @Override
    protected int getActiveTicks() {
        return 5;
    }

    @Override
    protected boolean loopActivation() {
        return false;
    }

    @Override
    protected void activate() {
        String key;
        BulletHandler.IBullet bullet;
        int energy = Config.IEConfig.Machines.turret_gun_consumption;
        ItemStack bulletStack = this.inventory[0];
        if (bulletStack != null && this.energyStorage.extractEnergy(energy, true) == energy && (bullet = BulletHandler.getBullet(key = ItemNBTHelper.getString(bulletStack, "bullet"))) != null && bullet.isValidForTurret()) {
            ItemStack casing = bullet.getCasing(bulletStack);
            if (this.expelCasings || casing == null || this.inventory[1] == null || OreDictionary.itemMatches((ItemStack)casing, (ItemStack)this.inventory[1], (boolean)false) && this.inventory[1].field_77994_a + casing.field_77994_a <= this.inventory[1].func_77976_d()) {
                this.energyStorage.extractEnergy(energy, false);
                this.sendRenderPacket();
                double dX = this.target.field_70165_t - ((double)this.func_174877_v().func_177958_n() + 0.5);
                double dY = this.target.field_70163_u - ((double)this.func_174877_v().func_177956_o() + 0.5);
                double dZ = this.target.field_70161_v - ((double)this.func_174877_v().func_177952_p() + 0.5);
                Vec3d vec = new Vec3d(dX, dY, dZ).func_72432_b();
                int count = bullet.getProjectileCount(null, bulletStack);
                if (count == 1) {
                    EntityRevolvershot entBullet = this.getBulletEntity(this.field_145850_b, vec, bullet);
                    this.field_145850_b.func_72838_d(bullet.getProjectile(null, bulletStack, entBullet, false));
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vec3d vecDir = vec.func_72441_c(this.field_145850_b.field_73012_v.nextGaussian() * 0.1, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, this.field_145850_b.field_73012_v.nextGaussian() * 0.1);
                        EntityRevolvershot entBullet = this.getBulletEntity(this.field_145850_b, vecDir, bullet);
                        this.field_145850_b.func_72838_d(bullet.getProjectile(null, bulletStack, entBullet, false));
                    }
                }
                if (--bulletStack.field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                if (casing != null) {
                    if (this.expelCasings) {
                        double cX = (double)this.func_174877_v().func_177958_n() + 0.5;
                        double cY = (double)this.func_174877_v().func_177956_o() + 1.375;
                        double cZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                        Vec3d vCasing = vec.func_178785_b(-1.57f);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, cX + vCasing.field_72450_a, cY + vCasing.field_72448_b, cZ + vCasing.field_72449_c, 0.0, 0.0, 0.0, new int[]{1, 0});
                        EntityItem entCasing = new EntityItem(this.field_145850_b, cX + vCasing.field_72450_a, cY + vCasing.field_72448_b, cZ + vCasing.field_72449_c, casing.func_77946_l());
                        entCasing.field_70159_w = 0.0;
                        entCasing.field_70181_x = -0.01;
                        entCasing.field_70179_y = 0.0;
                        this.field_145850_b.func_72838_d((Entity)entCasing);
                    } else if (this.inventory[1] == null) {
                        this.inventory[1] = casing.func_77946_l();
                    } else {
                        this.inventory[1].field_77994_a += casing.field_77994_a;
                    }
                }
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.revolverFire, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void sendRenderPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("cycle", true);
        ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageTileSync(this, tag));
    }

    EntityRevolvershot getBulletEntity(World world, Vec3d vecDir, BulletHandler.IBullet type) {
        EntityRevolvershot bullet = new EntityRevolvershot(world, (double)this.func_174877_v().func_177958_n() + 0.5 + vecDir.field_72450_a, (double)this.func_174877_v().func_177956_o() + 1.375 + vecDir.field_72448_b, (double)this.func_174877_v().func_177952_p() + 0.5 + vecDir.field_72449_c, 0.0, 0.0, 0.0, type);
        bullet.field_70159_w = vecDir.field_72450_a;
        bullet.field_70181_x = vecDir.field_72448_b;
        bullet.field_70179_y = vecDir.field_72449_c;
        return bullet;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.dummy && this.cycleRender > 0) {
            --this.cycleRender;
        }
        super.func_73660_a();
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.func_74764_b("cycle")) {
            this.cycleRender = 5;
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (message.func_74764_b("expelCasings")) {
            this.expelCasings = message.func_74767_n("expelCasings");
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.expelCasings = nbt.func_74767_n("expelCasings");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 2);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("expelCasings", this.expelCasings);
        if (!descPacket) {
            Utils.writeInventory(this.inventory);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return super.getCapability(capability, facing);
    }
}

