/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayHV;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityConnectorLV
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockBounds {
    boolean inICNet = false;
    public EnumFacing facing = EnumFacing.DOWN;
    private long lastTransfer = -1L;
    public int currentTickAccepted = 0;
    public static int[] connectorInputValues = new int[0];
    private FluxStorage energyStorage = new FluxStorage(this.getMaxInput(), this.getMaxInput(), 0);
    boolean firstTick = true;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int temp;
            if (this.energyStorage.getEnergyStored() > 0 && (temp = this.transferEnergy(this.energyStorage.getEnergyStored(), true, 0)) > 0) {
                this.energyStorage.modifyEnergyStored(-this.transferEnergy(temp, false, 0));
                this.func_70296_d();
            }
            this.currentTickAccepted = 0;
        } else if (this.firstTick) {
            Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
            if (conns != null) {
                for (ImmersiveNetHandler.Connection conn : conns) {
                    if (this.field_174879_c.compareTo((Vec3i)conn.end) >= 0 || !this.field_145850_b.func_175667_e(conn.end)) continue;
                    this.markContainingBlockForUpdate(null);
                }
            }
            this.firstTick = false;
        }
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        if (this.isRelay()) {
            return false;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        return EnergyHelper.isFluxReceiver(tile, this.facing.func_176734_d());
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (this.isRelay()) {
            return 0;
        }
        int acceptanceLeft = this.getMaxOutput() - this.currentTickAccepted;
        if (acceptanceLeft <= 0) {
            return 0;
        }
        int toAccept = Math.min(acceptanceLeft, amount);
        TileEntity capacitor = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        int ret = EnergyHelper.insertFlux(capacitor, this.facing.func_176734_d(), toAccept, simulate);
        if (!simulate) {
            this.currentTickAccepted += ret;
        }
        return ret;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74772_a("lastTransfer", this.lastTransfer);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.lastTransfer = nbt.func_74763_f("lastTransfer");
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.facing.func_176734_d();
        return new Vec3d(0.5 + (double)side.func_82601_c() * 0.0625, 0.5 + (double)side.func_96559_d() * 0.0625, 0.5 + (double)side.func_82599_e() * 0.0625);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 - conRadius * (double)side.func_82601_c(), 0.5 - conRadius * (double)side.func_96559_d(), 0.5 - conRadius * (double)side.func_82599_e());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return WireType.COPPER.getMaxLength();
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing != this.facing) {
            return null;
        }
        if (this.energyWrapper == null || this.energyWrapper.side != this.facing) {
            this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper(this, this.facing);
        }
        return this.energyWrapper;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == this.facing) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == this.facing) {
            return (T)this.getCapabilityWrapper(this.facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return !this.isRelay() && facing == this.facing ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (this.isRelay()) {
            return false;
        }
        return from == this.facing;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int energy, boolean simulate) {
        if (this.field_145850_b.field_72995_K || this.isRelay()) {
            return 0;
        }
        if (this.field_145850_b.func_82737_E() == this.lastTransfer) {
            return 0;
        }
        int accepted = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
        accepted = Math.min(this.getMaxOutput() - this.energyStorage.getEnergyStored(), accepted);
        if (accepted <= 0) {
            return 0;
        }
        if (!simulate) {
            this.energyStorage.modifyEnergyStored(accepted);
            this.lastTransfer = this.field_145850_b.func_82737_E();
            this.func_70296_d();
        }
        return accepted;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.isRelay()) {
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.isRelay()) {
            return 0;
        }
        return this.getMaxInput();
    }

    @Override
    public int extractEnergy(EnumFacing from, int energy, boolean simulate) {
        return 0;
    }

    public int transferEnergy(int energy, boolean simulate, int energyType) {
        int received = 0;
        if (!this.field_145850_b.field_72995_K) {
            IImmersiveConnectable end;
            int powerLeft;
            Set<ImmersiveNetHandler.AbstractConnection> outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(this), this.field_145850_b);
            int powerForSort = powerLeft = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
            if (outputs.size() < 1) {
                return 0;
            }
            int sum = 0;
            HashMap<ImmersiveNetHandler.AbstractConnection, Integer> powerSorting = new HashMap<ImmersiveNetHandler.AbstractConnection, Integer>();
            for (ImmersiveNetHandler.AbstractConnection con : outputs) {
                int atmOut;
                int tempR;
                end = ApiUtils.toIIC(con.end, this.field_145850_b);
                if (con.cableType == null || end == null || (tempR = end.outputEnergy(atmOut = Math.min(powerForSort, con.cableType.getTransferRate()), true, energyType)) <= 0) continue;
                powerSorting.put(con, tempR);
                sum += tempR;
            }
            if (sum > 0) {
                for (ImmersiveNetHandler.AbstractConnection con : powerSorting.keySet()) {
                    int tempR;
                    end = ApiUtils.toIIC(con.end, this.field_145850_b);
                    if (con.cableType == null || end == null) continue;
                    float prio = (float)((Integer)powerSorting.get(con)).intValue() / (float)sum;
                    int output = (int)((float)powerForSort * prio);
                    int r = tempR = end.outputEnergy(Math.min(output, con.cableType.getTransferRate()), true, energyType);
                    int maxInput = this.getMaxInput();
                    tempR -= (int)Math.max(0.0, Math.floor((float)tempR * con.getPreciseLossRate(tempR, maxInput)));
                    end.outputEnergy(tempR, simulate, energyType);
                    HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
                    float intermediaryLoss = 0.0f;
                    for (ImmersiveNetHandler.Connection sub : con.subConnections) {
                        float length = (float)sub.length / (float)sub.cableType.getMaxLength();
                        float baseLoss = (float)sub.cableType.getLossRatio();
                        float mod = (float)(maxInput - tempR) / (float)maxInput / 0.25f * 0.1f;
                        intermediaryLoss = MathHelper.func_76131_a((float)(intermediaryLoss + length * (baseLoss + baseLoss * mod)), (float)0.0f, (float)1.0f);
                        int transferredPerCon = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).containsKey(sub) ? ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).get(sub) : 0;
                        transferredPerCon += r;
                        if (simulate) continue;
                        ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).put(sub, transferredPerCon);
                        IImmersiveConnectable subStart = ApiUtils.toIIC(sub.start, this.field_145850_b);
                        IImmersiveConnectable subEnd = ApiUtils.toIIC(sub.end, this.field_145850_b);
                        if (subStart != null && passedConnectors.add(subStart)) {
                            subStart.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                        }
                        if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                        subEnd.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                    }
                    received += r;
                    if ((powerLeft -= r) > 0) continue;
                    break;
                }
            }
        }
        return received;
    }

    public int getMaxInput() {
        return connectorInputValues[0];
    }

    public int getMaxOutput() {
        return connectorInputValues[0];
    }

    @Override
    public float[] getBlockBounds() {
        float length = this instanceof TileEntityRelayHV ? 0.875f : (this instanceof TileEntityConnectorHV ? 0.75f : (this instanceof TileEntityConnectorMV ? 0.5625f : 0.5f));
        float wMin = this instanceof TileEntityConnectorStructural ? 0.25f : 0.3125f;
        float wMax = this instanceof TileEntityConnectorStructural ? 0.75f : 0.6875f;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

